/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller.admin;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.filter.FilterFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.helper.UniqueValuesHelper;
import org.tailormap.api.persistence.json.TMAttributeDescriptor;
import org.tailormap.api.repository.FeatureTypeRepository;
import org.tailormap.api.viewer.model.ErrorResponse;
import org.tailormap.api.viewer.model.UniqueValuesResponse;

@RestController
public class UniqueValuesAdminController {
    private final FeatureTypeRepository featureTypeRepository;
    private final FeatureSourceFactoryHelper featureSourceFactoryHelper;
    @Value(value="${tailormap-api.unique.use_geotools_unique_function:true}")
    private boolean useGeotoolsUniqueFunction;
    private final FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());

    public UniqueValuesAdminController(FeatureTypeRepository featureTypeRepository, FeatureSourceFactoryHelper featureSourceFactoryHelper) {
        this.featureTypeRepository = featureTypeRepository;
        this.featureSourceFactoryHelper = featureSourceFactoryHelper;
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    public ResponseEntity<?> handleException(ResponseStatusException ex) {
        return ResponseEntity.status((HttpStatusCode)ex.getStatusCode()).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().message(ex.getReason() != null ? ex.getReason() : ex.getBody().getTitle()).code(Integer.valueOf(ex.getStatusCode().value())));
    }

    @GetMapping(path={"${tailormap-api.admin.base-path}/unique-values/{featureTypeId}/{attributeName}"}, produces={"application/json"})
    public ResponseEntity<Serializable> getUniqueValues(@PathVariable Long featureTypeId, @PathVariable String attributeName, @RequestParam(required=false) String filter) throws ResponseStatusException {
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Attribute name is required");
        }
        TMFeatureType tmft = (TMFeatureType)this.featureTypeRepository.findById((Object)featureTypeId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Feature type not found"));
        if (tmft.getAttributeByName(attributeName).isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Attribute does not exist, available attributes: " + String.valueOf(tmft.getAttributes().stream().map(TMAttributeDescriptor::getName).toList()));
        }
        UniqueValuesResponse response = UniqueValuesHelper.getUniqueValues((TMFeatureType)tmft, (String)attributeName, (String)filter, (FilterFactory)this.ff, (FeatureSourceFactoryHelper)this.featureSourceFactoryHelper, (Boolean)this.useGeotoolsUniqueFunction);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)response);
    }
}

