/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.drawing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.invoke.MethodHandles;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.JdbcClient;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.drawing.DrawingService;
import org.tailormap.api.security.TailormapUserDetails;
import org.tailormap.api.viewer.model.Drawing;

@Service
public class DrawingService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JdbcClient jdbcClient;
    private final RowMapper<Drawing> drawingRowMapper;
    private final ObjectMapper objectMapper;

    public DrawingService(JdbcClient jdbcClient, ObjectMapper objectMapper) {
        this.jdbcClient = jdbcClient;
        this.objectMapper = objectMapper;
        GenericConversionService conversionService = new GenericConversionService();
        DefaultConversionService.addDefaultConverters((ConverterRegistry)conversionService);
        conversionService.addConverter((Converter)new /* Unavailable Anonymous Inner Class!! */);
        conversionService.addConverter((Converter)new /* Unavailable Anonymous Inner Class!! */);
        this.drawingRowMapper = new /* Unavailable Anonymous Inner Class!! */;
    }

    @Transactional
    public Drawing createDrawing(@NonNull Drawing drawing, @NonNull Authentication authentication) throws JsonProcessingException {
        this.canCreateDrawing(authentication);
        logger.trace("creating new drawing: {}, domainData {}, createdAt {}", new Object[]{drawing, this.objectMapper.writeValueAsString((Object)drawing.getDomainData()), OffsetDateTime.now(ZoneId.systemDefault())});
        Drawing storedDrawing = (Drawing)this.jdbcClient.sql("INSERT INTO data.drawing (name, description, domain_data, access, created_at, created_by,srid)\nVALUES (?, ?, ?::jsonb, ?, ?, ?, ?) RETURNING *\n").param((Object)drawing.getName()).param((Object)drawing.getDescription()).param((Object)this.objectMapper.writeValueAsString((Object)drawing.getDomainData())).param((Object)drawing.getAccess().getValue()).param((Object)OffsetDateTime.now(ZoneId.systemDefault())).param((Object)authentication.getName()).param((Object)drawing.getSrid()).query(this.drawingRowMapper).single();
        if (drawing.getFeatureCollection() != null) {
            ObjectNode featureCollection = this.insertGeoJsonFeatureCollection(storedDrawing.getId(), drawing.getSrid().intValue(), this.objectMapper.writeValueAsString(drawing.getFeatureCollection()));
            storedDrawing.setFeatureCollection((Object)featureCollection);
        }
        logger.trace("stored new drawing: {}", (Object)storedDrawing);
        return storedDrawing;
    }

    private ObjectNode insertGeoJsonFeatureCollection(UUID drawingId, int srid, String featureCollectionToStore) throws JsonProcessingException {
        List storedFeatures = this.jdbcClient.sql("WITH jsonData AS (SELECT :featureCollectionToStore::json AS featureCollection)\nINSERT INTO data.drawing_feature (drawing_id, geometry, properties)\nSELECT :drawingId::uuid AS drawing_id,\nST_SetSRID(ST_GeomFromGeoJSON(feature ->> 'geometry'), :srid) AS geometry,\nfeature -> 'properties' AS properties\nFROM (SELECT json_array_elements(featureCollection -> 'features') AS feature\nFROM jsonData)\nAS f\nRETURNING\n-- since we cannot use aggregate functions in a returning clause, we will return a list of geojson\n-- features and aggregate them into a featureCollection in the next step\nST_AsGeoJSON(data.drawing_feature.*, geom_column =>'geometry', id_column => 'id')::json;\n").param("featureCollectionToStore", (Object)featureCollectionToStore).param("drawingId", (Object)drawingId).param("srid", (Object)srid).query((RowMapper)new /* Unavailable Anonymous Inner Class!! */).list();
        return (ObjectNode)this.objectMapper.createObjectNode().put("type", "FeatureCollection").set("features", (JsonNode)this.objectMapper.createArrayNode().addAll((Collection)storedFeatures));
    }

    @Transactional
    public Drawing updateDrawing(@NonNull Drawing drawing, @NonNull Authentication authentication) throws JsonProcessingException {
        this.canSaveOrDeleteDrawing(drawing, authentication);
        logger.trace("updating drawing: {}, domainData {}, updatedAt {}", new Object[]{drawing, this.objectMapper.writeValueAsString((Object)drawing.getDomainData()), OffsetDateTime.now(ZoneId.systemDefault())});
        Drawing oldDrawing = (Drawing)this.getDrawing(drawing.getId(), authentication).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Drawing has been deleted by another user"));
        if (drawing.getVersion() < oldDrawing.getVersion()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Drawing has been updated by another user");
        }
        drawing.setVersion(Integer.valueOf(drawing.getVersion() + 1));
        Drawing updatedDrawing = (Drawing)this.jdbcClient.sql("UPDATE data.drawing SET\nid=:id,\nname=:name,\ndescription=:description,\ndomain_data=:domainData::jsonb,\naccess=:access,\ncreated_by=:createdBy,\ncreated_at=:createdAt,\nupdated_by=:updatedBy,\nupdated_at=:updatedAt,\nsrid=:srid,\nversion=:version\nWHERE id = :id RETURNING *").param("id", (Object)drawing.getId()).param("name", (Object)drawing.getName()).param("description", (Object)drawing.getDescription()).param("domainData", (Object)this.objectMapper.writeValueAsString((Object)drawing.getDomainData())).param("access", (Object)drawing.getAccess().getValue()).param("createdBy", (Object)drawing.getCreatedBy()).param("createdAt", (Object)drawing.getCreatedAt()).param("updatedBy", (Object)authentication.getName()).param("updatedAt", (Object)OffsetDateTime.now(ZoneId.systemDefault())).param("srid", (Object)drawing.getSrid()).param("version", (Object)drawing.getVersion()).query(this.drawingRowMapper).single();
        this.jdbcClient.sql("DELETE FROM data.drawing_feature WHERE drawing_id = ?").param((Object)drawing.getId()).update();
        if (drawing.getFeatureCollection() != null) {
            ObjectNode featureCollection = this.insertGeoJsonFeatureCollection(drawing.getId(), drawing.getSrid().intValue(), this.objectMapper.writeValueAsString(drawing.getFeatureCollection()));
            updatedDrawing.setFeatureCollection((Object)featureCollection);
        }
        logger.trace("stored updated drawing: {}", (Object)updatedDrawing);
        return updatedDrawing;
    }

    public Set<Drawing> getDrawingsForUser(Authentication authentication) throws ResponseStatusException {
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            return Set.of();
        }
        return this.jdbcClient.sql("SELECT * FROM data.drawing").query(this.drawingRowMapper).set().stream().filter(d -> {
            try {
                this.canReadDrawing(d, authentication);
                return true;
            }
            catch (ResponseStatusException e) {
                return false;
            }
        }).sorted(Comparator.comparing(Drawing::getCreatedAt)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Optional<Drawing> getDrawing(@NonNull UUID drawingId, @NonNull Authentication authentication) {
        return this.getDrawing(drawingId, authentication, false, 0);
    }

    @Transactional
    public Optional<Drawing> getDrawing(@NonNull UUID drawingId, @NonNull Authentication authentication, boolean withGeometries, int requestedSrid) {
        Optional<Drawing> drawing = this.jdbcClient.sql("SELECT * FROM data.drawing WHERE id = ?").param(1, (Object)drawingId).query(this.drawingRowMapper).stream().findFirst();
        drawing.ifPresent(d -> {
            this.canReadDrawing(d, authentication);
            d.setSrid(Integer.valueOf(requestedSrid));
            if (withGeometries) {
                d.setFeatureCollection((Object)this.getFeatureCollection(drawingId, requestedSrid));
            }
        });
        return drawing;
    }

    private JsonNode getFeatureCollection(UUID drawingId, int srid) {
        return (JsonNode)this.jdbcClient.sql("SELECT row_to_json(featureCollection) from (\nSELECT\n'FeatureCollection' AS type,\narray_to_json(array_agg(feature)) AS features FROM (\nSELECT\n'Feature' AS type,\nid as id,\nST_ASGeoJSON(ST_Transform(geomTable.geometry, :srid))::json AS geometry,\nrow_to_json((SELECT l from (SELECT id, drawing_id, properties) AS l)) AS properties\nFROM data.drawing_feature AS geomTable WHERE drawing_id = :drawingId::uuid) AS feature) AS featureCollection\n").param("drawingId", (Object)drawingId).param("srid", (Object)srid).query((RowMapper)new /* Unavailable Anonymous Inner Class!! */).single();
    }

    public void deleteDrawing(@NonNull UUID drawingId, @NonNull Authentication authentication) {
        this.canSaveOrDeleteDrawing((Drawing)this.getDrawing(drawingId, authentication).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Drawing not found")), authentication);
        this.jdbcClient.sql("DELETE FROM data.drawing WHERE id = ?").param((Object)drawingId).update();
    }

    private void canCreateDrawing(@NonNull Authentication authentication) throws ResponseStatusException {
        if (authentication instanceof AnonymousAuthenticationToken) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Insufficient permissions to create new drawing");
        }
    }

    private void canReadDrawing(@NonNull Drawing drawing, @NonNull Authentication authentication) throws ResponseStatusException {
        boolean canRead;
        boolean isAuthenticated = !(authentication instanceof AnonymousAuthenticationToken);
        switch (6.$SwitchMap$org$tailormap$api$viewer$model$Drawing$AccessEnum[drawing.getAccess().ordinal()]) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: {
                boolean bl;
                if (isAuthenticated) {
                    if (Objects.equals(authentication.getName(), drawing.getCreatedBy())) {
                        bl = true;
                        break;
                    }
                    Object object = authentication.getPrincipal();
                    if (object instanceof TailormapUserDetails) {
                        TailormapUserDetails userProperties = (TailormapUserDetails)object;
                        if (userProperties.hasTruePropertyForKey("drawings-admin") || userProperties.hasTruePropertyForKey("drawings-read-all")) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl = isAuthenticated;
                break;
            }
            case 3: {
                boolean bl = canRead = true;
            }
        }
        if (!canRead) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Insufficient permissions to access drawing");
        }
    }

    private void canSaveOrDeleteDrawing(@NonNull Drawing drawing, @NonNull Authentication authentication) throws ResponseStatusException {
        boolean canSave;
        if (authentication instanceof AnonymousAuthenticationToken) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Insufficient permissions to save drawing");
        }
        switch (6.$SwitchMap$org$tailormap$api$viewer$model$Drawing$AccessEnum[drawing.getAccess().ordinal()]) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: {
                boolean bl;
                if (Objects.equals(authentication.getName(), drawing.getCreatedBy())) {
                    bl = true;
                    break;
                }
                Object object = authentication.getPrincipal();
                if (object instanceof TailormapUserDetails) {
                    TailormapUserDetails userDetails = (TailormapUserDetails)object;
                    bl = userDetails.hasTruePropertyForKey("drawings-admin");
                    break;
                }
                bl = false;
                break;
            }
            case 2: 
            case 3: {
                boolean bl = canSave = true;
            }
        }
        if (!canSave) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Insufficient permissions to save drawing");
        }
    }
}

