/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.geotools.featuresources;

import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.dbcp.DelegatingConnection;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.jdbc.JDBCDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tailormap.api.geotools.featuresources.AttachmentsHelper;
import org.tailormap.api.geotools.featuresources.JDBCFeatureSourceHelper;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.json.JDBCConnectionProperties;
import org.tailormap.api.viewer.model.AttachmentMetadata;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AttachmentsHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern NUMERIC_WITH_IDENTITY = Pattern.compile("(?i)\\b(?:int|integer|bigint|smallint|numeric|decimal|number)(?:\\s*\\(\\s*\\d+(?:\\s*,\\s*\\d+)?\\s*\\))?\\s+identity\\b");
    private static final List<String> allowedPKTypesSupportingSize = List.of("CHARACTER", "CHARACTER VARYING", "CHAR", "VARCHAR", "NUMERIC", "DECIMAL", "NVARCHAR", "NCHAR", "VARCHAR2", "NVARCHAR2", "NUMBER", "RAW");

    private AttachmentsHelper() {
    }

    private static String getPostGISCreateAttachmentsTableStatement(String tableName, String pkColumnName, String fkColumnType, String typeModifier, String schemaPrefix) {
        if (!((String)schemaPrefix).isEmpty()) {
            schemaPrefix = (String)schemaPrefix + ".";
        }
        return MessageFormat.format("CREATE TABLE IF NOT EXISTS {4}{0}_attachments (\n{0}_pk          {2}{3}        NOT NULL REFERENCES {4}{0}({1}) ON DELETE CASCADE,\nattachment_id   UUID PRIMARY KEY DEFAULT gen_random_uuid(),\nfile_name       VARCHAR(255),\nattribute_name  VARCHAR(255) NOT NULL,\ndescription     TEXT,\nattachment      BYTEA        NOT NULL,\nattachment_size INTEGER      NOT NULL,\nmime_type       VARCHAR(100),\ncreated_at      TIMESTAMPTZ  NOT NULL DEFAULT CURRENT_TIMESTAMP,\ncreated_by      VARCHAR(255) NOT NULL)\n", tableName, pkColumnName, fkColumnType, typeModifier, schemaPrefix);
    }

    private static String getSQLServerCreateAttachmentsTableStatement(String tableName, String pkColumnName, String fkColumnType, String typeModifier, String schemaPrefix) {
        if (!((String)schemaPrefix).isEmpty()) {
            schemaPrefix = (String)schemaPrefix + ".";
        }
        return MessageFormat.format("IF OBJECT_ID(N''{4}{0}_attachments'', ''U'') IS NULL\nBEGIN\nCREATE TABLE {4}{0}_attachments (\n{0}_pk          {2}{3}         NOT NULL REFERENCES {4}{0}({1}) ON DELETE CASCADE,\nattachment_id   UNIQUEIDENTIFIER NOT NULL DEFAULT NEWID() PRIMARY KEY,\nfile_name       NVARCHAR(255),\nattribute_name  VARCHAR(255)    NOT NULL,\ndescription     NVARCHAR(MAX),\nattachment      VARBINARY(MAX)   NOT NULL,\nmime_type       NVARCHAR(100),\nattachment_size INT              NOT NULL,\ncreated_at      DATETIMEOFFSET   NOT NULL DEFAULT SYSDATETIMEOFFSET(),\ncreated_by      NVARCHAR(255)    NOT NULL)\nEND\n", tableName, pkColumnName, fkColumnType, typeModifier, schemaPrefix);
    }

    private static String getOracleCreateAttachmentsTableStatement(String tableName, String pkColumnName, String fkColumnType, String typeModifier, String schemaPrefix) {
        if (!((String)schemaPrefix).isEmpty()) {
            schemaPrefix = (String)schemaPrefix + ".";
        }
        return MessageFormat.format("CREATE TABLE IF NOT EXISTS {4}{0}_ATTACHMENTS (\n{0}_PK          {2}{3}      NOT NULL REFERENCES {4}{0}({1}) ON DELETE CASCADE,\nATTACHMENT_ID   RAW(16)       DEFAULT SYS_GUID() PRIMARY KEY,\nFILE_NAME       VARCHAR2(255),\nATTACHMENT      BLOB          NOT NULL,\nATTRIBUTE_NAME  VARCHAR2(255) NOT NULL,\nDESCRIPTION     CLOB,\nMIME_TYPE       VARCHAR2(100),\nATTACHMENT_SIZE INT           NOT NULL,\nCREATED_AT      TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP,\nCREATED_BY      VARCHAR2(255) NOT NULL)\n", tableName, pkColumnName, fkColumnType, typeModifier, schemaPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAttachmentTableForFeatureType(TMFeatureType featureType) throws IOException, SQLException, IllegalArgumentException {
        if (featureType == null || featureType.getSettings() == null || featureType.getSettings().getAttachmentAttributes() == null || featureType.getSettings().getAttachmentAttributes().isEmpty()) {
            throw new IllegalArgumentException("FeatureType " + (featureType != null ? featureType.getName() : "null") + " is invalid or has no attachment attributes defined in its settings");
        }
        featureType.getSettings().getAttachmentAttributes().stream().filter(attachmentAttributeType -> attachmentAttributeType.getAttributeName() == null || attachmentAttributeType.getAttributeName().isEmpty()).findAny().ifPresent(attachmentAttributeType -> {
            throw new IllegalArgumentException("FeatureType " + featureType.getName() + " has an attachment attribute with invalid (null or empty) attribute name");
        });
        logger.debug("Creating attachment table for FeatureType: {} and attachment names {}", (Object)featureType.getName(), (Object)featureType.getSettings().getAttachmentAttributes());
        JDBCDataStore ds = null;
        try {
            ds = (JDBCDataStore)new JDBCFeatureSourceHelper().createDataStore(featureType.getFeatureSource());
            try (Connection conn = ds.getDataSource().getConnection();
                 Statement stmt = conn.createStatement();){
                String sql = AttachmentsHelper.getCreateAttachmentsForFeatureTypeStatements((TMFeatureType)featureType, (JDBCDataStore)ds);
                logger.debug("About to create attachments table using statement:\n{}", (Object)sql);
                stmt.execute(sql);
                logger.info("Attachment table created for FeatureType: {}", (Object)featureType.getName());
                sql = AttachmentsHelper.getCreateAttachmentsIndexForFeatureTypeStatements((TMFeatureType)featureType, (JDBCDataStore)ds);
                logger.debug("About to create attachments table FK index using statement:\n{}", (Object)sql);
                stmt.execute(sql);
                logger.info("Attachment table FK index created for FeatureType: {}", (Object)featureType.getName());
            }
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropAttachmentTableForFeatureType(TMFeatureType featureType) throws IOException, SQLException {
        JDBCDataStore ds = null;
        try {
            ds = (JDBCDataStore)new JDBCFeatureSourceHelper().createDataStore(featureType.getFeatureSource());
            Object schemaPrefix = ds.getDatabaseSchema();
            if (!((String)schemaPrefix).isEmpty()) {
                schemaPrefix = (String)schemaPrefix + ".";
            }
            String dropSql = MessageFormat.format("DROP TABLE {1}{0}_attachments", featureType.getName(), schemaPrefix);
            logger.debug("About to drop attachments table using statement:\n{}", (Object)dropSql);
            try (Connection conn = ds.getDataSource().getConnection();
                 Statement stmt = conn.createStatement();){
                stmt.execute(dropSql);
                logger.info("Attachment table dropped for FeatureType: {}", (Object)featureType.getName());
            }
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
    }

    private static String getCreateAttachmentsForFeatureTypeStatements(TMFeatureType featureType, @NotNull JDBCDataStore ds) throws IOException, IllegalArgumentException, SQLException {
        String fkColumnType = null;
        int fkColumnSize = 0;
        AttributeDescriptor pkDescriptor = ds.getSchema(featureType.getName()).getDescriptor(featureType.getPrimaryKeyAttribute());
        try (Connection conn = ((DelegatingConnection)ds.getDataSource().getConnection()).getInnermostDelegate();){
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getColumns(conn.getCatalog(), ds.getDatabaseSchema(), featureType.getName(), featureType.getPrimaryKeyAttribute());){
                if (rs.next()) {
                    fkColumnType = rs.getString("TYPE_NAME");
                    fkColumnSize = rs.getInt("COLUMN_SIZE");
                }
            }
            if (fkColumnType == null) {
                rs = metaData.getColumns(conn.getCatalog(), ds.getDatabaseSchema(), featureType.getName().toUpperCase(Locale.ROOT), featureType.getPrimaryKeyAttribute().toUpperCase(Locale.ROOT));
                try {
                    if (rs.next()) {
                        fkColumnType = rs.getString("TYPE_NAME");
                        fkColumnSize = rs.getInt("COLUMN_SIZE");
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            if (fkColumnType == null) {
                fkColumnType = (String)pkDescriptor.getUserData().get("org.geotools.jdbc.nativeTypeName");
            }
        }
        String typeModifier = "";
        if (fkColumnSize > 0) {
            typeModifier = AttachmentsHelper.getValidModifier((String)fkColumnType, (int)fkColumnSize);
        }
        logger.debug("Creating attachment table for feature type with primary key {} (native type: {}, meta type: {}, size: {} (modifier: {}))", new Object[]{pkDescriptor.getLocalName(), fkColumnType, pkDescriptor.getUserData().get("org.geotools.jdbc.nativeTypeName"), fkColumnSize, typeModifier});
        JDBCConnectionProperties connProperties = featureType.getFeatureSource().getJdbcConnection();
        fkColumnType = AttachmentsHelper.getValidColumnType((String)fkColumnType, (JDBCConnectionProperties.DbtypeEnum)connProperties.getDbtype());
        switch (1.$SwitchMap$org$tailormap$api$persistence$json$JDBCConnectionProperties$DbtypeEnum[connProperties.getDbtype().ordinal()]) {
            case 1: {
                return AttachmentsHelper.getPostGISCreateAttachmentsTableStatement((String)featureType.getName(), (String)featureType.getPrimaryKeyAttribute(), (String)fkColumnType, (String)typeModifier, (String)ds.getDatabaseSchema());
            }
            case 2: {
                return AttachmentsHelper.getOracleCreateAttachmentsTableStatement((String)featureType.getName(), (String)featureType.getPrimaryKeyAttribute(), (String)fkColumnType, (String)typeModifier, (String)ds.getDatabaseSchema());
            }
            case 3: {
                return AttachmentsHelper.getSQLServerCreateAttachmentsTableStatement((String)featureType.getName(), (String)featureType.getPrimaryKeyAttribute(), (String)fkColumnType, (String)typeModifier, (String)ds.getDatabaseSchema());
            }
        }
        throw new IllegalArgumentException("Unsupported database type for attachments: " + String.valueOf(connProperties.getDbtype()));
    }

    private static String getValidColumnType(String columnType, JDBCConnectionProperties.DbtypeEnum dbtype) {
        if (dbtype.equals((Object)JDBCConnectionProperties.DbtypeEnum.SQLSERVER) && NUMERIC_WITH_IDENTITY.matcher(columnType).find()) {
            columnType = columnType.replaceAll("(?i)\\s+identity\\b", "");
        }
        return columnType;
    }

    private static String getValidModifier(String columnType, int fkColumnSize) {
        if (fkColumnSize > 0 && allowedPKTypesSupportingSize.contains(columnType.toUpperCase(Locale.ROOT))) {
            if (columnType.equalsIgnoreCase("NUMERIC") || columnType.equalsIgnoreCase("DECIMAL") || columnType.equalsIgnoreCase("NUMBER")) {
                return "(" + fkColumnSize + ",0)";
            }
            return "(" + fkColumnSize + ")";
        }
        return "";
    }

    private static String getCreateAttachmentsIndexForFeatureTypeStatements(TMFeatureType featureType, JDBCDataStore ds) throws IllegalArgumentException {
        Object schemaPrefix = ds.getDatabaseSchema();
        if (!((String)schemaPrefix).isEmpty()) {
            schemaPrefix = (String)schemaPrefix + ".";
        }
        JDBCConnectionProperties connProperties = featureType.getFeatureSource().getJdbcConnection();
        switch (1.$SwitchMap$org$tailormap$api$persistence$json$JDBCConnectionProperties$DbtypeEnum[connProperties.getDbtype().ordinal()]) {
            case 1: {
                return MessageFormat.format("CREATE INDEX IF NOT EXISTS {0}_attachments_fk ON {1}{0}_attachments({0}_pk)", featureType.getName(), schemaPrefix);
            }
            case 3: {
                return MessageFormat.format("IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name = ''{0}_attachments_fk'' AND object_id = OBJECT_ID(N''{1}{0}_attachments''))\nBEGIN\nCREATE INDEX {0}_attachments_fk ON {1}{0}_attachments({0}_pk)\nEND\n", featureType.getName(), schemaPrefix);
            }
            case 2: {
                return MessageFormat.format("CREATE INDEX IF NOT EXISTS {1}{0}_attachments_fk ON {1}{0}_attachments({0}_pk)", featureType.getName(), schemaPrefix).toUpperCase(Locale.ROOT);
            }
        }
        throw new IllegalArgumentException("Unsupported database type for attachments: " + String.valueOf(connProperties.getDbtype()));
    }

    private static byte[] asBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    /*
     * Exception decompiling
     */
    public static AttachmentMetadata insertAttachment(TMFeatureType featureType, AttachmentMetadata attachment, Object primaryKey, byte[] fileData) throws IOException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAttachment(UUID attachmentId, TMFeatureType featureType) throws IOException, SQLException {
        String deleteSql = MessageFormat.format("DELETE FROM {0}_attachments WHERE attachment_id = ?\n", featureType.getName());
        JDBCDataStore ds = null;
        try {
            ds = (JDBCDataStore)new JDBCFeatureSourceHelper().createDataStore(featureType.getFeatureSource());
            try (Connection conn = ds.getDataSource().getConnection();
                 PreparedStatement stmt = conn.prepareStatement(deleteSql);){
                if (featureType.getFeatureSource().getJdbcConnection().getDbtype().equals((Object)JDBCConnectionProperties.DbtypeEnum.ORACLE)) {
                    stmt.setBytes(1, AttachmentsHelper.asBytes((UUID)attachmentId));
                } else {
                    stmt.setObject(1, attachmentId);
                }
                stmt.executeUpdate();
            }
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AttachmentMetadata> listAttachmentsForFeature(TMFeatureType featureType, Object primaryKey) throws IOException, SQLException {
        ArrayList<AttachmentMetadata> attachments = new ArrayList<AttachmentMetadata>();
        JDBCDataStore ds = null;
        try {
            ds = (JDBCDataStore)new JDBCFeatureSourceHelper().createDataStore(featureType.getFeatureSource());
            String querySql = MessageFormat.format("SELECT\n{0}_pk,\nattachment_id,\nfile_name,\nattribute_name,\ndescription,\nattachment_size,\nmime_type,\ncreated_at,\ncreated_by\nFROM {1}{0}_attachments WHERE {0}_pk = ?\n", featureType.getName(), ds.getDatabaseSchema().isEmpty() ? "" : ds.getDatabaseSchema() + ".");
            try (Connection conn = ds.getDataSource().getConnection();
                 PreparedStatement stmt = conn.prepareStatement(querySql);){
                stmt.setObject(1, primaryKey);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        AttachmentMetadata a = AttachmentsHelper.getAttachmentMetadata((ResultSet)rs);
                        attachments.add(a);
                    }
                }
            }
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        return attachments;
    }

    /*
     * Exception decompiling
     */
    public static AttachmentWithBinary getAttachment(TMFeatureType featureType, UUID attachmentId) throws IOException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<@NotNull Object, List<AttachmentMetadata>> listAttachmentsForFeaturesByFeatureId(TMFeatureType featureType, List<Object> featurePKs) throws IOException {
        ArrayList<AttachmentMetadataListItem> attachments = new ArrayList<AttachmentMetadataListItem>();
        if (featurePKs == null || featurePKs.isEmpty()) {
            return new HashMap<Object, List<AttachmentMetadata>>();
        }
        JDBCDataStore ds = null;
        try {
            ds = (JDBCDataStore)new JDBCFeatureSourceHelper().createDataStore(featureType.getFeatureSource());
            String querySql = MessageFormat.format("SELECT\n{0}_pk,\nattachment_id,\nfile_name,\nattribute_name,\ndescription,\nattachment_size,\nmime_type,\ncreated_at,\ncreated_by\nFROM {2}{0}_attachments WHERE {0}_pk IN ( {1} )\n", featureType.getName(), String.join((CharSequence)", ", (CharSequence[])featurePKs.stream().map(id -> "?").toArray(String[]::new)), ds.getDatabaseSchema().isEmpty() ? "" : ds.getDatabaseSchema() + ".");
            try (Connection conn = ds.getDataSource().getConnection();
                 PreparedStatement stmt = conn.prepareStatement(querySql);){
                Object firstPK = featurePKs.getFirst();
                boolean isUUID = firstPK instanceof UUID;
                boolean isByteBuffer = firstPK instanceof ByteBuffer;
                switch (1.$SwitchMap$org$tailormap$api$persistence$json$JDBCConnectionProperties$DbtypeEnum[featureType.getFeatureSource().getJdbcConnection().getDbtype().ordinal()]) {
                    case 2: {
                        int i;
                        for (i = 0; i < featurePKs.size(); ++i) {
                            if (isUUID) {
                                stmt.setBytes(i + 1, AttachmentsHelper.asBytes((UUID)((UUID)featurePKs.get(i))));
                                continue;
                            }
                            if (isByteBuffer) {
                                stmt.setBytes(i + 1, ((ByteBuffer)featurePKs.get(i)).array());
                                continue;
                            }
                            stmt.setObject(i + 1, featurePKs.get(i));
                        }
                        break;
                    }
                    case 3: {
                        int i;
                        for (i = 0; i < featurePKs.size(); ++i) {
                            if (isUUID) {
                                stmt.setString(i + 1, featurePKs.get(i).toString().toUpperCase(Locale.ROOT));
                                continue;
                            }
                            stmt.setObject(i + 1, featurePKs.get(i));
                        }
                        break;
                    }
                    case 1: {
                        int i;
                        for (i = 0; i < featurePKs.size(); ++i) {
                            stmt.setObject(i + 1, featurePKs.get(i));
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported database type: " + String.valueOf(featureType.getFeatureSource().getJdbcConnection().getDbtype()));
                    }
                }
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        AttachmentMetadata a = AttachmentsHelper.getAttachmentMetadata((ResultSet)rs);
                        Object keyObject = rs.getObject(1);
                        if (isUUID && featureType.getFeatureSource().getJdbcConnection().getDbtype().equals((Object)JDBCConnectionProperties.DbtypeEnum.ORACLE)) {
                            byte[] rawBytes = rs.getBytes(1);
                            ByteBuffer bb = ByteBuffer.wrap(rawBytes);
                            keyObject = new UUID(bb.getLong(), bb.getLong());
                        } else if (isUUID && featureType.getFeatureSource().getJdbcConnection().getDbtype().equals((Object)JDBCConnectionProperties.DbtypeEnum.SQLSERVER)) {
                            keyObject = UUID.fromString(rs.getString(1));
                        }
                        if (isByteBuffer) {
                            assert (keyObject instanceof byte[]);
                            keyObject = ByteBuffer.wrap((byte[])keyObject);
                        }
                        attachments.add(new AttachmentMetadataListItem(keyObject, a));
                    }
                }
            }
            catch (SQLException ex) {
                logger.error("Failed to get attachments for %s".formatted(featureType.getName()), (Throwable)ex);
            }
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        logger.debug("Found {} attachments for {} features (features: {}, attachments: {})", new Object[]{attachments.size(), featurePKs.size(), featurePKs, attachments.toArray()});
        return attachments.stream().collect(Collectors.groupingBy(AttachmentMetadataListItem::key, Collectors.mapping(AttachmentMetadataListItem::value, Collectors.toList())));
    }

    private static AttachmentMetadata getAttachmentMetadata(ResultSet rs) throws SQLException {
        AttachmentMetadata a = new AttachmentMetadata();
        Object idObj = rs.getObject("attachment_id");
        if (idObj instanceof UUID) {
            UUID u = (UUID)idObj;
            a.setAttachmentId(u);
        } else if (idObj instanceof byte[]) {
            byte[] b = (byte[])idObj;
            ByteBuffer bb = ByteBuffer.wrap(b);
            a.setAttachmentId(new UUID(bb.getLong(), bb.getLong()));
        } else {
            String s = rs.getString("attachment_id");
            if (s != null && !s.isEmpty()) {
                a.setAttachmentId(UUID.fromString(s));
            }
        }
        a.setFileName(rs.getString("file_name"));
        a.setAttributeName(rs.getString("attribute_name"));
        a.setDescription(rs.getString("description"));
        long size = rs.getLong("attachment_size");
        if (!rs.wasNull()) {
            a.setAttachmentSize(Long.valueOf(size));
        }
        a.setMimeType(rs.getString("mime_type"));
        Timestamp ts = rs.getTimestamp("created_at");
        if (ts != null) {
            a.setCreatedAt(OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.of("UTC")));
        }
        a.setCreatedBy(rs.getString("created_by"));
        return a;
    }
}

