/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.hypersistence.tsid.TSID;
import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import jakarta.validation.constraints.NotNull;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.springframework.lang.NonNull;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;
import org.tailormap.api.persistence.AuditMetadata;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.helper.GeoServiceHelper;
import org.tailormap.api.persistence.json.AuthorizationRule;
import org.tailormap.api.persistence.json.GeoServiceDefaultLayerSettings;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.persistence.json.GeoServiceLayerSettings;
import org.tailormap.api.persistence.json.GeoServiceProtocol;
import org.tailormap.api.persistence.json.GeoServiceSettings;
import org.tailormap.api.persistence.json.ServiceAuthentication;
import org.tailormap.api.persistence.json.TMServiceCaps;
import org.tailormap.api.persistence.listener.EntityEventPublisher;
import org.tailormap.api.repository.FeatureSourceRepository;
import org.tailormap.api.util.TMStringUtils;
import org.tailormap.api.viewer.model.Service;

@Audited
@Entity
@EntityListeners(value={EntityEventPublisher.class, AuditingEntityListener.class})
@EnhancementInfo(version="6.6.35.Final")
public class GeoService
extends AuditMetadata
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final List<String> REMOVE_PARAMS = List.of("REQUEST");
    @Id
    String id;
    @Version
    Long version;
    @Column(columnDefinition="text")
    String notes;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    GeoServiceProtocol protocol;
    @NotNull
    @Column(length=2048)
    String url;
    @Transient
    private boolean refreshCapabilities;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    ServiceAuthentication authentication;
    @NotAudited
    @Basic(fetch=FetchType.LAZY)
    @JsonIgnore
    byte[] capabilities;
    String capabilitiesContentType;
    Instant capabilitiesFetched;
    @NotNull
    @Column(length=2048)
    String title;
    @Column(length=2048)
    String advertisedUrl;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    TMServiceCaps serviceCapabilities;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    List<AuthorizationRule> authorizationRules;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    List<GeoServiceLayer> layers;
    boolean published;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    GeoServiceSettings settings;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public GeoService() {
        this.$$_hibernate_write_authorizationRules(new ArrayList());
        this.$$_hibernate_write_layers(new ArrayList());
        this.$$_hibernate_write_settings(new GeoServiceSettings());
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public GeoService setId(String id) {
        this.$$_hibernate_write_id(id);
        return this;
    }

    public Long getVersion() {
        return this.$$_hibernate_read_version();
    }

    public GeoService setVersion(Long version) {
        this.$$_hibernate_write_version(version);
        return this;
    }

    public String getNotes() {
        return this.$$_hibernate_read_notes();
    }

    public GeoService setNotes(String adminComments) {
        this.$$_hibernate_write_notes(adminComments);
        return this;
    }

    public GeoServiceProtocol getProtocol() {
        return this.$$_hibernate_read_protocol();
    }

    public GeoService setProtocol(GeoServiceProtocol protocol) {
        this.$$_hibernate_write_protocol(protocol);
        return this;
    }

    public String getUrl() {
        return this.$$_hibernate_read_url();
    }

    public GeoService setUrl(String url) {
        this.$$_hibernate_write_url(this.sanitiseUrl(url));
        return this;
    }

    public boolean isRefreshCapabilities() {
        return this.refreshCapabilities;
    }

    public void setRefreshCapabilities(boolean refreshCapabilities) {
        this.refreshCapabilities = refreshCapabilities;
    }

    public ServiceAuthentication getAuthentication() {
        return this.$$_hibernate_read_authentication();
    }

    public GeoService setAuthentication(ServiceAuthentication authentication) {
        this.$$_hibernate_write_authentication(authentication);
        return this;
    }

    public byte[] getCapabilities() {
        return this.$$_hibernate_read_capabilities();
    }

    public GeoService setCapabilities(byte[] capabilities) {
        this.$$_hibernate_write_capabilities(capabilities);
        return this;
    }

    public String getCapabilitiesContentType() {
        return this.$$_hibernate_read_capabilitiesContentType();
    }

    public GeoService setCapabilitiesContentType(String capabilitiesContentType) {
        this.$$_hibernate_write_capabilitiesContentType(capabilitiesContentType);
        return this;
    }

    public Instant getCapabilitiesFetched() {
        return this.$$_hibernate_read_capabilitiesFetched();
    }

    public GeoService setCapabilitiesFetched(Instant capabilitiesFetched) {
        this.$$_hibernate_write_capabilitiesFetched(capabilitiesFetched);
        return this;
    }

    public String getTitle() {
        return this.$$_hibernate_read_title();
    }

    public GeoService setTitle(String title) {
        this.$$_hibernate_write_title(title);
        return this;
    }

    public String getAdvertisedUrl() {
        return this.$$_hibernate_read_advertisedUrl();
    }

    public GeoService setAdvertisedUrl(String advertisedUrl) {
        this.$$_hibernate_write_advertisedUrl(advertisedUrl);
        return this;
    }

    public TMServiceCaps getServiceCapabilities() {
        return this.$$_hibernate_read_serviceCapabilities();
    }

    public GeoService setServiceCapabilities(TMServiceCaps serviceCapabilities) {
        this.$$_hibernate_write_serviceCapabilities(serviceCapabilities);
        return this;
    }

    public List<AuthorizationRule> getAuthorizationRules() {
        return this.$$_hibernate_read_authorizationRules();
    }

    public GeoService setAuthorizationRules(List<AuthorizationRule> authorizationRules) {
        this.$$_hibernate_write_authorizationRules(authorizationRules);
        return this;
    }

    public List<GeoServiceLayer> getLayers() {
        return this.$$_hibernate_read_layers();
    }

    public GeoService setLayers(List<GeoServiceLayer> layers) {
        this.$$_hibernate_write_layers(layers);
        return this;
    }

    public boolean isPublished() {
        return this.$$_hibernate_read_published();
    }

    public GeoService setPublished(boolean published) {
        this.$$_hibernate_write_published(published);
        return this;
    }

    public GeoServiceSettings getSettings() {
        return this.$$_hibernate_read_settings();
    }

    public GeoService setSettings(GeoServiceSettings settings) {
        this.$$_hibernate_write_settings(settings);
        return this;
    }

    @PrePersist
    public void assignId() {
        if (StringUtils.isBlank((CharSequence)this.getId())) {
            this.setId(TSID.fast().toString());
        }
    }

    public Service.ServerTypeEnum getResolvedServerType() {
        if (this.$$_hibernate_read_settings().getServerType() == GeoServiceSettings.ServerTypeEnum.AUTO) {
            return GeoServiceHelper.guessServerTypeFromUrl((String)this.getUrl());
        }
        return Service.ServerTypeEnum.fromValue((String)this.$$_hibernate_read_settings().getServerType().getValue());
    }

    public Service toJsonPojo(GeoServiceHelper geoServiceHelper) {
        Service s = new Service().id(this.$$_hibernate_read_id()).title(this.$$_hibernate_read_title()).url(Boolean.TRUE.equals(this.getSettings().getUseProxy()) ? null : this.$$_hibernate_read_url()).protocol(this.$$_hibernate_read_protocol()).serverType(this.getResolvedServerType());
        if (this.$$_hibernate_read_protocol() == GeoServiceProtocol.WMTS) {
            s.capabilities(new String(this.getCapabilities(), StandardCharsets.UTF_8));
        }
        return s;
    }

    public GeoServiceLayer findLayer(String name) {
        return this.getLayers().stream().filter(sl -> name.equals(sl.getName())).findFirst().orElse(null);
    }

    public GeoServiceLayerSettings getLayerSettings(String layerName) {
        return (GeoServiceLayerSettings)this.getSettings().getLayerSettings().get(layerName);
    }

    @NonNull
    public String getTitleWithSettingsOverrides(String layerName) {
        String title = Optional.ofNullable(this.getLayerSettings(layerName)).map(GeoServiceLayerSettings::getTitle).map(TMStringUtils::nullIfEmpty).orElse(null);
        if (title == null) {
            title = Optional.ofNullable(this.findLayer(layerName)).map(GeoServiceLayer::getTitle).map(TMStringUtils::nullIfEmpty).orElse(null);
        }
        if (title == null) {
            title = layerName;
        }
        return title;
    }

    public TMFeatureType findFeatureTypeForLayer(GeoServiceLayer layer, FeatureSourceRepository featureSourceRepository) {
        String shortFeatureTypeName;
        String[] split;
        String featureTypeName;
        GeoServiceDefaultLayerSettings defaultLayerSettings = this.getSettings().getDefaultLayerSettings();
        GeoServiceLayerSettings layerSettings = this.getLayerSettings(layer.getName());
        Long featureSourceId = null;
        if (layerSettings != null && layerSettings.getFeatureType() != null) {
            featureTypeName = Optional.ofNullable(layerSettings.getFeatureType().getFeatureTypeName()).orElse(layer.getName());
            featureSourceId = layerSettings.getFeatureType().getFeatureSourceId();
        } else {
            featureTypeName = layer.getName();
        }
        if (featureSourceId == null && defaultLayerSettings != null && defaultLayerSettings.getFeatureType() != null) {
            featureSourceId = defaultLayerSettings.getFeatureType().getFeatureSourceId();
        }
        if (featureTypeName == null) {
            return null;
        }
        TMFeatureSource tmfs = null;
        TMFeatureType tmft = null;
        if (featureSourceId == null) {
            List linkedSources = featureSourceRepository.findByLinkedServiceId(this.getId());
            for (TMFeatureSource linkedFs : linkedSources) {
                tmft = linkedFs.findFeatureTypeByName(featureTypeName);
                if (tmft == null) continue;
                tmfs = linkedFs;
                break;
            }
        } else {
            tmfs = featureSourceRepository.findById(featureSourceId).orElse(null);
            if (tmfs != null) {
                tmft = tmfs.findFeatureTypeByName(featureTypeName);
            }
        }
        if (tmfs == null) {
            return null;
        }
        if (tmft == null && (split = featureTypeName.split(":", 2)).length == 2 && (tmft = tmfs.findFeatureTypeByName(shortFeatureTypeName = split[1])) != null) {
            logger.debug("Did not find feature type with full name \"{}\", using \"{}\" of feature source {}", new Object[]{featureTypeName, shortFeatureTypeName, tmfs});
        }
        return tmft;
    }

    private String sanitiseUrl(String url) {
        if (url != null && url.contains("?")) {
            LinkedMultiValueMap sanitisedParams = new LinkedMultiValueMap();
            UriComponentsBuilder uri = UriComponentsBuilder.fromUriString((String)url);
            MultiValueMap requestParams = uri.build().getQueryParams();
            for (Map.Entry param : requestParams.entrySet()) {
                if (REMOVE_PARAMS.contains(((String)param.getKey()).toUpperCase(Locale.ROOT))) continue;
                sanitisedParams.put((Object)((String)param.getKey()), (Object)((List)param.getValue()));
            }
            url = uri.replaceQueryParams((MultiValueMap)sanitisedParams).build().toUriString();
            if (url.endsWith("?")) {
                url = url.substring(0, url.length() - 1);
            }
        }
        return url;
    }

    public GeoServiceLayer getParentLayer(String layerId) {
        for (GeoServiceLayer layer : this.getLayers()) {
            if (!layer.getChildren().contains(layerId)) continue;
            return layer;
        }
        return null;
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        GeoService geoService = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block4: {
            int n2;
            block5: {
                GeoService geoService = this;
                GeoService geoService2 = geoService;
                n2 = 0;
                if (n2 == 0 && geoService.$$_hibernate_collectionTracker != null) {
                    int n3 = geoService.$$_hibernate_collectionTracker.getSize("authorizationRules");
                    if (geoService.authorizationRules == null && n3 != -1) {
                        n2 = 1;
                    } else if (geoService.authorizationRules != null && (!(geoService.authorizationRules instanceof PersistentCollection) || ((PersistentCollection)geoService.authorizationRules).wasInitialized()) && n3 != geoService.authorizationRules.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block4;
                n2 = this.$$_hibernate_collectionTracker.getSize("layers");
                if (this.layers != null || n2 == -1) break block5;
                n = 1;
                break block4;
            }
            if (this.layers == null || this.layers instanceof PersistentCollection && !((PersistentCollection)this.layers).wasInitialized() || n2 == this.layers.size()) break block4;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block4: {
            int n;
            block5: {
                GeoService geoService = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                GeoService geoService2 = geoService;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                if (geoService.$$_hibernate_collectionTracker != null) {
                    int n2 = geoService.$$_hibernate_collectionTracker.getSize("authorizationRules");
                    if (geoService.authorizationRules == null && n2 != -1) {
                        dirtyTracker2.add("authorizationRules");
                    } else if (geoService.authorizationRules != null && (!(geoService.authorizationRules instanceof PersistentCollection) || ((PersistentCollection)geoService.authorizationRules).wasInitialized()) && n2 != geoService.authorizationRules.size()) {
                        dirtyTracker2.add("authorizationRules");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block4;
                n = this.$$_hibernate_collectionTracker.getSize("layers");
                if (this.layers != null || n == -1) break block5;
                dirtyTracker.add("layers");
                break block4;
            }
            if (this.layers == null || this.layers instanceof PersistentCollection && !((PersistentCollection)this.layers).wasInitialized() || n == this.layers.size()) break block4;
            dirtyTracker.add("layers");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block6: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            GeoService geoService = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            GeoService geoService2 = geoService;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("authorizationRules")) {
                if (geoService.authorizationRules == null || geoService.authorizationRules instanceof PersistentCollection && !((PersistentCollection)geoService.authorizationRules).wasInitialized()) {
                    geoService.$$_hibernate_collectionTracker.add("authorizationRules", -1);
                } else {
                    geoService.$$_hibernate_collectionTracker.add("authorizationRules", geoService.authorizationRules.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("layers")) break block6;
            if (this.layers == null || this.layers instanceof PersistentCollection && !((PersistentCollection)this.layers).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("layers", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("layers", this.layers.size());
            }
        }
    }

    public String $$_hibernate_read_createdBy() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_createdBy((String)this.$$_hibernate_getInterceptor().readObject((Object)this, "createdBy", (Object)super.$$_hibernate_read_createdBy()));
        }
        return super.$$_hibernate_read_createdBy();
    }

    public void $$_hibernate_write_createdBy(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"createdBy", (Object)string, (Object)this.$$_hibernate_read_createdBy())) {
            this.$$_hibernate_trackChange("createdBy");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_createdBy((String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "createdBy", (Object)super.$$_hibernate_read_createdBy(), (Object)string));
            return;
        }
        super.$$_hibernate_write_createdBy(string);
    }

    public String $$_hibernate_read_lastModifiedBy() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_lastModifiedBy((String)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastModifiedBy", (Object)super.$$_hibernate_read_lastModifiedBy()));
        }
        return super.$$_hibernate_read_lastModifiedBy();
    }

    public void $$_hibernate_write_lastModifiedBy(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"lastModifiedBy", (Object)string, (Object)this.$$_hibernate_read_lastModifiedBy())) {
            this.$$_hibernate_trackChange("lastModifiedBy");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_lastModifiedBy((String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastModifiedBy", (Object)super.$$_hibernate_read_lastModifiedBy(), (Object)string));
            return;
        }
        super.$$_hibernate_write_lastModifiedBy(string);
    }

    public Instant $$_hibernate_read_createdDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_createdDate((Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "createdDate", (Object)super.$$_hibernate_read_createdDate()));
        }
        return super.$$_hibernate_read_createdDate();
    }

    public void $$_hibernate_write_createdDate(Instant instant) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"createdDate", (Object)instant, (Object)this.$$_hibernate_read_createdDate())) {
            this.$$_hibernate_trackChange("createdDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_createdDate((Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "createdDate", (Object)super.$$_hibernate_read_createdDate(), (Object)instant));
            return;
        }
        super.$$_hibernate_write_createdDate(instant);
    }

    public Instant $$_hibernate_read_lastModifiedDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_lastModifiedDate((Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastModifiedDate", (Object)super.$$_hibernate_read_lastModifiedDate()));
        }
        return super.$$_hibernate_read_lastModifiedDate();
    }

    public void $$_hibernate_write_lastModifiedDate(Instant instant) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"lastModifiedDate", (Object)instant, (Object)this.$$_hibernate_read_lastModifiedDate())) {
            this.$$_hibernate_trackChange("lastModifiedDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_lastModifiedDate((Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastModifiedDate", (Object)super.$$_hibernate_read_lastModifiedDate(), (Object)instant));
            return;
        }
        super.$$_hibernate_write_lastModifiedDate(instant);
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"version", (Object)l, (Object)this.version)) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)this.version, (Object)l);
            return;
        }
        this.version = l;
    }

    public String $$_hibernate_read_notes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "notes", (Object)this.notes);
        }
        return this.notes;
    }

    public void $$_hibernate_write_notes(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"notes", (Object)string, (Object)this.notes)) {
            this.$$_hibernate_trackChange("notes");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "notes", (Object)this.notes, (Object)string);
            return;
        }
        this.notes = string;
    }

    public GeoServiceProtocol $$_hibernate_read_protocol() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.protocol = (GeoServiceProtocol)this.$$_hibernate_getInterceptor().readObject((Object)this, "protocol", (Object)this.protocol);
        }
        return this.protocol;
    }

    public void $$_hibernate_write_protocol(GeoServiceProtocol geoServiceProtocol) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"protocol", (Object)geoServiceProtocol, (Object)this.protocol)) {
            this.$$_hibernate_trackChange("protocol");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.protocol = (GeoServiceProtocol)this.$$_hibernate_getInterceptor().writeObject((Object)this, "protocol", (Object)this.protocol, (Object)geoServiceProtocol);
            return;
        }
        this.protocol = geoServiceProtocol;
    }

    public String $$_hibernate_read_url() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.url = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "url", (Object)this.url);
        }
        return this.url;
    }

    public void $$_hibernate_write_url(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"url", (Object)string, (Object)this.url)) {
            this.$$_hibernate_trackChange("url");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.url = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "url", (Object)this.url, (Object)string);
            return;
        }
        this.url = string;
    }

    public ServiceAuthentication $$_hibernate_read_authentication() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authentication = (ServiceAuthentication)this.$$_hibernate_getInterceptor().readObject((Object)this, "authentication", (Object)this.authentication);
        }
        return this.authentication;
    }

    public void $$_hibernate_write_authentication(ServiceAuthentication serviceAuthentication) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"authentication", (Object)serviceAuthentication, (Object)this.authentication)) {
            this.$$_hibernate_trackChange("authentication");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authentication = (ServiceAuthentication)this.$$_hibernate_getInterceptor().writeObject((Object)this, "authentication", (Object)this.authentication, (Object)serviceAuthentication);
            return;
        }
        this.authentication = serviceAuthentication;
    }

    public byte[] $$_hibernate_read_capabilities() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.capabilities = (byte[])this.$$_hibernate_getInterceptor().readObject((Object)this, "capabilities", (Object)this.capabilities);
        }
        return this.capabilities;
    }

    public void $$_hibernate_write_capabilities(byte[] byArray) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"capabilities", (Object)byArray, (Object)this.capabilities)) {
            this.$$_hibernate_trackChange("capabilities");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.capabilities = (byte[])this.$$_hibernate_getInterceptor().writeObject((Object)this, "capabilities", (Object)this.capabilities, (Object)byArray);
            return;
        }
        this.capabilities = byArray;
    }

    public String $$_hibernate_read_capabilitiesContentType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.capabilitiesContentType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "capabilitiesContentType", (Object)this.capabilitiesContentType);
        }
        return this.capabilitiesContentType;
    }

    public void $$_hibernate_write_capabilitiesContentType(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"capabilitiesContentType", (Object)string, (Object)this.capabilitiesContentType)) {
            this.$$_hibernate_trackChange("capabilitiesContentType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.capabilitiesContentType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "capabilitiesContentType", (Object)this.capabilitiesContentType, (Object)string);
            return;
        }
        this.capabilitiesContentType = string;
    }

    public Instant $$_hibernate_read_capabilitiesFetched() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.capabilitiesFetched = (Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "capabilitiesFetched", (Object)this.capabilitiesFetched);
        }
        return this.capabilitiesFetched;
    }

    public void $$_hibernate_write_capabilitiesFetched(Instant instant) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"capabilitiesFetched", (Object)instant, (Object)this.capabilitiesFetched)) {
            this.$$_hibernate_trackChange("capabilitiesFetched");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.capabilitiesFetched = (Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "capabilitiesFetched", (Object)this.capabilitiesFetched, (Object)instant);
            return;
        }
        this.capabilitiesFetched = instant;
    }

    public String $$_hibernate_read_title() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.title = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "title", (Object)this.title);
        }
        return this.title;
    }

    public void $$_hibernate_write_title(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"title", (Object)string, (Object)this.title)) {
            this.$$_hibernate_trackChange("title");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.title = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "title", (Object)this.title, (Object)string);
            return;
        }
        this.title = string;
    }

    public String $$_hibernate_read_advertisedUrl() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.advertisedUrl = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "advertisedUrl", (Object)this.advertisedUrl);
        }
        return this.advertisedUrl;
    }

    public void $$_hibernate_write_advertisedUrl(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"advertisedUrl", (Object)string, (Object)this.advertisedUrl)) {
            this.$$_hibernate_trackChange("advertisedUrl");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.advertisedUrl = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "advertisedUrl", (Object)this.advertisedUrl, (Object)string);
            return;
        }
        this.advertisedUrl = string;
    }

    public TMServiceCaps $$_hibernate_read_serviceCapabilities() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceCapabilities = (TMServiceCaps)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceCapabilities", (Object)this.serviceCapabilities);
        }
        return this.serviceCapabilities;
    }

    public void $$_hibernate_write_serviceCapabilities(TMServiceCaps tMServiceCaps) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceCapabilities", (Object)tMServiceCaps, (Object)this.serviceCapabilities)) {
            this.$$_hibernate_trackChange("serviceCapabilities");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceCapabilities = (TMServiceCaps)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceCapabilities", (Object)this.serviceCapabilities, (Object)tMServiceCaps);
            return;
        }
        this.serviceCapabilities = tMServiceCaps;
    }

    public List $$_hibernate_read_authorizationRules() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authorizationRules = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "authorizationRules", (Object)this.authorizationRules);
        }
        return this.authorizationRules;
    }

    public void $$_hibernate_write_authorizationRules(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authorizationRules = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "authorizationRules", (Object)this.authorizationRules, (Object)list);
            return;
        }
        this.authorizationRules = list;
    }

    public List $$_hibernate_read_layers() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.layers = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "layers", (Object)this.layers);
        }
        return this.layers;
    }

    public void $$_hibernate_write_layers(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.layers = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "layers", (Object)this.layers, (Object)list);
            return;
        }
        this.layers = list;
    }

    public boolean $$_hibernate_read_published() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.published = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "published", this.published);
        }
        return this.published;
    }

    public void $$_hibernate_write_published(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"published", (boolean)bl, (boolean)this.published)) {
            this.$$_hibernate_trackChange("published");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.published = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "published", this.published, bl);
            return;
        }
        this.published = bl;
    }

    public GeoServiceSettings $$_hibernate_read_settings() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.settings = (GeoServiceSettings)this.$$_hibernate_getInterceptor().readObject((Object)this, "settings", (Object)this.settings);
        }
        return this.settings;
    }

    public void $$_hibernate_write_settings(GeoServiceSettings geoServiceSettings) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"settings", (Object)geoServiceSettings, (Object)this.settings)) {
            this.$$_hibernate_trackChange("settings");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.settings = (GeoServiceSettings)this.$$_hibernate_getInterceptor().writeObject((Object)this, "settings", (Object)this.settings, (Object)geoServiceSettings);
            return;
        }
        this.settings = geoServiceSettings;
    }
}

