/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.envers.Audited;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.tailormap.api.persistence.AuditMetadata;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.helper.TMAttributeTypeHelper;
import org.tailormap.api.persistence.json.FeatureTypeSettings;
import org.tailormap.api.persistence.json.TMAttributeDescriptor;
import org.tailormap.api.persistence.json.TMAttributeType;
import org.tailormap.api.persistence.json.TMFeatureTypeInfo;
import org.tailormap.api.persistence.listener.EntityEventPublisher;

@Audited
@Entity
@Table(name="feature_type")
@EntityListeners(value={EntityEventPublisher.class, AuditingEntityListener.class})
@EnhancementInfo(version="6.6.35.Final")
public class TMFeatureType
extends AuditMetadata
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    Long id;
    @Version
    Long version;
    @NotNull
    String name;
    @ManyToOne(optional=false)
    @JoinColumn(name="feature_source")
    TMFeatureSource featureSource;
    String title;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    TMFeatureTypeInfo info;
    @Column(columnDefinition="text")
    String comment;
    String owner;
    boolean writeable;
    String defaultGeometryAttribute;
    String primaryKeyAttribute;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    List<TMAttributeDescriptor> attributes;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    FeatureTypeSettings settings;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public TMFeatureType() {
        this.$$_hibernate_write_info(new TMFeatureTypeInfo());
        this.$$_hibernate_write_attributes(new ArrayList());
        this.$$_hibernate_write_settings(new FeatureTypeSettings());
    }

    public Long getId() {
        return this.$$_hibernate_read_id();
    }

    public TMFeatureType setId(Long id) {
        this.$$_hibernate_write_id(id);
        return this;
    }

    public Long getVersion() {
        return this.$$_hibernate_read_version();
    }

    public TMFeatureType setVersion(Long version) {
        this.$$_hibernate_write_version(version);
        return this;
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public TMFeatureType setName(String type) {
        this.$$_hibernate_write_name(type);
        return this;
    }

    public TMFeatureSource getFeatureSource() {
        return this.$$_hibernate_read_featureSource();
    }

    public TMFeatureType setFeatureSource(TMFeatureSource featureSource) {
        this.$$_hibernate_write_featureSource(featureSource);
        return this;
    }

    public String getTitle() {
        return this.$$_hibernate_read_title();
    }

    public TMFeatureType setTitle(String title) {
        this.$$_hibernate_write_title(title);
        return this;
    }

    public TMFeatureTypeInfo getInfo() {
        return this.$$_hibernate_read_info();
    }

    public TMFeatureType setInfo(TMFeatureTypeInfo info) {
        this.$$_hibernate_write_info(info);
        return this;
    }

    public String getComment() {
        return this.$$_hibernate_read_comment();
    }

    public TMFeatureType setComment(String comment) {
        this.$$_hibernate_write_comment(comment);
        return this;
    }

    public String getOwner() {
        return this.$$_hibernate_read_owner();
    }

    public TMFeatureType setOwner(String owner) {
        this.$$_hibernate_write_owner(owner);
        return this;
    }

    public boolean isWriteable() {
        return this.$$_hibernate_read_writeable();
    }

    public TMFeatureType setWriteable(boolean writeable) {
        this.$$_hibernate_write_writeable(writeable);
        return this;
    }

    public String getDefaultGeometryAttribute() {
        return this.$$_hibernate_read_defaultGeometryAttribute();
    }

    public TMFeatureType setDefaultGeometryAttribute(String defaultGeometryAttribute) {
        this.$$_hibernate_write_defaultGeometryAttribute(defaultGeometryAttribute);
        return this;
    }

    public String getPrimaryKeyAttribute() {
        return this.$$_hibernate_read_primaryKeyAttribute();
    }

    public TMFeatureType setPrimaryKeyAttribute(String primaryKeyAttribute) {
        this.$$_hibernate_write_primaryKeyAttribute(primaryKeyAttribute);
        return this;
    }

    public List<TMAttributeDescriptor> getAttributes() {
        return this.$$_hibernate_read_attributes();
    }

    public TMFeatureType setAttributes(List<TMAttributeDescriptor> attributes) {
        this.$$_hibernate_write_attributes(attributes);
        return this;
    }

    public FeatureTypeSettings getSettings() {
        return this.$$_hibernate_read_settings();
    }

    public TMFeatureType setSettings(FeatureTypeSettings settings) {
        this.$$_hibernate_write_settings(settings);
        return this;
    }

    public String findDefaultGeometryAttribute() {
        return this.getAttributes().stream().filter(a -> TMAttributeTypeHelper.isGeometry((TMAttributeType)a.getType())).findFirst().map(TMAttributeDescriptor::getName).orElse(null);
    }

    public List<String> getAllGeometryAttributeNames() {
        return this.getAttributes().stream().filter(a -> TMAttributeTypeHelper.isGeometry((TMAttributeType)a.getType())).map(TMAttributeDescriptor::getName).toList();
    }

    public Optional<TMAttributeDescriptor> getDefaultGeometryDescriptor() {
        return this.getAttributeByName(this.$$_hibernate_read_defaultGeometryAttribute());
    }

    public Optional<TMAttributeDescriptor> getAttributeByName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return this.getAttributes().stream().filter(a -> name.equals(a.getName())).findFirst();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        TMFeatureType tMFeatureType = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        boolean bl;
        block0: {
            int n;
            block1: {
                TMFeatureType tMFeatureType = this;
                bl = false;
                if (bl || this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("attributes");
                if (this.attributes != null || n == -1) break block1;
                bl = true;
                break block0;
            }
            if (this.attributes == null || this.attributes instanceof PersistentCollection && !((PersistentCollection)this.attributes).wasInitialized() || n == this.attributes.size()) break block0;
            bl = true;
        }
        return bl;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block0: {
            int n;
            block1: {
                TMFeatureType tMFeatureType = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                if (this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("attributes");
                if (this.attributes != null || n == -1) break block1;
                dirtyTracker.add("attributes");
                break block0;
            }
            if (this.attributes == null || this.attributes instanceof PersistentCollection && !((PersistentCollection)this.attributes).wasInitialized() || n == this.attributes.size()) break block0;
            dirtyTracker.add("attributes");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block3: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            TMFeatureType tMFeatureType = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("attributes")) break block3;
            if (this.attributes == null || this.attributes instanceof PersistentCollection && !((PersistentCollection)this.attributes).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("attributes", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("attributes", this.attributes.size());
            }
        }
    }

    public String $$_hibernate_read_createdBy() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_createdBy((String)this.$$_hibernate_getInterceptor().readObject((Object)this, "createdBy", (Object)super.$$_hibernate_read_createdBy()));
        }
        return super.$$_hibernate_read_createdBy();
    }

    public void $$_hibernate_write_createdBy(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"createdBy", (Object)string, (Object)this.$$_hibernate_read_createdBy())) {
            this.$$_hibernate_trackChange("createdBy");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_createdBy((String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "createdBy", (Object)super.$$_hibernate_read_createdBy(), (Object)string));
            return;
        }
        super.$$_hibernate_write_createdBy(string);
    }

    public String $$_hibernate_read_lastModifiedBy() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_lastModifiedBy((String)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastModifiedBy", (Object)super.$$_hibernate_read_lastModifiedBy()));
        }
        return super.$$_hibernate_read_lastModifiedBy();
    }

    public void $$_hibernate_write_lastModifiedBy(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"lastModifiedBy", (Object)string, (Object)this.$$_hibernate_read_lastModifiedBy())) {
            this.$$_hibernate_trackChange("lastModifiedBy");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_lastModifiedBy((String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastModifiedBy", (Object)super.$$_hibernate_read_lastModifiedBy(), (Object)string));
            return;
        }
        super.$$_hibernate_write_lastModifiedBy(string);
    }

    public Instant $$_hibernate_read_createdDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_createdDate((Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "createdDate", (Object)super.$$_hibernate_read_createdDate()));
        }
        return super.$$_hibernate_read_createdDate();
    }

    public void $$_hibernate_write_createdDate(Instant instant) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"createdDate", (Object)instant, (Object)this.$$_hibernate_read_createdDate())) {
            this.$$_hibernate_trackChange("createdDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_createdDate((Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "createdDate", (Object)super.$$_hibernate_read_createdDate(), (Object)instant));
            return;
        }
        super.$$_hibernate_write_createdDate(instant);
    }

    public Instant $$_hibernate_read_lastModifiedDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_lastModifiedDate((Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastModifiedDate", (Object)super.$$_hibernate_read_lastModifiedDate()));
        }
        return super.$$_hibernate_read_lastModifiedDate();
    }

    public void $$_hibernate_write_lastModifiedDate(Instant instant) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"lastModifiedDate", (Object)instant, (Object)this.$$_hibernate_read_lastModifiedDate())) {
            this.$$_hibernate_trackChange("lastModifiedDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_lastModifiedDate((Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastModifiedDate", (Object)super.$$_hibernate_read_lastModifiedDate(), (Object)instant));
            return;
        }
        super.$$_hibernate_write_lastModifiedDate(instant);
    }

    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)l);
            return;
        }
        this.id = l;
    }

    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"version", (Object)l, (Object)this.version)) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)this.version, (Object)l);
            return;
        }
        this.version = l;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public TMFeatureSource $$_hibernate_read_featureSource() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.featureSource = (TMFeatureSource)this.$$_hibernate_getInterceptor().readObject((Object)this, "featureSource", (Object)this.featureSource);
        }
        return this.featureSource;
    }

    public void $$_hibernate_write_featureSource(TMFeatureSource tMFeatureSource) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"featureSource", (Object)tMFeatureSource, (Object)this.featureSource)) {
            this.$$_hibernate_trackChange("featureSource");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.featureSource = (TMFeatureSource)this.$$_hibernate_getInterceptor().writeObject((Object)this, "featureSource", (Object)this.featureSource, (Object)tMFeatureSource);
            return;
        }
        this.featureSource = tMFeatureSource;
    }

    public String $$_hibernate_read_title() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.title = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "title", (Object)this.title);
        }
        return this.title;
    }

    public void $$_hibernate_write_title(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"title", (Object)string, (Object)this.title)) {
            this.$$_hibernate_trackChange("title");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.title = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "title", (Object)this.title, (Object)string);
            return;
        }
        this.title = string;
    }

    public TMFeatureTypeInfo $$_hibernate_read_info() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.info = (TMFeatureTypeInfo)this.$$_hibernate_getInterceptor().readObject((Object)this, "info", (Object)this.info);
        }
        return this.info;
    }

    public void $$_hibernate_write_info(TMFeatureTypeInfo tMFeatureTypeInfo) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"info", (Object)tMFeatureTypeInfo, (Object)this.info)) {
            this.$$_hibernate_trackChange("info");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.info = (TMFeatureTypeInfo)this.$$_hibernate_getInterceptor().writeObject((Object)this, "info", (Object)this.info, (Object)tMFeatureTypeInfo);
            return;
        }
        this.info = tMFeatureTypeInfo;
    }

    public String $$_hibernate_read_comment() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.comment = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "comment", (Object)this.comment);
        }
        return this.comment;
    }

    public void $$_hibernate_write_comment(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"comment", (Object)string, (Object)this.comment)) {
            this.$$_hibernate_trackChange("comment");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.comment = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "comment", (Object)this.comment, (Object)string);
            return;
        }
        this.comment = string;
    }

    public String $$_hibernate_read_owner() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "owner", (Object)this.owner);
        }
        return this.owner;
    }

    public void $$_hibernate_write_owner(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"owner", (Object)string, (Object)this.owner)) {
            this.$$_hibernate_trackChange("owner");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "owner", (Object)this.owner, (Object)string);
            return;
        }
        this.owner = string;
    }

    public boolean $$_hibernate_read_writeable() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.writeable = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "writeable", this.writeable);
        }
        return this.writeable;
    }

    public void $$_hibernate_write_writeable(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"writeable", (boolean)bl, (boolean)this.writeable)) {
            this.$$_hibernate_trackChange("writeable");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.writeable = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "writeable", this.writeable, bl);
            return;
        }
        this.writeable = bl;
    }

    public String $$_hibernate_read_defaultGeometryAttribute() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.defaultGeometryAttribute = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "defaultGeometryAttribute", (Object)this.defaultGeometryAttribute);
        }
        return this.defaultGeometryAttribute;
    }

    public void $$_hibernate_write_defaultGeometryAttribute(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"defaultGeometryAttribute", (Object)string, (Object)this.defaultGeometryAttribute)) {
            this.$$_hibernate_trackChange("defaultGeometryAttribute");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.defaultGeometryAttribute = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "defaultGeometryAttribute", (Object)this.defaultGeometryAttribute, (Object)string);
            return;
        }
        this.defaultGeometryAttribute = string;
    }

    public String $$_hibernate_read_primaryKeyAttribute() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.primaryKeyAttribute = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "primaryKeyAttribute", (Object)this.primaryKeyAttribute);
        }
        return this.primaryKeyAttribute;
    }

    public void $$_hibernate_write_primaryKeyAttribute(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"primaryKeyAttribute", (Object)string, (Object)this.primaryKeyAttribute)) {
            this.$$_hibernate_trackChange("primaryKeyAttribute");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.primaryKeyAttribute = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "primaryKeyAttribute", (Object)this.primaryKeyAttribute, (Object)string);
            return;
        }
        this.primaryKeyAttribute = string;
    }

    public List $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", (Object)this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", (Object)this.attributes, (Object)list);
            return;
        }
        this.attributes = list;
    }

    public FeatureTypeSettings $$_hibernate_read_settings() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.settings = (FeatureTypeSettings)this.$$_hibernate_getInterceptor().readObject((Object)this, "settings", (Object)this.settings);
        }
        return this.settings;
    }

    public void $$_hibernate_write_settings(FeatureTypeSettings featureTypeSettings) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"settings", (Object)featureTypeSettings, (Object)this.settings)) {
            this.$$_hibernate_trackChange("settings");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.settings = (FeatureTypeSettings)this.$$_hibernate_getInterceptor().writeObject((Object)this, "settings", (Object)this.settings, (Object)featureTypeSettings);
            return;
        }
        this.settings = featureTypeSettings;
    }
}

