/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.UUID;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.springframework.format.annotation.DateTimeFormat;
import org.tailormap.api.persistence.TemporaryToken;

@Entity
@Table(name="temporary_token")
@EnhancementInfo(version="6.6.35.Final")
public class TemporaryToken
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    UUID token;
    @Enumerated(value=EnumType.STRING)
    @Column(columnDefinition="varchar(18) not null")
    @NotNull
    TokenType tokenType;
    @NotNull
    String username;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @NotNull
    ZonedDateTime expirationTime;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public TemporaryToken() {
    }

    public TemporaryToken(@NotNull TokenType tokenType, @NotNull String username, int expirationMinutes) {
        this.$$_hibernate_write_tokenType(tokenType);
        this.$$_hibernate_write_username(username);
        this.$$_hibernate_write_expirationTime(ZonedDateTime.now(ZoneId.of("UTC")).plusMinutes(expirationMinutes));
    }

    @NotNull
    public UUID getToken() {
        return this.$$_hibernate_read_token();
    }

    public TemporaryToken setToken(UUID token) {
        this.$$_hibernate_write_token(token);
        return this;
    }

    public TokenType getTokenType() {
        return this.$$_hibernate_read_tokenType();
    }

    public TemporaryToken setTokenType(TokenType tokenType) {
        this.$$_hibernate_write_tokenType(tokenType);
        return this;
    }

    public String getUsername() {
        return this.$$_hibernate_read_username();
    }

    public TemporaryToken setUsername(String username) {
        this.$$_hibernate_write_username(username);
        return this;
    }

    public ZonedDateTime getExpirationTime() {
        return this.$$_hibernate_read_expirationTime();
    }

    public TemporaryToken setExpirationTime(ZonedDateTime expirationTime) {
        this.$$_hibernate_write_expirationTime(expirationTime);
        return this;
    }

    @JsonIgnore
    @NotNull
    public String getCombinedTokenAndExpirationAsBase64() {
        return Base64.getEncoder().encodeToString((String.valueOf(this.$$_hibernate_read_token()) + "#" + this.$$_hibernate_read_expirationTime().toEpochSecond()).getBytes(StandardCharsets.UTF_8));
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        TemporaryToken temporaryToken = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        TemporaryToken temporaryToken = this;
        temporaryToken = null;
        temporaryToken = NoopCollectionTracker.INSTANCE;
        return temporaryToken;
    }

    public UUID $$_hibernate_read_token() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.token = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "token", (Object)this.token);
        }
        return this.token;
    }

    public void $$_hibernate_write_token(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.token = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "token", (Object)this.token, (Object)uUID);
            return;
        }
        this.token = uUID;
    }

    public TokenType $$_hibernate_read_tokenType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.tokenType = (TokenType)this.$$_hibernate_getInterceptor().readObject((Object)this, "tokenType", (Object)this.tokenType);
        }
        return this.tokenType;
    }

    public void $$_hibernate_write_tokenType(TokenType tokenType) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"tokenType", (Object)tokenType, (Object)this.tokenType)) {
            this.$$_hibernate_trackChange("tokenType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.tokenType = (TokenType)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tokenType", (Object)this.tokenType, (Object)tokenType);
            return;
        }
        this.tokenType = tokenType;
    }

    public String $$_hibernate_read_username() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.username = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "username", (Object)this.username);
        }
        return this.username;
    }

    public void $$_hibernate_write_username(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"username", (Object)string, (Object)this.username)) {
            this.$$_hibernate_trackChange("username");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.username = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "username", (Object)this.username, (Object)string);
            return;
        }
        this.username = string;
    }

    public ZonedDateTime $$_hibernate_read_expirationTime() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.expirationTime = (ZonedDateTime)this.$$_hibernate_getInterceptor().readObject((Object)this, "expirationTime", (Object)this.expirationTime);
        }
        return this.expirationTime;
    }

    public void $$_hibernate_write_expirationTime(ZonedDateTime zonedDateTime) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"expirationTime", (Object)zonedDateTime, (Object)this.expirationTime)) {
            this.$$_hibernate_trackChange("expirationTime");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.expirationTime = (ZonedDateTime)this.$$_hibernate_getInterceptor().writeObject((Object)this, "expirationTime", (Object)this.expirationTime, (Object)zonedDateTime);
            return;
        }
        this.expirationTime = zonedDateTime;
    }
}

