/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.helper;

import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import org.tailormap.api.persistence.json.AppLayerSettings;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.AttributeSettings;
import org.tailormap.api.persistence.json.TMAttributeDescriptor;

/*
 * Exception performing whole class analysis ignored.
 */
public class TMFeatureTypeHelper {
    public static boolean isEditable(Application application, AppTreeLayerNode appTreeLayerNode, TMFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        boolean editable = false;
        if (featureType.isWriteable()) {
            AppLayerSettings appLayerSettings = application.getAppLayerSettings(appTreeLayerNode);
            editable = Boolean.TRUE.equals(appLayerSettings.getEditable());
        }
        return editable;
    }

    public static Set<String> getHiddenAttributes(@NotNull TMFeatureType featureType, @NotNull AppLayerSettings appLayerSettings) {
        HashSet<String> hiddenAttributes = new HashSet<String>();
        Optional.ofNullable(featureType.getSettings().getHideAttributes()).ifPresent(hiddenAttributes::addAll);
        Optional.ofNullable(appLayerSettings.getHideAttributes()).ifPresent(hiddenAttributes::addAll);
        return hiddenAttributes;
    }

    public static Set<String> getEditableAttributes(@NotNull TMFeatureType featureType, @NotNull AppLayerSettings appLayerSettings) {
        HashSet<String> editableAttributes = new HashSet<String>();
        Optional.ofNullable(featureType.getSettings().getEditableAttributes()).ifPresent(editableAttributes::addAll);
        Optional.ofNullable(appLayerSettings.getReadOnlyAttributes()).ifPresent(editableAttributes::removeAll);
        Optional.ofNullable(featureType.getAllGeometryAttributeNames()).ifPresent(editableAttributes::addAll);
        return editableAttributes;
    }

    public static Map<String, AttributeWithSettings> getConfiguredAttributes(@NotNull TMFeatureType featureType, @NotNull AppLayerSettings appLayerSettings) {
        LinkedHashSet<Object> finalAttributeOrder;
        LinkedHashMap<String, TMAttributeDescriptor> originalAttributesOrder = new LinkedHashMap<String, TMAttributeDescriptor>();
        for (TMAttributeDescriptor attributeDescriptor : featureType.getAttributes()) {
            originalAttributesOrder.put(attributeDescriptor.getName(), attributeDescriptor);
        }
        if (featureType.getSettings().getAttributeOrder().isEmpty()) {
            finalAttributeOrder = new LinkedHashSet(originalAttributesOrder.keySet());
        } else {
            finalAttributeOrder = new LinkedHashSet(featureType.getSettings().getAttributeOrder());
            finalAttributeOrder.retainAll(originalAttributesOrder.keySet());
            if (finalAttributeOrder.size() != originalAttributesOrder.size()) {
                finalAttributeOrder.addAll(originalAttributesOrder.keySet());
            }
        }
        TMFeatureTypeHelper.getHiddenAttributes((TMFeatureType)featureType, (AppLayerSettings)appLayerSettings).forEach(finalAttributeOrder::remove);
        Map attributeSettings = featureType.getSettings().getAttributeSettings();
        LinkedHashMap<String, AttributeWithSettings> result = new LinkedHashMap<String, AttributeWithSettings>();
        for (String string : finalAttributeOrder) {
            AttributeSettings settings = Optional.ofNullable((AttributeSettings)attributeSettings.get(string)).orElseGet(AttributeSettings::new);
            TMAttributeDescriptor attributeDescriptor = (TMAttributeDescriptor)originalAttributesOrder.get(string);
            result.put(string, new AttributeWithSettings(attributeDescriptor, settings));
        }
        return result;
    }

    public static Set<TMAttributeDescriptor> getNonHiddenAttributes(@NotNull TMFeatureType featureType, @NotNull AppLayerSettings appLayerSettings) {
        Set hiddenAttributes = TMFeatureTypeHelper.getHiddenAttributes((TMFeatureType)featureType, (AppLayerSettings)appLayerSettings);
        return featureType.getAttributes().stream().filter(attributeDescriptor -> !hiddenAttributes.contains(attributeDescriptor.getName())).collect(Collectors.toSet());
    }

    public static Set<String> getNonHiddenAttributeNames(@NotNull TMFeatureType featureType, @NotNull AppLayerSettings appLayerSettings) {
        return TMFeatureTypeHelper.getNonHiddenAttributes((TMFeatureType)featureType, (AppLayerSettings)appLayerSettings).stream().map(TMAttributeDescriptor::getName).collect(Collectors.toSet());
    }
}

