/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.helper;

import java.util.UUID;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.stereotype.Service;
import org.tailormap.api.controller.UploadsController;
import org.tailormap.api.repository.UploadRepository;

@Service
public class UploadHelper {
    private final UploadRepository uploadRepository;

    public UploadHelper(UploadRepository uploadRepository) {
        this.uploadRepository = uploadRepository;
    }

    public String getUrlForImage(String imageId, String category) {
        if (imageId == null) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(imageId);
            return this.getUrlForImage(uuid, category);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getUrlForImage(UUID imageId, String category) {
        if (imageId == null) {
            return null;
        }
        return this.uploadRepository.findByIdAndCategory(imageId, category).map(upload -> ((WebMvcLinkBuilder)((WebMvcLinkBuilder)((WebMvcLinkBuilder)((WebMvcLinkBuilder)((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(UploadsController.class).slash((Object)"api")).slash((Object)"uploads")).slash((Object)category)).slash((Object)imageId.toString())).slash((Object)upload.getFilename())).toString()).orElse(null);
    }
}

