/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.helper.ViewerHelper;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.FeatureTypeRef;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.persistence.json.GeoServiceLayerSettings;
import org.tailormap.api.repository.FeatureSourceRepository;
import org.tailormap.api.repository.GeoServiceRepository;

@Service
public class ViewerHelper {
    private final GeoServiceRepository geoServiceRepository;
    private final FeatureSourceRepository featureSourceRepository;

    public ViewerHelper(GeoServiceRepository geoServiceRepository, FeatureSourceRepository featureSourceRepository) {
        this.geoServiceRepository = geoServiceRepository;
        this.featureSourceRepository = featureSourceRepository;
    }

    public Map<String, AppLayerContext> getAppLayerContextMap(Application application) {
        return this.getAppLayerContextMap(application, null);
    }

    public Map<String, AppLayerContext> getAppLayerContextMap(Application application, List<String> appLayerIds) {
        HashMap nodeMap = new HashMap();
        application.getAllAppTreeLayerNode().forEach(node -> {
            if (appLayerIds == null || appLayerIds.contains(node.getId())) {
                nodeMap.put(node.getId(), node);
            }
        });
        Map<String, GeoService> geoServiceMap = this.geoServiceRepository.findByIds(nodeMap.values().stream().map(AppTreeLayerNode::getServiceId).distinct().toList()).stream().collect(Collectors.toMap(GeoService::getId, service -> service));
        HashMap<String, AppLayerContext> contextMap = new HashMap<String, AppLayerContext>();
        for (Map.Entry entry : nodeMap.entrySet()) {
            FeatureTypeRef ftr;
            GeoServiceLayerSettings lyrSettings;
            GeoServiceLayer layer;
            String appLayerId = (String)entry.getKey();
            AppTreeLayerNode lyrNode = (AppTreeLayerNode)entry.getValue();
            GeoService service2 = geoServiceMap.get(lyrNode.getServiceId());
            if (service2 == null || (layer = (GeoServiceLayer)service2.getLayers().stream().filter(l -> Objects.equals(l.getName(), lyrNode.getLayerName())).findFirst().orElse(null)) == null || (lyrSettings = service2.getLayerSettings(lyrNode.getLayerName())) == null || (ftr = lyrSettings.getFeatureType()) == null) continue;
            contextMap.put(appLayerId, new AppLayerContext(lyrNode, application.getAppLayerSettings(appLayerId), service2, layer, ftr));
        }
        return contextMap;
    }

    public Map<String, AppLayerFullContext> getAppLayerFullContextMap(Application application) {
        return this.getAppLayerFullContextMap(application, null);
    }

    public Map<String, AppLayerFullContext> getAppLayerFullContextMap(Application application, List<String> appLayerIds) {
        Map contextMap = this.getAppLayerContextMap(application, appLayerIds);
        Map<Long, TMFeatureSource> featureSourceMap = this.featureSourceRepository.findByIds(contextMap.values().stream().map(appLayerFeatureTypeRef -> appLayerFeatureTypeRef.featureTypeRef().getFeatureSourceId()).filter(Objects::nonNull).distinct().toList()).stream().collect(Collectors.toMap(TMFeatureSource::getId, featureSource -> featureSource));
        HashMap<String, AppLayerFullContext> fullContextMap = new HashMap<String, AppLayerFullContext>();
        for (Map.Entry entry : contextMap.entrySet()) {
            String appLayerId = (String)entry.getKey();
            AppLayerContext context = (AppLayerContext)entry.getValue();
            Optional.ofNullable(featureSourceMap.get(context.featureTypeRef().getFeatureSourceId())).map(featureSource -> featureSource.findFeatureTypeByName(context.featureTypeRef().getFeatureTypeName())).ifPresent(featureType -> fullContextMap.put(appLayerId, new AppLayerFullContext(context.node(), context.appLayerSettings(), context.geoService(), context.geoServiceLayer(), featureType)));
        }
        return fullContextMap;
    }
}

