/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.helper;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import org.tailormap.api.persistence.helper.ViewerHelper;
import org.tailormap.api.persistence.json.AppI18nSettings;
import org.tailormap.api.persistence.json.AppLayerSettings;
import org.tailormap.api.persistence.json.AppUiSettings;
import org.tailormap.api.persistence.json.AttributeSettings;
import org.tailormap.api.persistence.json.Filter;
import org.tailormap.api.persistence.json.FilterGroup;
import org.tailormap.api.security.AuthorisationService;
import org.tailormap.api.viewer.model.ViewerResponse;

@Service
public class ViewerResponseHelper {
    private final AuthorisationService authorisationService;
    private final ViewerHelper viewerHelper;

    public ViewerResponseHelper(AuthorisationService authorisationService, ViewerHelper viewerHelper) {
        this.authorisationService = authorisationService;
        this.viewerHelper = viewerHelper;
    }

    @Transactional
    public ViewerResponse getViewerResponse(Application application) {
        return new ViewerResponse().kind(ViewerResponse.KindEnum.APP).name(application.getName()).title(application.getTitle()).styling(application.getStyling()).components(application.getComponents()).i18nSettings(Objects.requireNonNullElse(application.getSettings().getI18nSettings(), new AppI18nSettings().hideLanguageSwitcher(Boolean.valueOf(false)))).uiSettings(Objects.requireNonNullElse(application.getSettings().getUiSettings(), new AppUiSettings().hideLoginButton(Boolean.valueOf(false)))).projections(List.of(application.getCrs())).filterGroups(this.verifyFilterGroups(application));
    }

    private List<FilterGroup> verifyFilterGroups(Application application) {
        List filterGroups = application.getSettings().getFilterGroups();
        Map appLayerFullContextMap = this.viewerHelper.getAppLayerFullContextMap(application, filterGroups.stream().map(FilterGroup::getLayerIds).flatMap(Collection::stream).toList());
        this.removeUnauthorizedLayersFromFilterGroups(appLayerFullContextMap, filterGroups);
        this.removeLayersFromFilterGroupsWithoutFeatureType(appLayerFullContextMap, filterGroups);
        this.removeFiltersWithoutAttributeInAllLayers(appLayerFullContextMap, filterGroups);
        this.removeEmptyFilterGroups(filterGroups);
        this.setAttributeAliasInFilters(appLayerFullContextMap, filterGroups);
        return filterGroups;
    }

    private void removeUnauthorizedLayersFromFilterGroups(Map<String, ViewerHelper.AppLayerFullContext> appLayerFullContextMap, List<FilterGroup> filterGroups) {
        filterGroups.forEach(fg -> fg.getLayerIds().removeIf(appLayerId -> !this.isAppLayerAuthorized((ViewerHelper.AppLayerFullContext)appLayerFullContextMap.get(appLayerId))));
    }

    private boolean isAppLayerAuthorized(ViewerHelper.AppLayerFullContext appLayerContext) {
        return appLayerContext != null && this.authorisationService.userAllowedToViewGeoService(appLayerContext.geoService()) && this.authorisationService.userAllowedToViewGeoServiceLayer(appLayerContext.geoService(), appLayerContext.geoServiceLayer());
    }

    private void removeLayersFromFilterGroupsWithoutFeatureType(Map<String, ViewerHelper.AppLayerFullContext> appLayerFullContextMap, List<FilterGroup> filterGroups) {
        filterGroups.forEach(fg -> fg.getLayerIds().removeIf(appLayerId -> !appLayerFullContextMap.containsKey(appLayerId)));
    }

    private void removeFiltersWithoutAttributeInAllLayers(Map<String, ViewerHelper.AppLayerFullContext> appLayerFullContextMap, List<FilterGroup> filterGroups) {
        for (FilterGroup filterGroup : filterGroups) {
            Set attributesCommonToAllLayers = filterGroup.getLayerIds().stream().map(appLayerFullContextMap::get).map(appLayerContext -> TMFeatureTypeHelper.getNonHiddenAttributeNames((TMFeatureType)appLayerContext.featureType(), (AppLayerSettings)appLayerContext.appLayerSettings())).reduce((a, b) -> {
                HashSet intersection = new HashSet(a);
                intersection.retainAll((Collection<?>)b);
                return intersection;
            }).orElse(new HashSet());
            filterGroup.getFilters().removeIf(f -> !attributesCommonToAllLayers.contains(f.getAttribute()));
        }
    }

    private void removeEmptyFilterGroups(List<FilterGroup> filterGroups) {
        filterGroups.removeIf(fg -> fg.getLayerIds().isEmpty() || fg.getFilters().isEmpty());
    }

    private void setAttributeAliasInFilters(Map<String, ViewerHelper.AppLayerFullContext> appLayerFullContextMap, List<FilterGroup> filterGroups) {
        for (FilterGroup filterGroup : filterGroups) {
            for (Filter filter : filterGroup.getFilters()) {
                filterGroup.getLayerIds().stream().map(appLayerFullContextMap::get).map(appLayerContext -> (AttributeSettings)appLayerContext.featureType().getSettings().getAttributeSettings().get(filter.getAttribute())).filter(Objects::nonNull).map(AttributeSettings::getTitle).filter(Objects::nonNull).findFirst().ifPresent(arg_0 -> ((Filter)filter).setAttributeAlias(arg_0));
            }
        }
    }
}

