/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.tailormap.api.persistence.json.AttachmentAttributeType;
import org.tailormap.api.persistence.json.AttributeSettings;
import org.tailormap.api.persistence.json.FeatureTypeTemplate;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureTypeSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FeatureTypeTemplate template;
    @Valid
    private List<String> attributeOrder = new ArrayList();
    @Valid
    private List<String> hideAttributes = new ArrayList();
    @Valid
    private List<String> editableAttributes = new ArrayList();
    @Valid
    private Map<String, AttributeSettings> attributeSettings = new HashMap();
    @Valid
    private @Valid Set<@Valid AttachmentAttributeType> attachmentAttributes = new LinkedHashSet();

    public FeatureTypeSettings template(FeatureTypeTemplate template) {
        this.template = template;
        return this;
    }

    @Valid
    @Schema(name="template", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="template")
    public FeatureTypeTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(FeatureTypeTemplate template) {
        this.template = template;
    }

    public FeatureTypeSettings attributeOrder(List<String> attributeOrder) {
        this.attributeOrder = attributeOrder;
        return this;
    }

    public FeatureTypeSettings addAttributeOrderItem(String attributeOrderItem) {
        if (this.attributeOrder == null) {
            this.attributeOrder = new ArrayList();
        }
        this.attributeOrder.add(attributeOrderItem);
        return this;
    }

    @NotNull
    @Schema(name="attributeOrder", description="Reordering of the attributes by attribute names. Attributes in the feature type that are not in this array should still be shown; either after the attribute that precedes the attribute in the original feature type attribute ordering or at the end.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="attributeOrder")
    public List<String> getAttributeOrder() {
        return this.attributeOrder;
    }

    public void setAttributeOrder(List<String> attributeOrder) {
        this.attributeOrder = attributeOrder;
    }

    public FeatureTypeSettings hideAttributes(List<String> hideAttributes) {
        this.hideAttributes = hideAttributes;
        return this;
    }

    public FeatureTypeSettings addHideAttributesItem(String hideAttributesItem) {
        if (this.hideAttributes == null) {
            this.hideAttributes = new ArrayList();
        }
        this.hideAttributes.add(hideAttributesItem);
        return this;
    }

    @NotNull
    @Schema(name="hideAttributes", description="List of attribute names that should be hidden in all viewers.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="hideAttributes")
    public List<String> getHideAttributes() {
        return this.hideAttributes;
    }

    public void setHideAttributes(List<String> hideAttributes) {
        this.hideAttributes = hideAttributes;
    }

    public FeatureTypeSettings editableAttributes(List<String> editableAttributes) {
        this.editableAttributes = editableAttributes;
        return this;
    }

    public FeatureTypeSettings addEditableAttributesItem(String editableAttributesItem) {
        if (this.editableAttributes == null) {
            this.editableAttributes = new ArrayList();
        }
        this.editableAttributes.add(editableAttributesItem);
        return this;
    }

    @NotNull
    @Schema(name="editableAttributes", description="List of attribute names that are editable.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="editableAttributes")
    public List<String> getEditableAttributes() {
        return this.editableAttributes;
    }

    public void setEditableAttributes(List<String> editableAttributes) {
        this.editableAttributes = editableAttributes;
    }

    public FeatureTypeSettings attributeSettings(Map<String, AttributeSettings> attributeSettings) {
        this.attributeSettings = attributeSettings;
        return this;
    }

    public FeatureTypeSettings putAttributeSettingsItem(String key, AttributeSettings attributeSettingsItem) {
        if (this.attributeSettings == null) {
            this.attributeSettings = new HashMap();
        }
        this.attributeSettings.put(key, attributeSettingsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="attributeSettings", description="Map of attribute name to its' settings.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="attributeSettings")
    public Map<String, AttributeSettings> getAttributeSettings() {
        return this.attributeSettings;
    }

    public void setAttributeSettings(Map<String, AttributeSettings> attributeSettings) {
        this.attributeSettings = attributeSettings;
    }

    public FeatureTypeSettings attachmentAttributes(Set<@Valid AttachmentAttributeType> attachmentAttributes) {
        this.attachmentAttributes = attachmentAttributes;
        return this;
    }

    public FeatureTypeSettings addAttachmentAttributesItem(AttachmentAttributeType attachmentAttributesItem) {
        if (this.attachmentAttributes == null) {
            this.attachmentAttributes = new LinkedHashSet();
        }
        this.attachmentAttributes.add(attachmentAttributesItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=0)
    @Schema(name="attachmentAttributes", description=" List of attributes that are attachments (files, images, etc.). Attachments are stored in sidecar tables of a featuretype. **Note** that the attributeName of any AttachmentAttributeType in the array should only be used once.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="attachmentAttributes")
    public @NotNull @Valid @Size(min=0) Set<@Valid AttachmentAttributeType> getAttachmentAttributes() {
        return this.attachmentAttributes;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setAttachmentAttributes(Set<@Valid AttachmentAttributeType> attachmentAttributes) {
        this.attachmentAttributes = attachmentAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureTypeSettings featureTypeSettings = (FeatureTypeSettings)o;
        return Objects.equals(this.template, featureTypeSettings.template) && Objects.equals(this.attributeOrder, featureTypeSettings.attributeOrder) && Objects.equals(this.hideAttributes, featureTypeSettings.hideAttributes) && Objects.equals(this.editableAttributes, featureTypeSettings.editableAttributes) && Objects.equals(this.attributeSettings, featureTypeSettings.attributeSettings) && Objects.equals(this.attachmentAttributes, featureTypeSettings.attachmentAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.template, this.attributeOrder, this.hideAttributes, this.editableAttributes, this.attributeSettings, this.attachmentAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureTypeSettings {\n");
        sb.append("    template: ").append(this.toIndentedString((Object)this.template)).append("\n");
        sb.append("    attributeOrder: ").append(this.toIndentedString((Object)this.attributeOrder)).append("\n");
        sb.append("    hideAttributes: ").append(this.toIndentedString((Object)this.hideAttributes)).append("\n");
        sb.append("    editableAttributes: ").append(this.toIndentedString((Object)this.editableAttributes)).append("\n");
        sb.append("    attributeSettings: ").append(this.toIndentedString((Object)this.attributeSettings)).append("\n");
        sb.append("    attachmentAttributes: ").append(this.toIndentedString((Object)this.attachmentAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

