/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.persistence.json.AuthorizationRule;
import org.tailormap.api.persistence.json.Bounds;
import org.tailormap.api.persistence.json.FeatureTypeRef;
import org.tailormap.api.persistence.json.TileLayerHiDpiMode;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GeoServiceLayerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title = null;
    private Boolean hiDpiDisabled = null;
    private FeatureTypeRef featureType;
    private String attribution = null;
    private String description = null;
    private String legendImageId = null;
    @Valid
    private @Valid List<@Valid AuthorizationRule> authorizationRules = new ArrayList();
    private Boolean tilingDisabled = null;
    private Integer tilingGutter = null;
    private TileLayerHiDpiMode hiDpiMode;
    private String hiDpiSubstituteLayer = null;
    private Integer minZoom = null;
    private Integer maxZoom = null;
    private Integer tileSize = null;
    private Bounds tileGridExtent;

    public GeoServiceLayerSettings title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="Override default title, null if not overridden.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public GeoServiceLayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
        return this;
    }

    @Schema(name="hiDpiDisabled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiDisabled")
    public Boolean getHiDpiDisabled() {
        return this.hiDpiDisabled;
    }

    public void setHiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
    }

    public GeoServiceLayerSettings featureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
        return this;
    }

    @Valid
    @Schema(name="featureType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="featureType")
    public FeatureTypeRef getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
    }

    public GeoServiceLayerSettings attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @Schema(name="attribution", description="Attribution to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public GeoServiceLayerSettings description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GeoServiceLayerSettings legendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
        return this;
    }

    @Schema(name="legendImageId", description="ID of uploaded legend image", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="legendImageId")
    public String getLegendImageId() {
        return this.legendImageId;
    }

    public void setLegendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
    }

    public GeoServiceLayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
        return this;
    }

    public GeoServiceLayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList();
        }
        this.authorizationRules.add(authorizationRulesItem);
        return this;
    }

    @Valid
    @Schema(name="authorizationRules", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="authorizationRules")
    public @Valid List<@Valid AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
    }

    public GeoServiceLayerSettings tilingDisabled(Boolean tilingDisabled) {
        this.tilingDisabled = tilingDisabled;
        return this;
    }

    @NotNull
    @Schema(name="tilingDisabled", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="tilingDisabled")
    public Boolean getTilingDisabled() {
        return this.tilingDisabled;
    }

    public void setTilingDisabled(Boolean tilingDisabled) {
        this.tilingDisabled = tilingDisabled;
    }

    public GeoServiceLayerSettings tilingGutter(Integer tilingGutter) {
        this.tilingGutter = tilingGutter;
        return this;
    }

    @NotNull
    @Schema(name="tilingGutter", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="tilingGutter")
    public Integer getTilingGutter() {
        return this.tilingGutter;
    }

    public void setTilingGutter(Integer tilingGutter) {
        this.tilingGutter = tilingGutter;
    }

    public GeoServiceLayerSettings hiDpiMode(TileLayerHiDpiMode hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
        return this;
    }

    @Valid
    @Schema(name="hiDpiMode", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiMode")
    public TileLayerHiDpiMode getHiDpiMode() {
        return this.hiDpiMode;
    }

    public void setHiDpiMode(TileLayerHiDpiMode hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
    }

    public GeoServiceLayerSettings hiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
        return this;
    }

    @Schema(name="hiDpiSubstituteLayer", description="Alternate URL template to use when rendering at high dpi (using 'layer' instead of 'url' in the name for ease of use).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiSubstituteLayer")
    public String getHiDpiSubstituteLayer() {
        return this.hiDpiSubstituteLayer;
    }

    public void setHiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
    }

    public GeoServiceLayerSettings minZoom(Integer minZoom) {
        this.minZoom = minZoom;
        return this;
    }

    @Schema(name="minZoom", description="minZoom property of OpenLayers XYZ source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="minZoom")
    public Integer getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(Integer minZoom) {
        this.minZoom = minZoom;
    }

    public GeoServiceLayerSettings maxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    @Schema(name="maxZoom", description="maxZoom property of OpenLayers XYZ source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maxZoom")
    public Integer getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
    }

    public GeoServiceLayerSettings tileSize(Integer tileSize) {
        this.tileSize = tileSize;
        return this;
    }

    @Schema(name="tileSize", description="tile size property of OpenLayers XYZ source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tileSize")
    public Integer getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(Integer tileSize) {
        this.tileSize = tileSize;
    }

    public GeoServiceLayerSettings tileGridExtent(Bounds tileGridExtent) {
        this.tileGridExtent = tileGridExtent;
        return this;
    }

    @Valid
    @Schema(name="tileGridExtent", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tileGridExtent")
    public Bounds getTileGridExtent() {
        return this.tileGridExtent;
    }

    public void setTileGridExtent(Bounds tileGridExtent) {
        this.tileGridExtent = tileGridExtent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoServiceLayerSettings geoServiceLayerSettings = (GeoServiceLayerSettings)o;
        return Objects.equals(this.title, geoServiceLayerSettings.title) && Objects.equals(this.hiDpiDisabled, geoServiceLayerSettings.hiDpiDisabled) && Objects.equals(this.featureType, geoServiceLayerSettings.featureType) && Objects.equals(this.attribution, geoServiceLayerSettings.attribution) && Objects.equals(this.description, geoServiceLayerSettings.description) && Objects.equals(this.legendImageId, geoServiceLayerSettings.legendImageId) && Objects.equals(this.authorizationRules, geoServiceLayerSettings.authorizationRules) && Objects.equals(this.tilingDisabled, geoServiceLayerSettings.tilingDisabled) && Objects.equals(this.tilingGutter, geoServiceLayerSettings.tilingGutter) && Objects.equals(this.hiDpiMode, geoServiceLayerSettings.hiDpiMode) && Objects.equals(this.hiDpiSubstituteLayer, geoServiceLayerSettings.hiDpiSubstituteLayer) && Objects.equals(this.minZoom, geoServiceLayerSettings.minZoom) && Objects.equals(this.maxZoom, geoServiceLayerSettings.maxZoom) && Objects.equals(this.tileSize, geoServiceLayerSettings.tileSize) && Objects.equals(this.tileGridExtent, geoServiceLayerSettings.tileGridExtent);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.hiDpiDisabled, this.featureType, this.attribution, this.description, this.legendImageId, this.authorizationRules, this.tilingDisabled, this.tilingGutter, this.hiDpiMode, this.hiDpiSubstituteLayer, this.minZoom, this.maxZoom, this.tileSize, this.tileGridExtent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeoServiceLayerSettings {\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    hiDpiDisabled: ").append(this.toIndentedString((Object)this.hiDpiDisabled)).append("\n");
        sb.append("    featureType: ").append(this.toIndentedString((Object)this.featureType)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString((Object)this.attribution)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    legendImageId: ").append(this.toIndentedString((Object)this.legendImageId)).append("\n");
        sb.append("    authorizationRules: ").append(this.toIndentedString((Object)this.authorizationRules)).append("\n");
        sb.append("    tilingDisabled: ").append(this.toIndentedString((Object)this.tilingDisabled)).append("\n");
        sb.append("    tilingGutter: ").append(this.toIndentedString((Object)this.tilingGutter)).append("\n");
        sb.append("    hiDpiMode: ").append(this.toIndentedString((Object)this.hiDpiMode)).append("\n");
        sb.append("    hiDpiSubstituteLayer: ").append(this.toIndentedString((Object)this.hiDpiSubstituteLayer)).append("\n");
        sb.append("    minZoom: ").append(this.toIndentedString((Object)this.minZoom)).append("\n");
        sb.append("    maxZoom: ").append(this.toIndentedString((Object)this.maxZoom)).append("\n");
        sb.append("    tileSize: ").append(this.toIndentedString((Object)this.tileSize)).append("\n");
        sb.append("    tileGridExtent: ").append(this.toIndentedString((Object)this.tileGridExtent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

