/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupOidcInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    private Set<String> clientIds = new LinkedHashSet();
    @Valid
    private Map<String, OffsetDateTime> lastSeenByClientId = new HashMap();

    public GroupOidcInfo clientIds(Set<String> clientIds) {
        this.clientIds = clientIds;
        return this;
    }

    public GroupOidcInfo addClientIdsItem(String clientIdsItem) {
        if (this.clientIds == null) {
            this.clientIds = new LinkedHashSet();
        }
        this.clientIds.add(clientIdsItem);
        return this;
    }

    @NotNull
    @Schema(name="clientIds", description="List of OIDC client IDs where this group (matched by OIDC role name) was received from.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="clientIds")
    public Set<String> getClientIds() {
        return this.clientIds;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setClientIds(Set<String> clientIds) {
        this.clientIds = clientIds;
    }

    public GroupOidcInfo lastSeenByClientId(Map<String, OffsetDateTime> lastSeenByClientId) {
        this.lastSeenByClientId = lastSeenByClientId;
        return this;
    }

    public GroupOidcInfo putLastSeenByClientIdItem(String key, OffsetDateTime lastSeenByClientIdItem) {
        if (this.lastSeenByClientId == null) {
            this.lastSeenByClientId = new HashMap();
        }
        this.lastSeenByClientId.put(key, lastSeenByClientIdItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="lastSeenByClientId", description="Timestamp of the last time this group was seen in an OIDC token of the client ID.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="lastSeenByClientId")
    public Map<String, OffsetDateTime> getLastSeenByClientId() {
        return this.lastSeenByClientId;
    }

    public void setLastSeenByClientId(Map<String, OffsetDateTime> lastSeenByClientId) {
        this.lastSeenByClientId = lastSeenByClientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupOidcInfo groupOidcInfo = (GroupOidcInfo)o;
        return Objects.equals(this.clientIds, groupOidcInfo.clientIds) && Objects.equals(this.lastSeenByClientId, groupOidcInfo.lastSeenByClientId);
    }

    public int hashCode() {
        return Objects.hash(this.clientIds, this.lastSeenByClientId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupOidcInfo {\n");
        sb.append("    clientIds: ").append(this.toIndentedString((Object)this.clientIds)).append("\n");
        sb.append("    lastSeenByClientId: ").append(this.toIndentedString((Object)this.lastSeenByClientId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

