/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.repository;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.lang.NonNull;
import org.springframework.security.access.prepost.PreAuthorize;
import org.tailormap.api.persistence.Upload;
import org.tailormap.api.repository.UploadMatch;

public interface UploadRepository
extends JpaRepository<Upload, UUID>,
RevisionRepository<Upload, UUID, Long> {
    @PreAuthorize(value="permitAll()")
    @NonNull
    @Query(value="select lastModified from Upload where id = :id")
    public Optional<OffsetDateTime> findLastModifiedById(@NonNull UUID var1);

    @PreAuthorize(value="permitAll()")
    @NonNull
    public Optional<Upload> findByIdAndCategory(@NonNull UUID var1, @NonNull String var2);

    @PreAuthorize(value="permitAll()")
    @NonNull
    @EntityGraph(attributePaths={"content"})
    public Optional<Upload> findWithContentByIdAndCategory(@NonNull UUID var1, @NonNull String var2);

    @PreAuthorize(value="permitAll()")
    public List<Upload> findByCategory(String var1);

    @PreAuthorize(value="permitAll()")
    @NonNull
    @EntityGraph(attributePaths={"content"})
    public Optional<Upload> findFirstWithContentByCategoryOrderByLastModifiedDesc(@NonNull String var1);

    @PreAuthorize(value="permitAll()")
    @Query(value="select new org.tailormap.api.repository.UploadMatch(u.id, u.hash) from Upload u where u.category = :category and u.hash in :hashes")
    public List<UploadMatch> findByHashIn(@NonNull String var1, @NonNull List<String> var2);

    @PreAuthorize(value="permitAll()")
    public List<Upload> findByFilename(String var1);
}

