/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.repository;

import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.data.rest.core.annotation.RepositoryRestResource;
import org.springframework.lang.NonNull;
import org.springframework.security.access.prepost.PreAuthorize;
import org.tailormap.api.persistence.User;
import org.tailormap.api.security.annotation.PreAuthorizeAdmin;

@PreAuthorizeAdmin
@RepositoryRestResource
public interface UserRepository
extends JpaRepository<User, String>,
RevisionRepository<User, String, Long> {
    @PreAuthorize(value="permitAll()")
    @EntityGraph(attributePaths={"groups"})
    @NonNull
    public Optional<User> findById(@NonNull String var1);

    public boolean existsByGroupsNameIn(Collection<String> var1);

    @PreAuthorize(value="permitAll()")
    public Optional<User> findByEmail(@NonNull String var1);

    @PreAuthorize(value="permitAll()")
    @Modifying
    @Query(value="update User u set u.password= :password where u.username = :username")
    public void updatePassword(@NotNull @Param(value="username") String var1, @NotNull @Param(value="password") String var2);
}

