/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.repository.events;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.rest.core.annotation.HandleAfterDelete;
import org.springframework.data.rest.core.annotation.HandleBeforeSave;
import org.springframework.data.rest.core.annotation.RepositoryEventHandler;
import org.springframework.stereotype.Component;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.prometheus.PrometheusService;

@Component
@RepositoryEventHandler
public class ApplicationEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PrometheusService prometheusService;
    @Value(value="${tailormap-api.allowed-metrics}")
    private Set<String> allowedMetrics;

    public ApplicationEventHandler(PrometheusService prometheusService) {
        this.prometheusService = prometheusService;
    }

    @HandleAfterDelete
    public void afterDeleteApplicationEventHandler(Application application) {
        logger.trace("Application '{}' (id: {}) was deleted.", (Object)application.getName(), (Object)application.getId());
        if (this.prometheusService.isPrometheusAvailable()) {
            ArrayList<CallSite> metricsToDelete = new ArrayList<CallSite>();
            metricsToDelete.add((CallSite)((Object)("tailormap_app_request_total{appId=\"" + application.getId().toString() + "\"}")));
            for (String metricName : this.allowedMetrics) {
                metricsToDelete.add((CallSite)((Object)(metricName + "_total{appId=\"" + application.getId().toString() + "\"}")));
            }
            try {
                logger.info("Cleaning up all metrics for deleted application with id: {}, (name: '{}')", (Object)application.getId(), (Object)application.getName());
                this.prometheusService.deleteMetric(metricsToDelete.toArray(new String[0]));
            }
            catch (IOException | URISyntaxException e) {
                logger.error("Error cleaning up metrics for deleted application with id: {}", (Object)application.getId(), (Object)e);
            }
        }
    }

    @HandleBeforeSave
    public void beforeSaveApplicationEventHandler(Application application) {
        if (this.prometheusService.isPrometheusAvailable()) {
            Set oldNodeIds = application.getAllOldAppTreeLayerNode().map(AppTreeLayerNode::getId).collect(Collectors.toSet());
            Set updatedNodeIds = application.getAllAppTreeLayerNode().map(AppTreeLayerNode::getId).collect(Collectors.toSet());
            Set removedNodeIds = oldNodeIds.stream().filter(id -> !updatedNodeIds.contains(id)).collect(Collectors.toSet());
            if (!removedNodeIds.isEmpty()) {
                ArrayList<CallSite> metricsToDelete = new ArrayList<CallSite>();
                for (String metricName : this.allowedMetrics) {
                    for (String nodeId : removedNodeIds) {
                        metricsToDelete.add((CallSite)((Object)(metricName + "_total{appId=\"" + application.getId().toString() + "\",appLayerId=\"" + nodeId + "\"}")));
                    }
                }
                try {
                    logger.info("Cleaning up application layer metrics for application with id: {}, (name: '{}'), removed nodes: {}", new Object[]{application.getId(), application.getName(), removedNodeIds});
                    this.prometheusService.deleteMetric(metricsToDelete.toArray(new String[0]));
                }
                catch (IOException | URISyntaxException e) {
                    logger.error("Error cleaning up layer metrics for updated application with id: {}", (Object)application.getId(), (Object)e);
                }
            }
        }
    }
}

