/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.repository.events;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.rest.core.annotation.HandleBeforeSave;
import org.springframework.data.rest.core.annotation.RepositoryEventHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.geotools.featuresources.AttachmentsHelper;
import org.tailormap.api.persistence.TMFeatureType;

@Component
@RepositoryEventHandler
public class FeatureTypeEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @HandleBeforeSave
    void handleBeforeSaveTMFeatureType(TMFeatureType featureType) {
        try {
            if (featureType.getSettings() != null && featureType.getSettings().getAttachmentAttributes() != null && !featureType.getSettings().getAttachmentAttributes().isEmpty()) {
                AttachmentsHelper.createAttachmentTableForFeatureType((TMFeatureType)featureType);
            }
        }
        catch (IOException | IllegalArgumentException | SQLException e) {
            logger.error("Error opening GeoTools datastore or creating attachments table or index for FeatureType: {}", (Object)featureType.getName(), (Object)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error creating attachments table or index for FeatureType: " + featureType.getName(), (Throwable)e);
        }
    }
}

