/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.util;

import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.json.AppLayerSettings;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.repository.FeatureSourceRepository;

@Component
public class EditUtil {
    private final FeatureSourceRepository featureSourceRepository;

    public EditUtil(FeatureSourceRepository featureSourceRepository) {
        this.featureSourceRepository = featureSourceRepository;
    }

    public void checkEditAuthorisation() throws ResponseStatusException {
        boolean isAuthenticated;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean bl = isAuthenticated = authentication != null && !(authentication instanceof AnonymousAuthenticationToken);
        if (!isAuthenticated) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Not properly authenticated");
        }
    }

    public TMFeatureType getEditableFeatureType(Application application, AppTreeLayerNode appTreeLayerNode, GeoService service, GeoServiceLayer layer) throws ResponseStatusException {
        if (null == layer) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Cannot find layer " + String.valueOf(appTreeLayerNode));
        }
        AppLayerSettings appLayerSettings = application.getAppLayerSettings(appTreeLayerNode);
        if (!Boolean.TRUE.equals(appLayerSettings.getEditable())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Layer is not editable");
        }
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        if (null == tmft) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Layer does not have feature type");
        }
        if (!tmft.isWriteable()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Feature type is not writeable");
        }
        return tmft;
    }
}

