/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.validation.constraints.NotNull;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import me.gosimple.nbvcxz.Nbvcxz;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.ConfigurationBuilder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.tailormap.api.configuration.TailormapPasswordStrengthConfig;
import org.tailormap.api.security.InvalidPasswordException;

/*
 * Exception performing whole class analysis ignored.
 */
public class TMPasswordDeserializer
extends JsonDeserializer<String> {
    private static final PasswordEncoder encoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();

    public static PasswordEncoder encoder() {
        return encoder;
    }

    public String deserialize(@NotNull JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectCodec codec = jsonParser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jsonParser);
        if (node == null) {
            throw new InvalidPasswordException((Closeable)jsonParser, "Password is required");
        }
        String password = node.asText();
        boolean validation = TailormapPasswordStrengthConfig.getValidation();
        int minLength = TailormapPasswordStrengthConfig.getMinLength();
        int minStrength = TailormapPasswordStrengthConfig.getMinStrength();
        if (validation && !TMPasswordDeserializer.validatePasswordStrength((String)password, (int)minLength, (int)minStrength)) {
            throw new InvalidPasswordException((Closeable)jsonParser, "Password too short or too easily guessable");
        }
        return encoder.encode((CharSequence)node.asText());
    }

    public static boolean validatePasswordStrength(String password, int minLength, int minStrength) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return false;
        }
        if (password.length() < minLength) {
            return false;
        }
        Configuration configuration = new ConfigurationBuilder().setLocale(Locale.forLanguageTag(LocaleContextHolder.getLocale().toLanguageTag())).setDistanceCalc(Boolean.valueOf(true)).createConfiguration();
        return new Nbvcxz(configuration).estimate(password).getBasicScore() >= minStrength;
    }
}

