/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.Objects;

@Schema(name="AttachmentAttributeType", description="data type for an attachment attribute")
public class AttachmentAttributeType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String attributeName;
    private String mimeType = null;
    private Long maxAttachmentSize;

    public AttachmentAttributeType attributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    @NotNull
    @Size(min=1)
    @Schema(name="attributeName", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="attributeName")
    public @NotNull @Size(min=1) String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public AttachmentAttributeType mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Schema(name="mimeType", example="image/png,image/jpeg", description="Allowed mime type(s) of the attachment, when null any type is allowed, similar to to the `Accept` HTTP header.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="mimeType")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public AttachmentAttributeType maxAttachmentSize(Long maxAttachmentSize) {
        this.maxAttachmentSize = maxAttachmentSize;
        return this;
    }

    @Schema(name="maxAttachmentSize", description="Maximum allowed size of the attachment in bytes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maxAttachmentSize")
    public Long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    public void setMaxAttachmentSize(Long maxAttachmentSize) {
        this.maxAttachmentSize = maxAttachmentSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentAttributeType attachmentAttributeType = (AttachmentAttributeType)o;
        return Objects.equals(this.attributeName, attachmentAttributeType.attributeName) && Objects.equals(this.mimeType, attachmentAttributeType.mimeType) && Objects.equals(this.maxAttachmentSize, attachmentAttributeType.maxAttachmentSize);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.mimeType, this.maxAttachmentSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttachmentAttributeType {\n");
        sb.append("    attributeName: ").append(this.toIndentedString((Object)this.attributeName)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString((Object)this.mimeType)).append("\n");
        sb.append("    maxAttachmentSize: ").append(this.toIndentedString((Object)this.maxAttachmentSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

