/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import org.springframework.format.annotation.DateTimeFormat;

public class AttachmentMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UUID attachmentId;
    private String attributeName;
    private String fileName;
    private String description;
    private String mimeType;
    private Long attachmentSize;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdAt;
    private String createdBy;

    public AttachmentMetadata attachmentId(UUID attachmentId) {
        this.attachmentId = attachmentId;
        return this;
    }

    @Valid
    @Schema(name="attachmentId", accessMode=Schema.AccessMode.READ_ONLY, description="the key of the attachment", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attachmentId")
    public UUID getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(UUID attachmentId) {
        this.attachmentId = attachmentId;
    }

    public AttachmentMetadata attributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    @NotNull
    @Size(min=1)
    @Schema(name="attributeName", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="attributeName")
    public @NotNull @Size(min=1) String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public AttachmentMetadata fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @NotNull
    @Schema(name="fileName", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public AttachmentMetadata description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AttachmentMetadata mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @NotNull
    @Schema(name="mimeType", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="mimeType")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public AttachmentMetadata attachmentSize(Long attachmentSize) {
        this.attachmentSize = attachmentSize;
        return this;
    }

    @Schema(name="attachmentSize", accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attachmentSize")
    public Long getAttachmentSize() {
        return this.attachmentSize;
    }

    public void setAttachmentSize(Long attachmentSize) {
        this.attachmentSize = attachmentSize;
    }

    public AttachmentMetadata createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Valid
    @Schema(name="createdAt", accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public AttachmentMetadata createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Schema(name="createdBy", accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentMetadata attachmentMetadata = (AttachmentMetadata)o;
        return Objects.equals(this.attachmentId, attachmentMetadata.attachmentId) && Objects.equals(this.attributeName, attachmentMetadata.attributeName) && Objects.equals(this.fileName, attachmentMetadata.fileName) && Objects.equals(this.description, attachmentMetadata.description) && Objects.equals(this.mimeType, attachmentMetadata.mimeType) && Objects.equals(this.attachmentSize, attachmentMetadata.attachmentSize) && Objects.equals(this.createdAt, attachmentMetadata.createdAt) && Objects.equals(this.createdBy, attachmentMetadata.createdBy);
    }

    public int hashCode() {
        return Objects.hash(this.attachmentId, this.attributeName, this.fileName, this.description, this.mimeType, this.attachmentSize, this.createdAt, this.createdBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttachmentMetadata {\n");
        sb.append("    attachmentId: ").append(this.toIndentedString((Object)this.attachmentId)).append("\n");
        sb.append("    attributeName: ").append(this.toIndentedString((Object)this.attributeName)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString((Object)this.fileName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString((Object)this.mimeType)).append("\n");
        sb.append("    attachmentSize: ").append(this.toIndentedString((Object)this.attachmentSize)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString((Object)this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString((Object)this.createdBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

