/*
 * Copyright (C) 2023 B3Partners B.V.
 *
 * SPDX-License-Identifier: MIT
 */
package org.tailormap.api.persistence;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.Version;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.Type;
import org.hibernate.envers.Audited;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.tailormap.api.persistence.json.CatalogNode;
import org.tailormap.api.persistence.listener.EntityEventPublisher;

@Audited
@Entity
@EntityListeners({EntityEventPublisher.class, AuditingEntityListener.class})
public class Catalog extends AuditMetadata {
  public static final String MAIN = "main";

  @Id
  private String id;

  @Version
  private Long version;

  @Type(value = io.hypersistence.utils.hibernate.type.json.JsonBinaryType.class)
  @Column(columnDefinition = "jsonb")
  @NotNull private List<CatalogNode> nodes = new ArrayList<>();

  public String getId() {
    return id;
  }

  public Catalog setId(String id) {
    this.id = id;
    return this;
  }

  public Long getVersion() {
    return version;
  }

  public Catalog setVersion(Long version) {
    this.version = version;
    return this;
  }

  public List<CatalogNode> getNodes() {
    return nodes;
  }

  public Catalog setNodes(List<CatalogNode> nodes) {
    this.nodes = nodes;
    return this;
  }
}
