/*
 * Copyright (C) 2023 B3Partners B.V.
 *
 * SPDX-License-Identifier: MIT
 */
package org.tailormap.api.persistence;

import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Version;
import jakarta.validation.constraints.NotNull;
import java.util.UUID;
import org.hibernate.envers.Audited;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.tailormap.api.persistence.listener.EntityEventPublisher;

@Audited
@Entity
@EntityListeners({EntityEventPublisher.class, AuditingEntityListener.class})
public class OIDCConfiguration extends AuditMetadata {
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Long id;

  @Version
  private Long version;

  @NotNull private String name;

  @NotNull private String clientId;

  private String clientSecret;

  @NotNull private String issuerUrl;

  @NotNull private String userNameAttribute;

  private String status;

  private UUID image;

  public Long getId() {
    return id;
  }

  public OIDCConfiguration setId(Long id) {
    this.id = id;
    return this;
  }

  public Long getVersion() {
    return version;
  }

  public OIDCConfiguration setVersion(Long version) {
    this.version = version;
    return this;
  }

  public String getName() {
    return name;
  }

  public OIDCConfiguration setName(String name) {
    this.name = name;
    return this;
  }

  public String getClientId() {
    return clientId;
  }

  public OIDCConfiguration setClientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

  public String getClientSecret() {
    return clientSecret;
  }

  public OIDCConfiguration setClientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
    return this;
  }

  public String getIssuerUrl() {
    return issuerUrl;
  }

  public OIDCConfiguration setIssuerUrl(String issuerUrl) {
    this.issuerUrl = issuerUrl;
    return this;
  }

  public String getUserNameAttribute() {
    return userNameAttribute;
  }

  public OIDCConfiguration setUserNameAttribute(String userNameAttribute) {
    this.userNameAttribute = userNameAttribute;
    return this;
  }

  public String getStatus() {
    return status;
  }

  public OIDCConfiguration setStatus(String status) {
    this.status = status;
    return this;
  }

  public UUID getImage() {
    return image;
  }

  public OIDCConfiguration setImage(UUID image) {
    this.image = image;
    return this;
  }
}
