package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.AppTreeNode;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Configuration for including content (layers) in an application.
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "AppContent", description = "Configuration for including content (layers) in an application.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.17.0")
public class AppContent implements Serializable {

  private static final long serialVersionUID = 1L;

  @Valid
  private List<AppTreeNode> baseLayerNodes = new ArrayList<>();

  @Valid
  private List<AppTreeNode> layerNodes = new ArrayList<>();

  @Valid
  private List<AppTreeNode> terrainLayerNodes;

  public AppContent baseLayerNodes(List<AppTreeNode> baseLayerNodes) {
    this.baseLayerNodes = baseLayerNodes;
    return this;
  }

  public AppContent addBaseLayerNodesItem(AppTreeNode baseLayerNodesItem) {
    if (this.baseLayerNodes == null) {
      this.baseLayerNodes = new ArrayList<>();
    }
    this.baseLayerNodes.add(baseLayerNodesItem);
    return this;
  }

  /**
   * Get baseLayerNodes
   * @return baseLayerNodes
   */
  @Valid 
  @Schema(name = "baseLayerNodes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("baseLayerNodes")
  public List<AppTreeNode> getBaseLayerNodes() {
    return baseLayerNodes;
  }

  public void setBaseLayerNodes(List<AppTreeNode> baseLayerNodes) {
    this.baseLayerNodes = baseLayerNodes;
  }

  public AppContent layerNodes(List<AppTreeNode> layerNodes) {
    this.layerNodes = layerNodes;
    return this;
  }

  public AppContent addLayerNodesItem(AppTreeNode layerNodesItem) {
    if (this.layerNodes == null) {
      this.layerNodes = new ArrayList<>();
    }
    this.layerNodes.add(layerNodesItem);
    return this;
  }

  /**
   * Get layerNodes
   * @return layerNodes
   */
  @Valid 
  @Schema(name = "layerNodes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("layerNodes")
  public List<AppTreeNode> getLayerNodes() {
    return layerNodes;
  }

  public void setLayerNodes(List<AppTreeNode> layerNodes) {
    this.layerNodes = layerNodes;
  }

  public AppContent terrainLayerNodes(List<AppTreeNode> terrainLayerNodes) {
    this.terrainLayerNodes = terrainLayerNodes;
    return this;
  }

  public AppContent addTerrainLayerNodesItem(AppTreeNode terrainLayerNodesItem) {
    if (this.terrainLayerNodes == null) {
      this.terrainLayerNodes = new ArrayList<>();
    }
    this.terrainLayerNodes.add(terrainLayerNodesItem);
    return this;
  }

  /**
   * Get terrainLayerNodes
   * @return terrainLayerNodes
   */
  @Valid 
  @Schema(name = "terrainLayerNodes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("terrainLayerNodes")
  public List<AppTreeNode> getTerrainLayerNodes() {
    return terrainLayerNodes;
  }

  public void setTerrainLayerNodes(List<AppTreeNode> terrainLayerNodes) {
    this.terrainLayerNodes = terrainLayerNodes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppContent appContent = (AppContent) o;
    return Objects.equals(this.baseLayerNodes, appContent.baseLayerNodes) &&
        Objects.equals(this.layerNodes, appContent.layerNodes) &&
        Objects.equals(this.terrainLayerNodes, appContent.terrainLayerNodes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(baseLayerNodes, layerNodes, terrainLayerNodes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppContent {\n");
    sb.append("    baseLayerNodes: ").append(toIndentedString(baseLayerNodes)).append("\n");
    sb.append("    layerNodes: ").append(toIndentedString(layerNodes)).append("\n");
    sb.append("    terrainLayerNodes: ").append(toIndentedString(terrainLayerNodes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

