package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * data type for an attachment attribute
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "AttachmentAttributeType", description = "data type for an attachment attribute")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.17.0")
public class AttachmentAttributeType implements Serializable {

  private static final long serialVersionUID = 1L;

  private String attributeName;

  private String mimeType = null;

  private Long maxAttachmentSize;

  public AttachmentAttributeType() {
    super();
  }

  public AttachmentAttributeType attributeName(String attributeName) {
    this.attributeName = attributeName;
    return this;
  }

  /**
   * Get attributeName
   * @return attributeName
   */
  @NotNull @Size(min = 1) 
  @Schema(name = "attributeName", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("attributeName")
  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public AttachmentAttributeType mimeType(String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Allowed mime type(s) of the attachment, when null any type is allowed, similar to to the `Accept` HTTP header.
   * @return mimeType
   */
  
  @Schema(name = "mimeType", example = "image/png,image/jpeg", description = "Allowed mime type(s) of the attachment, when null any type is allowed, similar to to the `Accept` HTTP header.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("mimeType")
  public String getMimeType() {
    return mimeType;
  }

  public void setMimeType(String mimeType) {
    this.mimeType = mimeType;
  }

  public AttachmentAttributeType maxAttachmentSize(Long maxAttachmentSize) {
    this.maxAttachmentSize = maxAttachmentSize;
    return this;
  }

  /**
   * Maximum allowed size of the attachment in bytes
   * @return maxAttachmentSize
   */
  
  @Schema(name = "maxAttachmentSize", description = "Maximum allowed size of the attachment in bytes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("maxAttachmentSize")
  public Long getMaxAttachmentSize() {
    return maxAttachmentSize;
  }

  public void setMaxAttachmentSize(Long maxAttachmentSize) {
    this.maxAttachmentSize = maxAttachmentSize;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttachmentAttributeType attachmentAttributeType = (AttachmentAttributeType) o;
    return Objects.equals(this.attributeName, attachmentAttributeType.attributeName) &&
        Objects.equals(this.mimeType, attachmentAttributeType.mimeType) &&
        Objects.equals(this.maxAttachmentSize, attachmentAttributeType.maxAttachmentSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, mimeType, maxAttachmentSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttachmentAttributeType {\n");
    sb.append("    attributeName: ").append(toIndentedString(attributeName)).append("\n");
    sb.append("    mimeType: ").append(toIndentedString(mimeType)).append("\n");
    sb.append("    maxAttachmentSize: ").append(toIndentedString(maxAttachmentSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

