package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.GeoServiceDefaultLayerSettings;
import org.tailormap.api.persistence.json.GeoServiceLayerSettings;
import org.tailormap.api.persistence.json.ServicePublishingSettings;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Settings applying to a GeoService.
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "GeoServiceSettings", description = "Settings applying to a GeoService.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.17.0")
public class GeoServiceSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * Server type to use for vendor-specific capabilities (high DPI, legends, etc.)
   */
  public enum ServerTypeEnum {
    AUTO("auto"),
    
    GENERIC("generic"),
    
    GEOSERVER("geoserver"),
    
    MAPSERVER("mapserver");

    private final String value;

    ServerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ServerTypeEnum fromValue(String value) {
      for (ServerTypeEnum b : ServerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private ServerTypeEnum serverType = ServerTypeEnum.AUTO;

  private Boolean useProxy = false;

  private ServicePublishingSettings publishing;

  private GeoServiceDefaultLayerSettings defaultLayerSettings = null;

  @Valid
  private Map<String, GeoServiceLayerSettings> layerSettings = new HashMap<>();

  private String xyzCrs = null;

  public GeoServiceSettings serverType(ServerTypeEnum serverType) {
    this.serverType = serverType;
    return this;
  }

  /**
   * Server type to use for vendor-specific capabilities (high DPI, legends, etc.)
   * @return serverType
   */
  
  @Schema(name = "serverType", description = "Server type to use for vendor-specific capabilities (high DPI, legends, etc.)", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("serverType")
  public ServerTypeEnum getServerType() {
    return serverType;
  }

  public void setServerType(ServerTypeEnum serverType) {
    this.serverType = serverType;
  }

  public GeoServiceSettings useProxy(Boolean useProxy) {
    this.useProxy = useProxy;
    return this;
  }

  /**
   * Get useProxy
   * @return useProxy
   */
  
  @Schema(name = "useProxy", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("useProxy")
  public Boolean getUseProxy() {
    return useProxy;
  }

  public void setUseProxy(Boolean useProxy) {
    this.useProxy = useProxy;
  }

  public GeoServiceSettings publishing(ServicePublishingSettings publishing) {
    this.publishing = publishing;
    return this;
  }

  /**
   * Get publishing
   * @return publishing
   */
  @Valid 
  @Schema(name = "publishing", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("publishing")
  public ServicePublishingSettings getPublishing() {
    return publishing;
  }

  public void setPublishing(ServicePublishingSettings publishing) {
    this.publishing = publishing;
  }

  public GeoServiceSettings defaultLayerSettings(GeoServiceDefaultLayerSettings defaultLayerSettings) {
    this.defaultLayerSettings = defaultLayerSettings;
    return this;
  }

  /**
   * Get defaultLayerSettings
   * @return defaultLayerSettings
   */
  @Valid 
  @Schema(name = "defaultLayerSettings", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("defaultLayerSettings")
  public GeoServiceDefaultLayerSettings getDefaultLayerSettings() {
    return defaultLayerSettings;
  }

  public void setDefaultLayerSettings(GeoServiceDefaultLayerSettings defaultLayerSettings) {
    this.defaultLayerSettings = defaultLayerSettings;
  }

  public GeoServiceSettings layerSettings(Map<String, GeoServiceLayerSettings> layerSettings) {
    this.layerSettings = layerSettings;
    return this;
  }

  public GeoServiceSettings putLayerSettingsItem(String key, GeoServiceLayerSettings layerSettingsItem) {
    if (this.layerSettings == null) {
      this.layerSettings = new HashMap<>();
    }
    this.layerSettings.put(key, layerSettingsItem);
    return this;
  }

  /**
   * Get layerSettings
   * @return layerSettings
   */
  @Valid 
  @Schema(name = "layerSettings", example = "{\"begroeidterreindeel\":{\"title\":\"laag 1\"},\"begroeidterreindeel_2\":{\"title\":\"laag 2\"},\"otherLayer\":{\"hiDpiDisabled\":true}}", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("layerSettings")
  public Map<String, GeoServiceLayerSettings> getLayerSettings() {
    return layerSettings;
  }

  public void setLayerSettings(Map<String, GeoServiceLayerSettings> layerSettings) {
    this.layerSettings = layerSettings;
  }

  public GeoServiceSettings xyzCrs(String xyzCrs) {
    this.xyzCrs = xyzCrs;
    return this;
  }

  /**
   * Get xyzCrs
   * @return xyzCrs
   */
  
  @Schema(name = "xyzCrs", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("xyzCrs")
  public String getXyzCrs() {
    return xyzCrs;
  }

  public void setXyzCrs(String xyzCrs) {
    this.xyzCrs = xyzCrs;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoServiceSettings geoServiceSettings = (GeoServiceSettings) o;
    return Objects.equals(this.serverType, geoServiceSettings.serverType) &&
        Objects.equals(this.useProxy, geoServiceSettings.useProxy) &&
        Objects.equals(this.publishing, geoServiceSettings.publishing) &&
        Objects.equals(this.defaultLayerSettings, geoServiceSettings.defaultLayerSettings) &&
        Objects.equals(this.layerSettings, geoServiceSettings.layerSettings) &&
        Objects.equals(this.xyzCrs, geoServiceSettings.xyzCrs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serverType, useProxy, publishing, defaultLayerSettings, layerSettings, xyzCrs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoServiceSettings {\n");
    sb.append("    serverType: ").append(toIndentedString(serverType)).append("\n");
    sb.append("    useProxy: ").append(toIndentedString(useProxy)).append("\n");
    sb.append("    publishing: ").append(toIndentedString(publishing)).append("\n");
    sb.append("    defaultLayerSettings: ").append(toIndentedString(defaultLayerSettings)).append("\n");
    sb.append("    layerSettings: ").append(toIndentedString(layerSettings)).append("\n");
    sb.append("    xyzCrs: ").append(toIndentedString(xyzCrs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

