package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * GroupOidcInfo
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.17.0")
public class GroupOidcInfo implements Serializable {

  private static final long serialVersionUID = 1L;

  @Valid
  private Set<String> clientIds = new LinkedHashSet<>();

  @Valid
  private Map<String, OffsetDateTime> lastSeenByClientId = new HashMap<>();

  public GroupOidcInfo() {
    super();
  }

  public GroupOidcInfo clientIds(Set<String> clientIds) {
    this.clientIds = clientIds;
    return this;
  }

  public GroupOidcInfo addClientIdsItem(String clientIdsItem) {
    if (this.clientIds == null) {
      this.clientIds = new LinkedHashSet<>();
    }
    this.clientIds.add(clientIdsItem);
    return this;
  }

  /**
   * List of OIDC client IDs where this group (matched by OIDC role name) was received from.
   * @return clientIds
   */
  @NotNull 
  @Schema(name = "clientIds", description = "List of OIDC client IDs where this group (matched by OIDC role name) was received from.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("clientIds")
  public Set<String> getClientIds() {
    return clientIds;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setClientIds(Set<String> clientIds) {
    this.clientIds = clientIds;
  }

  public GroupOidcInfo lastSeenByClientId(Map<String, OffsetDateTime> lastSeenByClientId) {
    this.lastSeenByClientId = lastSeenByClientId;
    return this;
  }

  public GroupOidcInfo putLastSeenByClientIdItem(String key, OffsetDateTime lastSeenByClientIdItem) {
    if (this.lastSeenByClientId == null) {
      this.lastSeenByClientId = new HashMap<>();
    }
    this.lastSeenByClientId.put(key, lastSeenByClientIdItem);
    return this;
  }

  /**
   * Timestamp of the last time this group was seen in an OIDC token of the client ID.
   * @return lastSeenByClientId
   */
  @NotNull @Valid 
  @Schema(name = "lastSeenByClientId", description = "Timestamp of the last time this group was seen in an OIDC token of the client ID.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("lastSeenByClientId")
  public Map<String, OffsetDateTime> getLastSeenByClientId() {
    return lastSeenByClientId;
  }

  public void setLastSeenByClientId(Map<String, OffsetDateTime> lastSeenByClientId) {
    this.lastSeenByClientId = lastSeenByClientId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GroupOidcInfo groupOidcInfo = (GroupOidcInfo) o;
    return Objects.equals(this.clientIds, groupOidcInfo.clientIds) &&
        Objects.equals(this.lastSeenByClientId, groupOidcInfo.lastSeenByClientId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientIds, lastSeenByClientId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GroupOidcInfo {\n");
    sb.append("    clientIds: ").append(toIndentedString(clientIds)).append("\n");
    sb.append("    lastSeenByClientId: ").append(toIndentedString(lastSeenByClientId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

