package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.AuthorizationRule;
import org.tailormap.api.persistence.json.FeatureTypeRef;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Settings applying to a WMS layer.
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "WMSLayerSettings", description = "Settings applying to a WMS layer.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.17.0")
public class WMSLayerSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  private String title = null;

  private Boolean hiDpiDisabled = null;

  private FeatureTypeRef featureType;

  private String attribution = null;

  private String description = null;

  private String legendImageId = null;

  @Valid
  private List<@Valid AuthorizationRule> authorizationRules = new ArrayList<>();

  private Boolean tilingDisabled = null;

  private Integer tilingGutter = null;

  public WMSLayerSettings() {
    super();
  }

  public WMSLayerSettings title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Override default title, null if not overridden.
   * @return title
   */
  
  @Schema(name = "title", description = "Override default title, null if not overridden.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public WMSLayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
    this.hiDpiDisabled = hiDpiDisabled;
    return this;
  }

  /**
   * Get hiDpiDisabled
   * @return hiDpiDisabled
   */
  
  @Schema(name = "hiDpiDisabled", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiDisabled")
  public Boolean getHiDpiDisabled() {
    return hiDpiDisabled;
  }

  public void setHiDpiDisabled(Boolean hiDpiDisabled) {
    this.hiDpiDisabled = hiDpiDisabled;
  }

  public WMSLayerSettings featureType(FeatureTypeRef featureType) {
    this.featureType = featureType;
    return this;
  }

  /**
   * Get featureType
   * @return featureType
   */
  @Valid 
  @Schema(name = "featureType", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("featureType")
  public FeatureTypeRef getFeatureType() {
    return featureType;
  }

  public void setFeatureType(FeatureTypeRef featureType) {
    this.featureType = featureType;
  }

  public WMSLayerSettings attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * Attribution to show for this layer.
   * @return attribution
   */
  
  @Schema(name = "attribution", description = "Attribution to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  public WMSLayerSettings description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description to show for this layer.
   * @return description
   */
  
  @Schema(name = "description", description = "Description to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public WMSLayerSettings legendImageId(String legendImageId) {
    this.legendImageId = legendImageId;
    return this;
  }

  /**
   * ID of uploaded legend image
   * @return legendImageId
   */
  
  @Schema(name = "legendImageId", description = "ID of uploaded legend image", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("legendImageId")
  public String getLegendImageId() {
    return legendImageId;
  }

  public void setLegendImageId(String legendImageId) {
    this.legendImageId = legendImageId;
  }

  public WMSLayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
    this.authorizationRules = authorizationRules;
    return this;
  }

  public WMSLayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
    if (this.authorizationRules == null) {
      this.authorizationRules = new ArrayList<>();
    }
    this.authorizationRules.add(authorizationRulesItem);
    return this;
  }

  /**
   * Get authorizationRules
   * @return authorizationRules
   */
  @Valid 
  @Schema(name = "authorizationRules", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("authorizationRules")
  public List<@Valid AuthorizationRule> getAuthorizationRules() {
    return authorizationRules;
  }

  public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
    this.authorizationRules = authorizationRules;
  }

  public WMSLayerSettings tilingDisabled(Boolean tilingDisabled) {
    this.tilingDisabled = tilingDisabled;
    return this;
  }

  /**
   * Get tilingDisabled
   * @return tilingDisabled
   */
  @NotNull 
  @Schema(name = "tilingDisabled", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("tilingDisabled")
  public Boolean getTilingDisabled() {
    return tilingDisabled;
  }

  public void setTilingDisabled(Boolean tilingDisabled) {
    this.tilingDisabled = tilingDisabled;
  }

  public WMSLayerSettings tilingGutter(Integer tilingGutter) {
    this.tilingGutter = tilingGutter;
    return this;
  }

  /**
   * Get tilingGutter
   * @return tilingGutter
   */
  @NotNull 
  @Schema(name = "tilingGutter", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("tilingGutter")
  public Integer getTilingGutter() {
    return tilingGutter;
  }

  public void setTilingGutter(Integer tilingGutter) {
    this.tilingGutter = tilingGutter;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WMSLayerSettings wmSLayerSettings = (WMSLayerSettings) o;
    return Objects.equals(this.title, wmSLayerSettings.title) &&
        Objects.equals(this.hiDpiDisabled, wmSLayerSettings.hiDpiDisabled) &&
        Objects.equals(this.featureType, wmSLayerSettings.featureType) &&
        Objects.equals(this.attribution, wmSLayerSettings.attribution) &&
        Objects.equals(this.description, wmSLayerSettings.description) &&
        Objects.equals(this.legendImageId, wmSLayerSettings.legendImageId) &&
        Objects.equals(this.authorizationRules, wmSLayerSettings.authorizationRules) &&
        Objects.equals(this.tilingDisabled, wmSLayerSettings.tilingDisabled) &&
        Objects.equals(this.tilingGutter, wmSLayerSettings.tilingGutter);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, hiDpiDisabled, featureType, attribution, description, legendImageId, authorizationRules, tilingDisabled, tilingGutter);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WMSLayerSettings {\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    hiDpiDisabled: ").append(toIndentedString(hiDpiDisabled)).append("\n");
    sb.append("    featureType: ").append(toIndentedString(featureType)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    legendImageId: ").append(toIndentedString(legendImageId)).append("\n");
    sb.append("    authorizationRules: ").append(toIndentedString(authorizationRules)).append("\n");
    sb.append("    tilingDisabled: ").append(toIndentedString(tilingDisabled)).append("\n");
    sb.append("    tilingGutter: ").append(toIndentedString(tilingGutter)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

