package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * A drawing is a collection of features (modeled as a GeoJSON FeatureCollection) and some metadata.
 */

@Schema(name = "DrawingRequest", description = "A drawing is a collection of features (modeled as a GeoJSON FeatureCollection) and some metadata.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.17.0")
public class DrawingRequest implements Serializable {

  private static final long serialVersionUID = 1L;

  private UUID id;

  private String name;

  private String description;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime updatedAt;

  private String createdBy;

  private String updatedBy;

  private Integer version = 0;

  /**
   * Access level of the drawing, defaults to private.
   */
  public enum AccessEnum {
    PRIVATE("private"),
    
    SHARED("shared"),
    
    PUBLIC("public");

    private final String value;

    AccessEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AccessEnum fromValue(String value) {
      for (AccessEnum b : AccessEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private AccessEnum access = AccessEnum.PRIVATE;

  @Valid
  private Map<String, Object> domainData;

  private Integer srid;

  private Object featureCollection = null;

  public DrawingRequest() {
    super();
  }

  public DrawingRequest id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of the drawing. Generated by the backend.
   * @return id
   */
  @Valid 
  @Schema(name = "id", accessMode = Schema.AccessMode.READ_ONLY, example = "a73ac8ee-1d64-44be-a05e-b6426e2c1c59", description = "Unique identifier of the drawing. Generated by the backend.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public DrawingRequest name(String name) {
    this.name = name;
    return this;
  }

  /**
   * A user provided, identifying name of the drawing.
   * @return name
   */
  @NotNull 
  @Schema(name = "name", description = "A user provided, identifying name of the drawing.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DrawingRequest description(String description) {
    this.description = description;
    return this;
  }

  /**
   * A description of the drawing.
   * @return description
   */
  
  @Schema(name = "description", description = "A description of the drawing.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public DrawingRequest createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Creation date of the drawing as a Zoned date-time.
   * @return createdAt
   */
  @Valid 
  @Schema(name = "createdAt", accessMode = Schema.AccessMode.READ_ONLY, example = "2024-12-12T16:02:34.587142504+01:00", description = "Creation date of the drawing as a Zoned date-time.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("createdAt")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public DrawingRequest updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Last update date of the drawing as a Zoned date-time.
   * @return updatedAt
   */
  @Valid 
  @Schema(name = "updatedAt", accessMode = Schema.AccessMode.READ_ONLY, example = "2024-12-12T16:02:34.587142504+01:00", description = "Last update date of the drawing as a Zoned date-time.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("updatedAt")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }

  public DrawingRequest createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * User that created the drawing.
   * @return createdBy
   */
  
  @Schema(name = "createdBy", accessMode = Schema.AccessMode.READ_ONLY, description = "User that created the drawing.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("createdBy")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  public DrawingRequest updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

  /**
   * User that last saved the drawing.
   * @return updatedBy
   */
  
  @Schema(name = "updatedBy", accessMode = Schema.AccessMode.READ_ONLY, description = "User that last saved the drawing.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("updatedBy")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  public DrawingRequest version(Integer version) {
    this.version = version;
    return this;
  }

  /**
   * Version of the drawing.
   * @return version
   */
  
  @Schema(name = "version", description = "Version of the drawing.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public DrawingRequest access(AccessEnum access) {
    this.access = access;
    return this;
  }

  /**
   * Access level of the drawing, defaults to private.
   * @return access
   */
  @NotNull 
  @Schema(name = "access", description = "Access level of the drawing, defaults to private.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("access")
  public AccessEnum getAccess() {
    return access;
  }

  public void setAccess(AccessEnum access) {
    this.access = access;
  }

  public DrawingRequest domainData(Map<String, Object> domainData) {
    this.domainData = domainData;
    return this;
  }

  public DrawingRequest putDomainDataItem(String key, Object domainDataItem) {
    if (this.domainData == null) {
      this.domainData = new HashMap<>();
    }
    this.domainData.put(key, domainDataItem);
    return this;
  }

  /**
   * Domain specific data, can be used to store additional data.
   * @return domainData
   */
  
  @Schema(name = "domainData", description = "Domain specific data, can be used to store additional data.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("domainData")
  public Map<String, Object> getDomainData() {
    return domainData;
  }

  public void setDomainData(Map<String, Object> domainData) {
    this.domainData = domainData;
  }

  public DrawingRequest srid(Integer srid) {
    this.srid = srid;
    return this;
  }

  /**
   * The EPSG SRID code of the drawing's features, defaults to the SRID of the application.
   * @return srid
   */
  
  @Schema(name = "srid", accessMode = Schema.AccessMode.READ_ONLY, description = "The EPSG SRID code of the drawing's features, defaults to the SRID of the application.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("srid")
  public Integer getSrid() {
    return srid;
  }

  public void setSrid(Integer srid) {
    this.srid = srid;
  }

  public DrawingRequest featureCollection(Object featureCollection) {
    this.featureCollection = featureCollection;
    return this;
  }

  /**
   *  Features of the drawing, as a GeoJSON FeatureCollection. The collection is projected to the SRID of the application that the drawing was last edited in. 
   * @return featureCollection
   */
  
  @Schema(name = "featureCollection", description = " Features of the drawing, as a GeoJSON FeatureCollection. The collection is projected to the SRID of the application that the drawing was last edited in. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("featureCollection")
  public Object getFeatureCollection() {
    return featureCollection;
  }

  public void setFeatureCollection(Object featureCollection) {
    this.featureCollection = featureCollection;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DrawingRequest drawingRequest = (DrawingRequest) o;
    return Objects.equals(this.id, drawingRequest.id) &&
        Objects.equals(this.name, drawingRequest.name) &&
        Objects.equals(this.description, drawingRequest.description) &&
        Objects.equals(this.createdAt, drawingRequest.createdAt) &&
        Objects.equals(this.updatedAt, drawingRequest.updatedAt) &&
        Objects.equals(this.createdBy, drawingRequest.createdBy) &&
        Objects.equals(this.updatedBy, drawingRequest.updatedBy) &&
        Objects.equals(this.version, drawingRequest.version) &&
        Objects.equals(this.access, drawingRequest.access) &&
        Objects.equals(this.domainData, drawingRequest.domainData) &&
        Objects.equals(this.srid, drawingRequest.srid) &&
        Objects.equals(this.featureCollection, drawingRequest.featureCollection);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, description, createdAt, updatedAt, createdBy, updatedBy, version, access, domainData, srid, featureCollection);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DrawingRequest {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    access: ").append(toIndentedString(access)).append("\n");
    sb.append("    domainData: ").append(toIndentedString(domainData)).append("\n");
    sb.append("    srid: ").append(toIndentedString(srid)).append("\n");
    sb.append("    featureCollection: ").append(toIndentedString(featureCollection)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

