package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.viewer.model.LoginConfigurationSsoLinksInner;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * LoginConfiguration
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.17.0")
public class LoginConfiguration implements Serializable {

  private static final long serialVersionUID = 1L;

  private Boolean hideLoginForm;

  private Boolean enablePasswordReset = true;

  @Valid
  private List<@Valid LoginConfigurationSsoLinksInner> ssoLinks = new ArrayList<>();

  public LoginConfiguration hideLoginForm(Boolean hideLoginForm) {
    this.hideLoginForm = hideLoginForm;
    return this;
  }

  /**
   * If set, should hide the login form for any user-facing applications.
   * @return hideLoginForm
   */
  
  @Schema(name = "hideLoginForm", description = "If set, should hide the login form for any user-facing applications.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hideLoginForm")
  public Boolean getHideLoginForm() {
    return hideLoginForm;
  }

  public void setHideLoginForm(Boolean hideLoginForm) {
    this.hideLoginForm = hideLoginForm;
  }

  public LoginConfiguration enablePasswordReset(Boolean enablePasswordReset) {
    this.enablePasswordReset = enablePasswordReset;
    return this;
  }

  /**
   * If set, enables the password reset functionality.
   * @return enablePasswordReset
   */
  
  @Schema(name = "enablePasswordReset", description = "If set, enables the password reset functionality.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("enablePasswordReset")
  public Boolean getEnablePasswordReset() {
    return enablePasswordReset;
  }

  public void setEnablePasswordReset(Boolean enablePasswordReset) {
    this.enablePasswordReset = enablePasswordReset;
  }

  public LoginConfiguration ssoLinks(List<@Valid LoginConfigurationSsoLinksInner> ssoLinks) {
    this.ssoLinks = ssoLinks;
    return this;
  }

  public LoginConfiguration addSsoLinksItem(LoginConfigurationSsoLinksInner ssoLinksItem) {
    if (this.ssoLinks == null) {
      this.ssoLinks = new ArrayList<>();
    }
    this.ssoLinks.add(ssoLinksItem);
    return this;
  }

  /**
   * Lists alternative SSO links.
   * @return ssoLinks
   */
  @Valid 
  @Schema(name = "ssoLinks", description = "Lists alternative SSO links.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("ssoLinks")
  public List<@Valid LoginConfigurationSsoLinksInner> getSsoLinks() {
    return ssoLinks;
  }

  public void setSsoLinks(List<@Valid LoginConfigurationSsoLinksInner> ssoLinks) {
    this.ssoLinks = ssoLinks;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoginConfiguration loginConfiguration = (LoginConfiguration) o;
    return Objects.equals(this.hideLoginForm, loginConfiguration.hideLoginForm) &&
        Objects.equals(this.enablePasswordReset, loginConfiguration.enablePasswordReset) &&
        Objects.equals(this.ssoLinks, loginConfiguration.ssoLinks);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hideLoginForm, enablePasswordReset, ssoLinks);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoginConfiguration {\n");
    sb.append("    hideLoginForm: ").append(toIndentedString(hideLoginForm)).append("\n");
    sb.append("    enablePasswordReset: ").append(toIndentedString(enablePasswordReset)).append("\n");
    sb.append("    ssoLinks: ").append(toIndentedString(ssoLinks)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

