package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.Bounds;
import org.tailormap.api.viewer.model.AppLayer;
import org.tailormap.api.viewer.model.LayerTreeNode;
import org.tailormap.api.viewer.model.Service;
import org.tailormap.api.viewer.model.TMCoordinateReferenceSystem;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Any information needed to draw a basic map on a page. May include base layers.
 */

@Schema(name = "MapResponse", description = "Any information needed to draw a basic map on a page. May include base layers.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.17.0")
public class MapResponse implements Serializable {

  private static final long serialVersionUID = 1L;

  private Bounds initialExtent;

  private Bounds maxExtent;

  @Valid
  private Set<@Valid Service> services = new LinkedHashSet<>();

  @Valid
  private List<@Valid LayerTreeNode> baseLayerTreeNodes = new ArrayList<>();

  @Valid
  private List<@Valid LayerTreeNode> layerTreeNodes = new ArrayList<>();

  @Valid
  private List<@Valid LayerTreeNode> terrainLayerTreeNodes = new ArrayList<>();

  @Valid
  private List<@Valid AppLayer> appLayers = new ArrayList<>();

  private TMCoordinateReferenceSystem crs;

  public MapResponse() {
    super();
  }

  public MapResponse initialExtent(Bounds initialExtent) {
    this.initialExtent = initialExtent;
    return this;
  }

  /**
   * Get initialExtent
   * @return initialExtent
   */
  @NotNull @Valid 
  @Schema(name = "initialExtent", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("initialExtent")
  public Bounds getInitialExtent() {
    return initialExtent;
  }

  public void setInitialExtent(Bounds initialExtent) {
    this.initialExtent = initialExtent;
  }

  public MapResponse maxExtent(Bounds maxExtent) {
    this.maxExtent = maxExtent;
    return this;
  }

  /**
   * Get maxExtent
   * @return maxExtent
   */
  @Valid 
  @Schema(name = "maxExtent", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("maxExtent")
  public Bounds getMaxExtent() {
    return maxExtent;
  }

  public void setMaxExtent(Bounds maxExtent) {
    this.maxExtent = maxExtent;
  }

  public MapResponse services(Set<@Valid Service> services) {
    this.services = services;
    return this;
  }

  public MapResponse addServicesItem(Service servicesItem) {
    if (this.services == null) {
      this.services = new LinkedHashSet<>();
    }
    this.services.add(servicesItem);
    return this;
  }

  /**
   * Get services
   * @return services
   */
  @NotNull @Valid 
  @Schema(name = "services", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("services")
  public Set<@Valid Service> getServices() {
    return services;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setServices(Set<@Valid Service> services) {
    this.services = services;
  }

  public MapResponse baseLayerTreeNodes(List<@Valid LayerTreeNode> baseLayerTreeNodes) {
    this.baseLayerTreeNodes = baseLayerTreeNodes;
    return this;
  }

  public MapResponse addBaseLayerTreeNodesItem(LayerTreeNode baseLayerTreeNodesItem) {
    if (this.baseLayerTreeNodes == null) {
      this.baseLayerTreeNodes = new ArrayList<>();
    }
    this.baseLayerTreeNodes.add(baseLayerTreeNodesItem);
    return this;
  }

  /**
   * Unordered list of all tree nodes of base layers. Start with the node with root set to true and use the ordered children array property to order the tree. For base layers, only one child node (with all its' child layers) of the root should be displayed at one time.
   * @return baseLayerTreeNodes
   */
  @NotNull @Valid 
  @Schema(name = "baseLayerTreeNodes", description = "Unordered list of all tree nodes of base layers. Start with the node with root set to true and use the ordered children array property to order the tree. For base layers, only one child node (with all its' child layers) of the root should be displayed at one time.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("baseLayerTreeNodes")
  public List<@Valid LayerTreeNode> getBaseLayerTreeNodes() {
    return baseLayerTreeNodes;
  }

  public void setBaseLayerTreeNodes(List<@Valid LayerTreeNode> baseLayerTreeNodes) {
    this.baseLayerTreeNodes = baseLayerTreeNodes;
  }

  public MapResponse layerTreeNodes(List<@Valid LayerTreeNode> layerTreeNodes) {
    this.layerTreeNodes = layerTreeNodes;
    return this;
  }

  public MapResponse addLayerTreeNodesItem(LayerTreeNode layerTreeNodesItem) {
    if (this.layerTreeNodes == null) {
      this.layerTreeNodes = new ArrayList<>();
    }
    this.layerTreeNodes.add(layerTreeNodesItem);
    return this;
  }

  /**
   * Unordered list of all tree nodes of overlay/thematic/transparent layers. Start with the node with root set to true and use the ordered children array property to order the tree.
   * @return layerTreeNodes
   */
  @NotNull @Valid 
  @Schema(name = "layerTreeNodes", description = "Unordered list of all tree nodes of overlay/thematic/transparent layers. Start with the node with root set to true and use the ordered children array property to order the tree.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("layerTreeNodes")
  public List<@Valid LayerTreeNode> getLayerTreeNodes() {
    return layerTreeNodes;
  }

  public void setLayerTreeNodes(List<@Valid LayerTreeNode> layerTreeNodes) {
    this.layerTreeNodes = layerTreeNodes;
  }

  public MapResponse terrainLayerTreeNodes(List<@Valid LayerTreeNode> terrainLayerTreeNodes) {
    this.terrainLayerTreeNodes = terrainLayerTreeNodes;
    return this;
  }

  public MapResponse addTerrainLayerTreeNodesItem(LayerTreeNode terrainLayerTreeNodesItem) {
    if (this.terrainLayerTreeNodes == null) {
      this.terrainLayerTreeNodes = new ArrayList<>();
    }
    this.terrainLayerTreeNodes.add(terrainLayerTreeNodesItem);
    return this;
  }

  /**
   * Unordered list of all tree nodes of terrain layers. Start with the node with root set to true and use the ordered children array property to order the tree.
   * @return terrainLayerTreeNodes
   */
  @Valid 
  @Schema(name = "terrainLayerTreeNodes", description = "Unordered list of all tree nodes of terrain layers. Start with the node with root set to true and use the ordered children array property to order the tree.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("terrainLayerTreeNodes")
  public List<@Valid LayerTreeNode> getTerrainLayerTreeNodes() {
    return terrainLayerTreeNodes;
  }

  public void setTerrainLayerTreeNodes(List<@Valid LayerTreeNode> terrainLayerTreeNodes) {
    this.terrainLayerTreeNodes = terrainLayerTreeNodes;
  }

  public MapResponse appLayers(List<@Valid AppLayer> appLayers) {
    this.appLayers = appLayers;
    return this;
  }

  public MapResponse addAppLayersItem(AppLayer appLayersItem) {
    if (this.appLayers == null) {
      this.appLayers = new ArrayList<>();
    }
    this.appLayers.add(appLayersItem);
    return this;
  }

  /**
   * Unordered list of all AppLayers referenced from baseLayerTreeNodes and layerTreeNodes. Note that you need to lookup these by id, but OpenAPI only supports a map by using strings as keys, so an array is used instead.
   * @return appLayers
   */
  @NotNull @Valid 
  @Schema(name = "appLayers", description = "Unordered list of all AppLayers referenced from baseLayerTreeNodes and layerTreeNodes. Note that you need to lookup these by id, but OpenAPI only supports a map by using strings as keys, so an array is used instead.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("appLayers")
  public List<@Valid AppLayer> getAppLayers() {
    return appLayers;
  }

  public void setAppLayers(List<@Valid AppLayer> appLayers) {
    this.appLayers = appLayers;
  }

  public MapResponse crs(TMCoordinateReferenceSystem crs) {
    this.crs = crs;
    return this;
  }

  /**
   * Get crs
   * @return crs
   */
  @NotNull @Valid 
  @Schema(name = "crs", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("crs")
  public TMCoordinateReferenceSystem getCrs() {
    return crs;
  }

  public void setCrs(TMCoordinateReferenceSystem crs) {
    this.crs = crs;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MapResponse mapResponse = (MapResponse) o;
    return Objects.equals(this.initialExtent, mapResponse.initialExtent) &&
        Objects.equals(this.maxExtent, mapResponse.maxExtent) &&
        Objects.equals(this.services, mapResponse.services) &&
        Objects.equals(this.baseLayerTreeNodes, mapResponse.baseLayerTreeNodes) &&
        Objects.equals(this.layerTreeNodes, mapResponse.layerTreeNodes) &&
        Objects.equals(this.terrainLayerTreeNodes, mapResponse.terrainLayerTreeNodes) &&
        Objects.equals(this.appLayers, mapResponse.appLayers) &&
        Objects.equals(this.crs, mapResponse.crs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(initialExtent, maxExtent, services, baseLayerTreeNodes, layerTreeNodes, terrainLayerTreeNodes, appLayers, crs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MapResponse {\n");
    sb.append("    initialExtent: ").append(toIndentedString(initialExtent)).append("\n");
    sb.append("    maxExtent: ").append(toIndentedString(maxExtent)).append("\n");
    sb.append("    services: ").append(toIndentedString(services)).append("\n");
    sb.append("    baseLayerTreeNodes: ").append(toIndentedString(baseLayerTreeNodes)).append("\n");
    sb.append("    layerTreeNodes: ").append(toIndentedString(layerTreeNodes)).append("\n");
    sb.append("    terrainLayerTreeNodes: ").append(toIndentedString(terrainLayerTreeNodes)).append("\n");
    sb.append("    appLayers: ").append(toIndentedString(appLayers)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

