package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.tailormap.api.viewer.model.AdditionalProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Information about authentication status and user information
 */

@Schema(name = "UserResponse", description = "Information about authentication status and user information")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.17.0")
public class UserResponse implements Serializable {

  private static final long serialVersionUID = 1L;

  private Boolean isAuthenticated;

  private String username;

  private String organisation;

  @Valid
  private Set<String> roles = new LinkedHashSet<>();

  @Valid
  private List<@Valid AdditionalProperty> properties = new ArrayList<>();

  @Valid
  private List<@Valid AdditionalProperty> groupProperties = new ArrayList<>();

  public UserResponse isAuthenticated(Boolean isAuthenticated) {
    this.isAuthenticated = isAuthenticated;
    return this;
  }

  /**
   * true if the user is authenticated
   * @return isAuthenticated
   */
  
  @Schema(name = "isAuthenticated", description = "true if the user is authenticated", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("isAuthenticated")
  public Boolean getIsAuthenticated() {
    return isAuthenticated;
  }

  public void setIsAuthenticated(Boolean isAuthenticated) {
    this.isAuthenticated = isAuthenticated;
  }

  public UserResponse username(String username) {
    this.username = username;
    return this;
  }

  /**
   * username of the authenticated user
   * @return username
   */
  
  @Schema(name = "username", description = "username of the authenticated user", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("username")
  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public UserResponse organisation(String organisation) {
    this.organisation = organisation;
    return this;
  }

  /**
   * organisation of the authenticated user
   * @return organisation
   */
  
  @Schema(name = "organisation", description = "organisation of the authenticated user", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("organisation")
  public String getOrganisation() {
    return organisation;
  }

  public void setOrganisation(String organisation) {
    this.organisation = organisation;
  }

  public UserResponse roles(Set<String> roles) {
    this.roles = roles;
    return this;
  }

  public UserResponse addRolesItem(String rolesItem) {
    if (this.roles == null) {
      this.roles = new LinkedHashSet<>();
    }
    this.roles.add(rolesItem);
    return this;
  }

  /**
   * Get roles
   * @return roles
   */
  
  @Schema(name = "roles", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("roles")
  public Set<String> getRoles() {
    return roles;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setRoles(Set<String> roles) {
    this.roles = roles;
  }

  public UserResponse properties(List<@Valid AdditionalProperty> properties) {
    this.properties = properties;
    return this;
  }

  public UserResponse addPropertiesItem(AdditionalProperty propertiesItem) {
    if (this.properties == null) {
      this.properties = new ArrayList<>();
    }
    this.properties.add(propertiesItem);
    return this;
  }

  /**
   * Get properties
   * @return properties
   */
  @Valid 
  @Schema(name = "properties", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("properties")
  public List<@Valid AdditionalProperty> getProperties() {
    return properties;
  }

  public void setProperties(List<@Valid AdditionalProperty> properties) {
    this.properties = properties;
  }

  public UserResponse groupProperties(List<@Valid AdditionalProperty> groupProperties) {
    this.groupProperties = groupProperties;
    return this;
  }

  public UserResponse addGroupPropertiesItem(AdditionalProperty groupPropertiesItem) {
    if (this.groupProperties == null) {
      this.groupProperties = new ArrayList<>();
    }
    this.groupProperties.add(groupPropertiesItem);
    return this;
  }

  /**
   * Get groupProperties
   * @return groupProperties
   */
  @Valid 
  @Schema(name = "groupProperties", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("groupProperties")
  public List<@Valid AdditionalProperty> getGroupProperties() {
    return groupProperties;
  }

  public void setGroupProperties(List<@Valid AdditionalProperty> groupProperties) {
    this.groupProperties = groupProperties;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserResponse userResponse = (UserResponse) o;
    return Objects.equals(this.isAuthenticated, userResponse.isAuthenticated) &&
        Objects.equals(this.username, userResponse.username) &&
        Objects.equals(this.organisation, userResponse.organisation) &&
        Objects.equals(this.roles, userResponse.roles) &&
        Objects.equals(this.properties, userResponse.properties) &&
        Objects.equals(this.groupProperties, userResponse.groupProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isAuthenticated, username, organisation, roles, properties, groupProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserResponse {\n");
    sb.append("    isAuthenticated: ").append(toIndentedString(isAuthenticated)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    organisation: ").append(toIndentedString(organisation)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    groupProperties: ").append(toIndentedString(groupProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

