/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.audit;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AuditMessageObject {
    private String username;
    private String event;
    private final List<Object> messages = Stream.of(new Object[0]).collect(Collectors.toList());

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void addMessage(Object message) {
        this.messages.add(message);
    }

    public List<Object> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public String getMessagesAsString() {
        return this.messages.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    public String toString() {
        return "AuditMessageObject{ event=" + this.event + ", user=" + this.username + ", messages=" + this.getMessagesAsString() + "}";
    }
}

