/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.audit;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import nl.tailormap.viewer.audit.LoggingService;
import nl.tailormap.viewer.audit.impl.DefaultLoggingService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public interface LoggingServiceFactory {
    public static final Log LOG = LogFactory.getLog(LoggingServiceFactory.class);

    public static List<LoggingService> getInstances() {
        ServiceLoader<LoggingService> services = ServiceLoader.load(LoggingService.class);
        ArrayList<LoggingService> loggingServices = new ArrayList<LoggingService>();
        services.iterator().forEachRemaining(loggingServices::add);
        return loggingServices;
    }

    public static LoggingService getInstance() {
        List<LoggingService> loggingServices = LoggingServiceFactory.getInstances();
        LoggingService service2 = null;
        if (loggingServices.size() == 1) {
            service2 = loggingServices.get(0);
        } else {
            for (LoggingService service2 : loggingServices) {
                LOG.debug((Object)("found audit log provider: " + service2));
                if (service2 instanceof DefaultLoggingService) continue;
            }
        }
        LOG.debug((Object)("using audit log provider: " + service2));
        return service2;
    }
}

