/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.mail;

import java.io.File;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.Context;
import javax.naming.InitialContext;

public class Mailer {
    public static Session getMailSession() throws Exception {
        InitialContext init = new InitialContext();
        Context env = (Context)init.lookup("java:comp/env");
        Session session = (Session)env.lookup("mail/session");
        return session;
    }

    public static void sendMail(String fromName, String fromEmail, String email, String subject, String mailContent) throws Exception {
        Mailer.sendMail(fromName, fromEmail, email, subject, mailContent, null);
    }

    public static void sendMail(String fromName, String fromEmail, String email, String subject, String mailContent, String cc) throws Exception {
        InternetAddress from = new InternetAddress(fromEmail, fromName);
        MimeMessage msg = new MimeMessage(Mailer.getMailSession());
        msg.setFrom((Address)from);
        InternetAddress[] emailAddresses = InternetAddress.parse((String)email);
        msg.addRecipients(Message.RecipientType.TO, (Address[])emailAddresses);
        if (cc != null) {
            InternetAddress[] ccAddresses = InternetAddress.parse((String)cc);
            msg.addRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        msg.setContent((Object)mailContent, "text/plain");
        Transport.send((Message)msg);
    }

    public static void sendMail(String fromName, String fromEmail, String email, String subject, String mailContent, File attachment, String filename) throws Exception {
        InternetAddress from = new InternetAddress(fromEmail, fromName);
        MimeMessage msg = new MimeMessage(Mailer.getMailSession());
        msg.setFrom((Address)from);
        InternetAddress[] emailAddresses = InternetAddress.parse((String)email);
        msg.addRecipients(Message.RecipientType.TO, (Address[])emailAddresses);
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(mailContent);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        messageBodyPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(attachment);
        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
        messageBodyPart.setFileName(filename);
        multipart.addBodyPart((BodyPart)messageBodyPart);
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }
}

