/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.i18n;

import java.util.ResourceBundle;
import org.json.JSONObject;

public class ResourceBundleToJsProvider {
    public static String toJs(ResourceBundle bundle) {
        JSONObject i18nBundle = new JSONObject();
        for (String key : bundle.keySet()) {
            if (!key.startsWith("js.")) continue;
            String jsKey = key.replace("js.", "").replace(".", "_");
            String val = bundle.getString(key);
            i18nBundle.put(jsKey, (Object)val);
        }
        StringBuilder sb = new StringBuilder();
        String lang = bundle.getLocale().getLanguage();
        if (lang == null || lang.isEmpty()) {
            lang = "nl";
        }
        sb.append(String.format("i18next.init({ lng: '%1$s', fallbackLng: '%1$s', resources: { %1$s: { translation: ", lang));
        sb.append(i18nBundle.toString());
        sb.append(" } } });");
        return sb.toString();
    }
}

