/*
 * Decompiled with CFR 0.152.
 */
package org.opensphere.geometry.triangulation.model;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.LineSegment;
import org.opensphere.geometry.triangulation.model.Triangle;
import org.opensphere.geometry.triangulation.model.Vertex;

public class Edge {
    private int id;
    private LineSegment geometry;
    private boolean border;
    private Vertex oV;
    private Vertex eV;
    private List<Triangle> triangles = new ArrayList<Triangle>();
    private List<Edge> incidentEdges = new ArrayList<Edge>();

    public Edge() {
    }

    public Edge(int id) {
        this.id = id;
    }

    public Edge(int id, LineSegment geometry) {
        this.id = id;
        this.geometry = geometry;
    }

    public Edge(int id, boolean border) {
        this.id = id;
        this.border = border;
    }

    public Edge(int id, LineSegment geometry, boolean border) {
        this.id = id;
        this.geometry = geometry;
        this.border = border;
    }

    public Edge(int id, LineSegment geometry, Vertex oV, Vertex eV, boolean border) {
        this.id = id;
        this.geometry = geometry;
        this.oV = oV;
        this.eV = eV;
        this.border = border;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public LineSegment getGeometry() {
        return this.geometry;
    }

    public void setGeometry(LineSegment geometry) {
        this.geometry = geometry;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public Vertex getOV() {
        return this.oV;
    }

    public void setOV(Vertex oV) {
        this.oV = oV;
    }

    public Vertex getEV() {
        return this.eV;
    }

    public void setEV(Vertex eV) {
        this.eV = eV;
    }

    public List<Triangle> getTriangles() {
        return this.triangles;
    }

    public void setTriangles(List<Triangle> triangles) {
        this.triangles = triangles;
    }

    public List<Edge> getIncidentEdges() {
        return this.incidentEdges;
    }

    public void setIncidentEdges(List<Edge> edges) {
        this.incidentEdges = edges;
    }

    public boolean addTriangle(Triangle triangle) {
        return this.getTriangles().add(triangle);
    }

    public boolean addTriangles(List<Triangle> triangles) {
        return this.getTriangles().addAll(triangles);
    }

    public boolean removeTriangle(Triangle triangle) {
        return this.getTriangles().remove(triangle);
    }

    public boolean removeTriangles(List<Triangle> triangles) {
        return this.getTriangles().removeAll(triangles);
    }

    public boolean addIncidentEdge(Edge edge) {
        return this.getIncidentEdges().add(edge);
    }

    public boolean addIncidentEdges(List<Edge> edges) {
        return this.getIncidentEdges().addAll(edges);
    }

    public boolean removeIncidentEdge(Edge edge) {
        return this.getIncidentEdges().remove(edge);
    }

    public boolean removeAllIncidentEdges(List<Edge> edges) {
        return this.getIncidentEdges().removeAll(edges);
    }
}

