/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.EntityManager;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.ConfiguredAttribute;
import nl.tailormap.viewer.config.app.StartLayer;
import nl.tailormap.viewer.config.services.ArcGISFeatureSource;
import nl.tailormap.viewer.config.services.ArcGISService;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import nl.tailormap.viewer.config.services.FeatureTypeRelation;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.config.services.WMSService;
import org.apache.commons.beanutils.BeanUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ApplicationLayerHelper {
    public static JSONObject toJSONObject(ApplicationLayer al, EntityManager em) throws JSONException {
        return ApplicationLayerHelper.toJSONObject(al, false, false, em, null);
    }

    public static JSONObject toJSONObject(ApplicationLayer al, boolean includeAttributes, boolean includeRelations, EntityManager em, Application app) throws JSONException {
        StartLayer sl;
        Layer l;
        JSONObject o = new JSONObject();
        o.put("id", (Object)al.getId());
        o.put("layerName", (Object)al.getLayerName());
        if (al.getService() != null) {
            o.put("serviceId", (Object)al.getService().getId());
        }
        o.put("alias", (Object)al.getDisplayName(em));
        Layer layer = l = al.getService() == null ? null : al.getService().getLayer(al.getLayerName(), em);
        if (l != null && l.getFeatureType() != null) {
            o.put("featureType", (Object)l.getFeatureType().getId());
            o.put("featureTypeName", (Object)l.getFeatureType().getTypeName());
        }
        if (!al.getDetails().isEmpty()) {
            JSONObject d = new JSONObject();
            o.put("details", (Object)d);
            for (Map.Entry e : al.getDetails().entrySet()) {
                d.put((String)e.getKey(), (Object)((ClobElement)e.getValue()).getValue());
            }
        }
        if (includeAttributes) {
            ApplicationLayerHelper.addAttributesJSON(al, o, includeRelations, em);
        }
        if (l != null) {
            ApplicationLayerHelper.addLayerListDetails(al, o, l);
        }
        o.put("checked", (sl = (StartLayer)al.getStartLayers().get(app)) != null && sl.isChecked());
        return o;
    }

    public static void addLayerListDetails(ApplicationLayer al, JSONObject json, Layer l) {
        json.put("layerId", (Object)l.getId());
        if (l.getService() instanceof WMSService) {
            json.put("filterable", l.getFeatureType() != null);
        } else {
            json.put("filterable", l.isFilterable());
        }
        if (l.getService() instanceof ArcGISService) {
            json.put("filterable", l.getFeatureType() != null && !(l.getFeatureType().getFeatureSource() instanceof ArcGISFeatureSource));
        }
        boolean userLayer = l.isUserlayer() != null ? l.isUserlayer() : false;
        json.put("userlayer", userLayer);
        if (userLayer) {
            json.put("userlayer_original_layername", l.getDetails().get("userlayer_original_layername"));
            json.put("userlayer_original_feature_type_name", l.getDetails().get("userlayer_original_feature_type_name"));
        }
        json.put("bufferable", l.isBufferable());
        json.put("editable", l.getFeatureType() != null && l.getFeatureType().isWriteable());
        json.put("influence", al.getDetails().containsKey("influenceradius"));
        json.put("arc", l.getService().getProtocol().startsWith("arc"));
        json.put("wfs", l.getFeatureType() != null && l.getFeatureType().getFeatureSource().getProtocol().equals("wfs"));
        json.put("attribute", !al.getAttributes().isEmpty());
    }

    public static void addAttributesJSON(ApplicationLayer al, JSONObject json, boolean includeRelations, EntityManager em) throws JSONException {
        Layer layer = al.getService().getSingleLayer(al.getLayerName(), em);
        Map<Object, Object> featureTypeAttributes = new HashMap();
        SimpleFeatureType ft = null;
        if (layer != null && (ft = layer.getFeatureType()) != null) {
            featureTypeAttributes = ApplicationLayerHelper.makeAttributeDescriptorList(ft);
        }
        Integer geometryAttributeIndex = null;
        JSONArray jattributes = new JSONArray();
        json.put("attributes", (Object)jattributes);
        for (ConfiguredAttribute ca : al.getAttributes()) {
            JSONObject j = ca.toJSONObject();
            AttributeDescriptor ad = (AttributeDescriptor)featureTypeAttributes.get(ca.getFullName());
            if (ad != null) {
                j.put("alias", (Object)ad.getAlias());
                j.put("type", (Object)ad.getType());
                if (ft != null && ca.getAttributeName().equals(ft.getGeometryAttribute()) && ca.getFeatureType().getId() == ft.getId()) {
                    geometryAttributeIndex = jattributes.length();
                }
            }
            jattributes.put((Object)j);
        }
        if (ft != null) {
            json.put("geometryAttribute", (Object)ft.getGeometryAttribute());
            json.put("primaryKeyAttribute", (Object)ft.getPrimaryKeyAttribute());
            json.put("featureType", (Object)ft.getId());
            json.put("featureTypeName", (Object)ft.getTypeName());
            if (includeRelations) {
                json.put("relations", (Object)ApplicationLayerHelper.getRelationsJSON(layer));
                json.put("invertedRelations", (Object)ApplicationLayerHelper.getInvertedRelationsJSON(layer, em));
            }
        }
        if (geometryAttributeIndex != null) {
            json.put("geometryAttributeIndex", geometryAttributeIndex);
        }
    }

    public static JSONArray getRelationsJSON(Layer layer) throws JSONException {
        JSONArray j = new JSONArray();
        if (layer != null && layer.getFeatureType() != null) {
            for (FeatureTypeRelation rel : layer.getFeatureType().getRelations()) {
                JSONObject jRel = rel.toJSONObject();
                j.put((Object)jRel);
            }
        }
        return j;
    }

    public static JSONArray getInvertedRelationsJSON(Layer layer, EntityManager em) throws JSONException {
        JSONArray relations = new JSONArray();
        if (layer != null && layer.getFeatureType() != null) {
            List frs = em.createQuery("from FeatureTypeRelation where foreignFeatureType = :ft", FeatureTypeRelation.class).setParameter("ft", (Object)layer.getFeatureType()).getResultList();
            for (FeatureTypeRelation fr : frs) {
                relations.put((Object)fr.toJSONObject());
            }
        }
        return relations;
    }

    private static Map<String, AttributeDescriptor> makeAttributeDescriptorList(SimpleFeatureType ft) {
        HashMap<String, AttributeDescriptor> featureTypeAttributes = new HashMap<String, AttributeDescriptor>();
        for (AttributeDescriptor ad : ft.getAttributes()) {
            String name = ft.getId() + ":" + ad.getName();
            if (featureTypeAttributes.containsKey(name)) {
                return featureTypeAttributes;
            }
            featureTypeAttributes.put(name, ad);
        }
        if (ft.getRelations() != null) {
            for (FeatureTypeRelation rel : ft.getRelations()) {
                featureTypeAttributes.putAll(ApplicationLayerHelper.makeAttributeDescriptorList(rel.getForeignFeatureType()));
            }
        }
        return featureTypeAttributes;
    }

    public static void processStartLayers(ApplicationLayer appLayer, Application app, ApplicationLayer original, Application copyFrom) throws Exception {
        StartLayer sl = (StartLayer)original.getStartLayers().get(copyFrom);
        if (sl != null) {
            appLayer.getStartLayers().put(app, sl.deepCopy(appLayer, app));
        } else if (Objects.equals(app.getId(), copyFrom.getId())) {
            ArrayList al = new ArrayList(original.getStartLayers().values());
            for (int i = 0; i < al.size(); ++i) {
                StartLayer sl2 = (StartLayer)al.get(i);
                appLayer.getStartLayers().put(app, sl2.deepCopy(appLayer, app));
            }
        }
    }

    public static ApplicationLayer deepCopy(ApplicationLayer al, Map originalToCopy, Application app, boolean processStartLayers) throws Exception {
        ApplicationLayer copy = (ApplicationLayer)BeanUtils.cloneBean((Object)al);
        originalToCopy.put(al, copy);
        copy.setId(null);
        copy.setReaders(new HashSet(al.getReaders()));
        copy.setWriters(new HashSet(al.getWriters()));
        copy.setDetails(new HashMap(al.getDetails()));
        copy.setAttributes(new ArrayList());
        for (ConfiguredAttribute a : al.getAttributes()) {
            copy.getAttributes().add(a.deepCopy());
        }
        copy.setStartLayers(new HashMap());
        if (processStartLayers) {
            ApplicationLayerHelper.processStartLayers(copy, app, al, app);
        }
        return copy;
    }
}

