/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.app;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.services.Document;
import nl.tailormap.viewer.helpers.AuthorizationsHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LevelHelper {
    public static Set<Application> findApplications(Level l, EntityManager em) {
        while (l.getParent() != null) {
            l = l.getParent();
        }
        HashSet<Application> apps = new HashSet<Application>();
        apps.addAll(em.createQuery("from Application where root = :level").setParameter("level", (Object)l).getResultList());
        return apps;
    }

    public static JSONObject toJSONObject(Level level, boolean includeChildrenIds, Application app, HttpServletRequest request, EntityManager em) throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)level.getId());
        o.put("name", (Object)level.getName());
        o.put("background", level.isBackground());
        o.put("info", (Object)level.getInfo());
        o.put("url", (Object)level.getUrl());
        if (!level.getDocuments().isEmpty()) {
            JSONArray docs = new JSONArray();
            o.put("documents", (Object)docs);
            for (Document d : level.getDocuments()) {
                docs.put((Object)d.toJSONObject());
            }
        }
        if (!level.getLayers().isEmpty()) {
            JSONArray ls = new JSONArray();
            o.put("layers", (Object)ls);
            for (ApplicationLayer applicationLayer : level.getLayers()) {
                if (request != null && !AuthorizationsHelper.isAppLayerReadAuthorized(app, applicationLayer, request, em) || !applicationLayer.getStartLayers().containsKey(app)) continue;
                ls.put((Object)applicationLayer.getId().toString());
            }
        }
        if (includeChildrenIds && !level.getChildren().isEmpty()) {
            JSONArray cs = new JSONArray();
            o.put("children", (Object)cs);
            for (Level childLevel : level.getChildren()) {
                if (request != null && !AuthorizationsHelper.isLevelReadAuthorized(app, childLevel, request, em)) continue;
                cs.put((Object)childLevel.getId().toString());
            }
        }
        return o;
    }
}

