/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.featuresources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.JDBCFeatureSource;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceHelper;
import nl.tailormap.web.WaitPageStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.sqlserver.SQLServerDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;

public class JDBCFeatureSourceHelper
implements FeatureSourceHelper {
    private static final Log log = LogFactory.getLog(JDBCFeatureSourceHelper.class);

    @Override
    public List<nl.tailormap.viewer.config.services.SimpleFeatureType> createFeatureTypes(FeatureSource fs, WaitPageStatus status) throws Exception {
        return JDBCFeatureSourceHelper.createFSFeatureTypes((JDBCFeatureSource)fs, status);
    }

    @Override
    public org.geotools.data.FeatureSource openGeoToolsFeatureSource(FeatureSource fs, nl.tailormap.viewer.config.services.SimpleFeatureType sft) throws Exception {
        return JDBCFeatureSourceHelper.openGeoToolsFSFeatureSource((JDBCFeatureSource)fs, sft);
    }

    @Override
    public org.geotools.data.FeatureSource openGeoToolsFeatureSource(FeatureSource fs, nl.tailormap.viewer.config.services.SimpleFeatureType sft, int timeout) throws Exception {
        return JDBCFeatureSourceHelper.openGeoToolsFSFeatureSource((JDBCFeatureSource)fs, sft);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<nl.tailormap.viewer.config.services.SimpleFeatureType> createFSFeatureTypes(JDBCFeatureSource fs, WaitPageStatus status) throws Exception {
        status.setCurrentAction("Databaseverbinding maken...");
        ArrayList<nl.tailormap.viewer.config.services.SimpleFeatureType> createdFeatureTypes = new ArrayList<nl.tailormap.viewer.config.services.SimpleFeatureType>();
        DataStore store = null;
        try {
            store = JDBCFeatureSourceHelper.createDataStore(fs);
            status.setProgress(10);
            status.setCurrentAction("Lijst van tabellen met geo-informatie ophalen...");
            String[] typeNames = store.getTypeNames();
            status.setProgress(20);
            if (typeNames.length != 0) {
                double progress = 20.0;
                double progressPerTypeName = 80.0 / (double)typeNames.length;
                for (String typeName : typeNames) {
                    status.setCurrentAction("Inladen schema van tabel \"" + typeName + "\"...");
                    log.debug((Object)("Loading feature source " + typeName + " for JDBCFeatureSource " + fs.getName()));
                    SimpleFeatureSource gtFs = store.getFeatureSource(typeName);
                    nl.tailormap.viewer.config.services.SimpleFeatureType sft = new nl.tailormap.viewer.config.services.SimpleFeatureType();
                    sft.setTypeName(typeName);
                    sft.setFeatureSource((FeatureSource)fs);
                    sft.setWriteable(true);
                    if (gtFs.getInfo() != null) {
                        sft.setDescription(gtFs.getInfo().getDescription());
                    }
                    SimpleFeatureType gtFt = (SimpleFeatureType)gtFs.getSchema();
                    for (AttributeDescriptor gtAtt : gtFt.getAttributeDescriptors()) {
                        nl.tailormap.viewer.config.services.AttributeDescriptor att = new nl.tailormap.viewer.config.services.AttributeDescriptor();
                        sft.getAttributes().add(att);
                        att.setName(gtAtt.getLocalName());
                        AttributeType gtType = gtAtt.getType();
                        String binding = gtType.getBinding().getName();
                        if (gtAtt.getUserData().containsKey("org.geotools.jdbc.pk.column")) {
                            sft.setPrimaryKeyAttribute(gtAtt.getLocalName());
                        }
                        String type = "";
                        if (binding.equals("org.locationtech.jts.geom.MultiPolygon")) {
                            type = "multipolygon";
                        } else if (binding.equals("org.locationtech.jts.geom.Polygon")) {
                            type = "polygon";
                        } else if (binding.equals("org.locationtech.jts.geom.Geometry")) {
                            type = "geometry";
                        } else if (binding.equals("org.locationtech.jts.geom.LineString")) {
                            type = "linestring";
                        } else if (binding.equals("org.locationtech.jts.geom.Point")) {
                            type = "point";
                        } else if (binding.equals("org.locationtech.jts.geom.MultiLineString")) {
                            type = "multilinestring";
                        } else if (binding.equals("org.locationtech.jts.geom.MultiPoint")) {
                            type = "multipoint";
                        } else if (binding.equals("java.lang.Boolean")) {
                            type = "boolean";
                        } else if (binding.equals("java.lang.Long")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.String")) {
                            type = "string";
                        } else if (binding.equals("java.lang.Integer")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.Short")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.Double")) {
                            type = "double";
                        } else if (binding.equals("java.lang.Float")) {
                            type = "double";
                        } else if (binding.equals("java.sql.Timestamp")) {
                            type = "timestamp";
                        } else if (binding.equals("java.sql.Date")) {
                            type = "date";
                        } else if (binding.equals("java.math.BigDecimal")) {
                            type = "double";
                        }
                        if (sft.getGeometryAttribute() == null && gtType instanceof GeometryType) {
                            sft.setGeometryAttribute(att.getName());
                        }
                        att.setType(type);
                    }
                    createdFeatureTypes.add(sft);
                    status.setProgress((int)(progress += progressPerTypeName));
                }
            }
        }
        finally {
            status.setProgress(100);
            status.setCurrentAction("Databasegegevens ingeladen");
            status.setFinished(true);
            if (store != null) {
                store.dispose();
            }
        }
        return createdFeatureTypes;
    }

    public static DataStore createDataStore(JDBCFeatureSource fs) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject urlObj = new JSONObject(fs.getUrl());
        params.put("dbtype", urlObj.get("dbtype"));
        params.put("host", urlObj.get("host"));
        params.put("port", urlObj.get("port"));
        params.put("database", urlObj.get("database"));
        params.put("schema", fs.schema);
        params.put("user", fs.getUsername());
        params.put(JDBCDataStoreFactory.FETCHSIZE.key, 50);
        params.put("passwd", fs.getPassword());
        params.put(JDBCDataStoreFactory.EXPOSE_PK.key, true);
        params.put(JDBCDataStoreFactory.PK_METADATA_TABLE.key, "gt_pk_metadata");
        if (!urlObj.get("dbtype").equals("oracle")) {
            params.put(SQLServerDataStoreFactory.GEOMETRY_METADATA_TABLE.key, "geometry_columns");
        }
        HashMap<String, String> logParams = new HashMap<String, String>(params);
        if (fs.getPassword() != null) {
            logParams.put("passwd", String.valueOf(new char[fs.getPassword().length()]).replace("\u0000", "*"));
        }
        log.debug((Object)("Opening datastore using parameters: " + logParams));
        try {
            DataStore ds = DataStoreFinder.getDataStore(params);
            if (ds == null) {
                throw new Exception("Cannot open datastore using parameters " + logParams);
            }
            return ds;
        }
        catch (Exception e) {
            throw new Exception("Cannot open datastore using parameters " + logParams, e);
        }
    }

    public static org.geotools.data.FeatureSource openGeoToolsFSFeatureSource(JDBCFeatureSource fs, nl.tailormap.viewer.config.services.SimpleFeatureType sft) throws Exception {
        DataStore ds = JDBCFeatureSourceHelper.createDataStore(fs);
        return ds.getFeatureSource(sft.getTypeName());
    }

    static FeatureCollection getFeatures(JDBCFeatureSource fs, nl.tailormap.viewer.config.services.SimpleFeatureType sft, Filter f, int maxFeatures) throws Exception {
        FeatureCollection fc = null;
        fc = f != null ? JDBCFeatureSourceHelper.openGeoToolsFSFeatureSource(fs, sft).getFeatures(f) : JDBCFeatureSourceHelper.openGeoToolsFSFeatureSource(fs, sft).getFeatures();
        return fc;
    }

    public static void loadFeatureTypes(JDBCFeatureSource fs) throws Exception {
        JDBCFeatureSourceHelper.loadFeatureTypes(fs, new WaitPageStatus());
    }

    public static void loadFeatureTypes(JDBCFeatureSource fs, WaitPageStatus status) throws Exception {
        fs.getFeatureTypes().addAll(JDBCFeatureSourceHelper.createFSFeatureTypes(fs, status));
    }
}

