/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.featuresources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.SimpleMessage;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.ConfiguredAttribute;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import nl.tailormap.viewer.config.services.FeatureTypeRelation;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

public class SimpleFeatureTypeHelper {
    private static final Log log = LogFactory.getLog(SimpleFeatureTypeHelper.class);

    public static void clearReferences(Collection<SimpleFeatureType> typesToRemove) {
        int removed = Stripersist.getEntityManager().createQuery("update Layer set featureType = null where featureType in (:types)").setParameter("types", typesToRemove).executeUpdate();
        if (removed > 0) {
            log.warn((Object)("Cleared " + removed + " references to " + typesToRemove.size() + " type names which are to be removed"));
        }
    }

    public static void synchronizeFeaturetype(ApplicationLayer appLayer, EntityManager em, ActionBeanContext context, ResourceBundle bundle, Map<String, String> attributeAliases, boolean geomVisible) {
        Layer layer = appLayer.getService().getSingleLayer(appLayer.getLayerName(), em);
        if (layer != null) {
            if (layer.getFeatureType() == null || layer.getFeatureType().getAttributes().isEmpty()) {
                appLayer.getAttributes().clear();
            } else {
                SimpleFeatureType sft = layer.getFeatureType();
                List<String> attributesToRetain = SimpleFeatureTypeHelper.rebuildAttributes(appLayer, sft, em, context, bundle, attributeAliases, geomVisible);
                ArrayList<ConfiguredAttribute> attributesToRemove = new ArrayList<ConfiguredAttribute>();
                for (ConfiguredAttribute ca : appLayer.getAttributes()) {
                    if (ca.getFeatureType() == null) {
                        ca.setFeatureType(layer.getFeatureType());
                    }
                    if (attributesToRetain.contains(ca.getFullName())) continue;
                    attributesToRemove.add(ca);
                    if (context == null || "save".equals(context.getEventName())) continue;
                    context.getMessages().add(new SimpleMessage(bundle.getString("viewer_admin.applicationtreelayeractionbean.unavailable"), new Object[]{ca.getAttributeName()}));
                }
                for (ConfiguredAttribute ca : attributesToRemove) {
                    appLayer.getAttributes().remove(ca);
                    em.remove((Object)ca);
                }
            }
        }
    }

    private static List<String> rebuildAttributes(ApplicationLayer appLayer, SimpleFeatureType sft, EntityManager em, ActionBeanContext context, ResourceBundle bundle, Map<String, String> attributeAliases, boolean geomVisible) {
        Layer layer = appLayer.getService().getSingleLayer(appLayer.getLayerName(), em);
        ArrayList<String> attributesToRetain = new ArrayList<String>();
        for (AttributeDescriptor ad : sft.getAttributes()) {
            String name = ad.getName();
            String fullName = sft.getId() + ":" + name;
            if (attributesToRetain.contains(fullName)) {
                return attributesToRetain;
            }
            attributesToRetain.add(fullName);
            if (StringUtils.isNotBlank((CharSequence)ad.getAlias())) {
                attributeAliases.put(fullName, ad.getAlias());
            }
            if (appLayer.getAttribute(sft, name) != null) continue;
            ConfiguredAttribute ca = new ConfiguredAttribute();
            boolean defaultVisible = true;
            if (!layer.getFeatureType().getId().equals(sft.getId()) || !geomVisible && AttributeDescriptor.GEOMETRY_TYPES.contains(ad.getType())) {
                defaultVisible = false;
            }
            ca.setVisible(defaultVisible);
            ca.setAttributeName(name);
            ca.setFeatureType(sft);
            appLayer.getAttributes().add(ca);
            em.persist((Object)ca);
            if (context == null || "save".equals(context.getEventName())) continue;
            String message = bundle.getString("viewer_admin.applicationtreelayeractionbean.newattr") + " ";
            if (!layer.getFeatureType().getId().equals(sft.getId())) {
                message = message + bundle.getString("viewer_admin.applicationtreelayeractionbean.joined") + " ";
            }
            message = message + bundle.getString("viewer_admin.applicationtreelayeractionbean.attrsrc") + " ";
            if (layer.getFeatureType().getId().equals(sft.getId())) {
                message = message + ": " + bundle.getString("viewer_admin.applicationtreelayeractionbean.visible");
            }
            context.getMessages().add(new SimpleMessage(message, new Object[]{name}));
        }
        if (sft.getRelations() != null) {
            for (FeatureTypeRelation rel : sft.getRelations()) {
                attributesToRetain.addAll(SimpleFeatureTypeHelper.rebuildAttributes(appLayer, rel.getForeignFeatureType(), em, context, bundle, attributeAliases, geomVisible));
            }
        }
        return attributesToRetain;
    }
}

