/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.services;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.StyleLibrary;
import nl.tailormap.viewer.config.services.UpdateResult;
import nl.tailormap.viewer.config.services.WMSExceptionType;
import nl.tailormap.viewer.config.services.WMSService;
import nl.tailormap.viewer.helpers.AuthorizationsHelper;
import nl.tailormap.web.WaitPageStatus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public interface GeoServiceHelper {
    public static JSONObject toJSONObject(GeoService geoService, boolean includeLayerTree, Set<String> layersToInclude, boolean validXmlTags, boolean includeAuthorizations, EntityManager em) throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)geoService.getId());
        o.put("name", (Object)geoService.getName());
        o.put("url", (Object)geoService.getUrl());
        o.put("protocol", (Object)geoService.getProtocol());
        o.put("readers", (Collection)geoService.getReaders());
        o.put("version", (Object)geoService.getVersion());
        if (geoService.getDetails().containsKey("useProxy")) {
            ClobElement ce = (ClobElement)geoService.getDetails().get("useProxy");
            boolean useProxy = Boolean.parseBoolean(ce.getValue());
            o.put("useProxy", useProxy);
            if (geoService.getPassword() != null && geoService.getUsername() != null) {
                o.put("mustLogin", true);
            }
        } else {
            o.put("useProxy", false);
        }
        if (geoService instanceof WMSService) {
            WMSExceptionType extype = ((WMSService)geoService).getException_type() != null ? ((WMSService)geoService).getException_type() : WMSExceptionType.Inimage;
            o.put("exception_type", (Object)extype.getDescription());
        }
        if (!validXmlTags) {
            JSONObject jStyleLibraries = new JSONObject();
            for (StyleLibrary sld : geoService.getStyleLibraries()) {
                JSONObject jsld = new JSONObject();
                String styleName = sld.getId().toString();
                jStyleLibraries.put("sld:" + styleName, (Object)jsld);
                jsld.put("id", (Object)sld.getId());
                jsld.put("title", (Object)sld.getTitle());
                jsld.put("default", sld.isDefaultStyle());
                if (sld.isDefaultStyle()) {
                    o.put("defaultStyleLibrary", (Object)jsld);
                }
                if (sld.getExternalUrl() != null) {
                    jsld.put("externalUrl", (Object)sld.getExternalUrl());
                }
                JSONObject userStylesPerNamedLayer = new JSONObject();
                if (sld.getNamedLayerUserStylesJson() != null) {
                    userStylesPerNamedLayer = new JSONObject(sld.getNamedLayerUserStylesJson());
                }
                jsld.put("userStylesPerNamedLayer", (Object)userStylesPerNamedLayer);
                if (sld.getExtraLegendParameters() != null) {
                    jsld.put("extraLegendParameters", (Object)sld.getExtraLegendParameters());
                }
                jsld.put("hasBody", sld.getExternalUrl() == null);
            }
            o.put("styleLibraries", (Object)jStyleLibraries);
        }
        if (geoService.getTopLayer() != null) {
            List layerEntities;
            if (em.contains((Object)geoService) && !(layerEntities = geoService.loadLayerTree(em)).isEmpty()) {
                List subList;
                int i = 0;
                do {
                    subList = layerEntities.subList(i, Math.min(layerEntities.size(), i + 500));
                    em.createQuery("from Layer l left join fetch l.details where l in (:layers)").setParameter("layers", subList).getResultList();
                } while ((i += subList.size()) < layerEntities.size());
            }
            JSONObject layers = new JSONObject();
            o.put("layers", (Object)layers);
            GeoServiceHelper.walkLayerJSONFlatten(geoService.getTopLayer(), layers, layersToInclude, validXmlTags, includeAuthorizations, em);
            if (includeLayerTree) {
                o.put("topLayer", (Object)GeoServiceHelper.walkLayerJSONTree(geoService.getTopLayer(), em));
            }
        }
        return o;
    }

    private static void walkLayerJSONFlatten(Layer l, JSONObject layers, Set<String> layersToInclude, boolean validXmlTags, boolean includeAuthorizations, EntityManager em) throws JSONException {
        if (!(layersToInclude != null && !layersToInclude.contains(l.getName()) || l.isVirtual() || l.getName() == null || layers.has(l.getName()))) {
            Object name = l.getName();
            if (validXmlTags) {
                name = "layer" + layers.length();
            }
            JSONObject layer = l.toJSONObject();
            if (includeAuthorizations) {
                AuthorizationsHelper.ReadWrite rw = AuthorizationsHelper.getLayerAuthorizations(l, em);
                layer.put("authorizations", (Object)(rw != null ? rw.toJSON() : new JSONObject()));
            }
            layers.put((String)name, (Object)layer);
        }
        for (Layer child : l.getCachedChildren(em)) {
            GeoServiceHelper.walkLayerJSONFlatten(child, layers, layersToInclude, validXmlTags, includeAuthorizations, em);
        }
    }

    private static JSONObject walkLayerJSONTree(Layer l, EntityManager em) throws JSONException {
        JSONObject j = l.toJSONObject();
        List children = l.getCachedChildren(em);
        if (!children.isEmpty()) {
            JSONArray jc = new JSONArray();
            j.put("children", (Object)jc);
            for (Layer child : children) {
                jc.put((Object)GeoServiceHelper.walkLayerJSONTree(child, em));
            }
        }
        return j;
    }

    public GeoService loadServiceFromURL(String var1, Map var2, WaitPageStatus var3, EntityManager var4) throws Exception;

    public UpdateResult updateService(EntityManager var1, GeoService var2) throws Exception;
}

