/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.services;

import java.util.HashMap;
import javax.persistence.EntityManager;
import nl.tailormap.viewer.config.services.ArcGISService;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.UpdateResult;
import nl.tailormap.viewer.config.services.WMSService;
import nl.tailormap.viewer.helpers.services.ArcGISServiceHelper;
import nl.tailormap.viewer.helpers.services.GeoServiceHelper;
import nl.tailormap.viewer.helpers.services.WMSServiceHelper;
import nl.tailormap.web.WaitPageStatus;

public class GeoserviceFactoryHelper {
    public static boolean isUpdatable(GeoService gs) {
        return gs instanceof ArcGISService || gs instanceof WMSService;
    }

    public static UpdateResult update(EntityManager em, GeoService gs) throws Exception {
        GeoServiceHelper helper = GeoserviceFactoryHelper.getServiceHelper(gs);
        return helper.updateService(em, gs);
    }

    public static void checkServiceOnline(EntityManager em, GeoService s) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("onlineCheckOnly", Boolean.TRUE);
        params.put("username", s.getUsername());
        params.put("password", s.getPassword());
        GeoServiceHelper helper = GeoserviceFactoryHelper.getServiceHelper(s);
        helper.loadServiceFromURL(s.getUrl(), params, new WaitPageStatus(){

            public void setCurrentAction(String currentAction) {
                this.currentAction.set(currentAction);
            }

            public void addLog(String message) {
                this.logs.add(message);
            }
        }, em);
    }

    public static GeoServiceHelper getServiceHelper(GeoService gs) {
        if (gs instanceof WMSService) {
            return new WMSServiceHelper();
        }
        if (gs instanceof ArcGISService) {
            return new ArcGISServiceHelper();
        }
        return null;
    }
}

