/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.services.BoundingBox;
import nl.tailormap.viewer.config.services.CoordinateReferenceSystem;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.helpers.services.BoundingBoxHelper;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wms.xml.MetadataURL;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

public class LayerHelper {
    private static final Log log = LogFactory.getLog(LayerHelper.class);
    private static Set<String> allowedSrsList = new HashSet<String>(Arrays.asList("EPSG:28992"));

    public static Layer pluckCopy(Layer l) {
        if (Stripersist.getEntityManager().contains((Object)l)) {
            throw new IllegalStateException();
        }
        try {
            Layer clone = (Layer)BeanUtils.cloneBean((Object)l);
            clone.setParent(null);
            clone.setChildren(new ArrayList());
            clone.setService(null);
            return clone;
        }
        catch (Exception e) {
            log.error((Object)"Cannot clone layer");
            return null;
        }
    }

    public static Layer loadLayer(org.geotools.ows.wms.Layer gtLayer, GeoService service) {
        Layer l = new Layer();
        l.setName(gtLayer.getName());
        if (l.getName() != null && l.getName().length() > 254) {
            log.warn((Object)("Layer name longer than 254 char will be truncated, was: " + l.getName()));
            l.setName(l.getName().substring(0, 252) + "...");
            log.warn((Object)("Truncated layer name is: " + l.getName()));
        }
        l.setVirtual(l.getName() == null);
        l.setTitle(gtLayer.getTitle());
        if (l.getTitle() != null && l.getTitle().length() > 254) {
            log.warn((Object)("Layer title longer than 254 char will be truncated, was: " + l.getTitle()));
            l.setTitle(l.getTitle().substring(0, 252) + "...");
            log.warn((Object)("Truncated layer title is: " + l.getTitle()));
        }
        l.setMinScale(Double.valueOf(gtLayer.getScaleDenominatorMin()));
        l.setService(service);
        if (Double.isNaN(l.getMinScale())) {
            if (!Double.isNaN(gtLayer.getScaleDenominatorMin())) {
                l.setMinScale(Double.valueOf(gtLayer.getScaleDenominatorMin()));
            } else {
                l.setMinScale(null);
            }
        }
        l.setMaxScale(Double.valueOf(gtLayer.getScaleDenominatorMax()));
        if (Double.isNaN(l.getMaxScale())) {
            if (!Double.isNaN(gtLayer.getScaleDenominatorMax())) {
                l.setMaxScale(Double.valueOf(gtLayer.getScaleDenominatorMax()));
            } else {
                l.setMaxScale(null);
            }
        }
        if (l.getMinScale() == null && l.getMaxScale() == null) {
            l.setMinScale(Double.valueOf(gtLayer.getScaleDenominatorMin()));
            l.setMaxScale(Double.valueOf(gtLayer.getScaleDenominatorMax()));
            if (Double.isNaN(l.getMinScale())) {
                l.setMinScale(null);
            }
            if (Double.isNaN(l.getMaxScale())) {
                l.setMaxScale(null);
            }
            if (l.getMinScale() != null && l.getMaxScale() != null && l.getMinScale() < 750.0 && l.getMaxScale() < 5000.0) {
                l.setMaxScale(Double.valueOf(Math.sqrt(l.getMinScale() * l.getMinScale() / 2.0)));
                l.setMaxScale(Double.valueOf(Math.sqrt(l.getMaxScale() * l.getMaxScale() / 2.0)));
            }
        }
        for (CRSEnvelope e : gtLayer.getLayerBoundingBoxes()) {
            BoundingBox b = BoundingBoxHelper.createBoundingbox(e);
            l.getBoundingBoxes().put(b.getCrs(), b);
        }
        gtLayer.getSrs().retainAll(allowedSrsList);
        for (Object s : gtLayer.getSrs()) {
            l.getCrsList().add(new CoordinateReferenceSystem((String)s));
        }
        l.setQueryable(gtLayer.isQueryable());
        if (gtLayer.getKeywords() != null) {
            l.getKeywords().addAll(Arrays.asList(gtLayer.getKeywords()));
        }
        if (!gtLayer.getMetadataURL().isEmpty()) {
            l.getDetails().put("metadata.url", new ClobElement(((MetadataURL)gtLayer.getMetadataURL().get(0)).getUrl().toString()));
        }
        if (!gtLayer.getStyles().isEmpty()) {
            try {
                JSONArray styles = new JSONArray();
                for (StyleImpl style : gtLayer.getStyles()) {
                    JSONObject jstyle = new JSONObject();
                    styles.put((Object)jstyle);
                    jstyle.put("name", (Object)style.getName());
                    if (style.getTitle() != null) {
                        jstyle.put("title", (Object)style.getTitle().toString());
                    }
                    if (style.getAbstract() != null) {
                        jstyle.put("abstract", (Object)style.getAbstract().toString());
                    }
                    JSONArray legendUrls = new JSONArray();
                    jstyle.put("legendURLs", (Object)legendUrls);
                    for (String url : style.getLegendURLs()) {
                        if (!StringUtils.containsIgnoreCase((CharSequence)url, (CharSequence)"SERVICE=WMS")) {
                            url = url.concat("&SERVICE=WMS");
                        }
                        legendUrls.put((Object)url);
                    }
                }
                if (styles.length() > 0) {
                    l.getDetails().put("wms.styles", new ClobElement(styles.toString()));
                }
            }
            catch (JSONException e) {
                log.error((Object)"Error creating styles JSON", (Throwable)e);
            }
        }
        if (gtLayer.getStyles().size() > 0 && ((StyleImpl)gtLayer.getStyles().get(0)).getLegendURLs().size() > 0) {
            String legendUrl = (String)((StyleImpl)gtLayer.getStyles().get(0)).getLegendURLs().get(0);
            if (!StringUtils.containsIgnoreCase((CharSequence)legendUrl, (CharSequence)"SERVICE=WMS")) {
                legendUrl = legendUrl.concat("&SERVICE=WMS");
            }
            l.setLegendImageUrl(legendUrl);
        }
        for (org.geotools.ows.wms.Layer child : gtLayer.getLayerChildren()) {
            Layer childLayer = LayerHelper.loadLayer(child, service);
            childLayer.setParent(l);
            l.getChildren().add(childLayer);
        }
        return l;
    }

    public static void initLayerCollectionsForUpdate(GeoService service) {
        EntityManager em = Stripersist.getEntityManager();
        em.createQuery("from Layer l left join fetch l.crsList where l.service = :this").setParameter("this", (Object)service).getResultList();
        em.createQuery("from Layer l left join fetch l.boundingBoxes where l.service = :this").setParameter("this", (Object)service).getResultList();
        em.createQuery("from Layer l left join fetch l.keywords where l.service = :this").setParameter("this", (Object)service).getResultList();
        em.createQuery("from Layer l left join fetch l.details where l.service = :this").setParameter("this", (Object)service).getResultList();
        em.createQuery("from Layer l left join fetch l.children where l.service = :this").setParameter("this", (Object)service).getResultList();
    }

    public static void setAllChildrenDetail(Layer layer, EntityManager em) {
        layer.accept(new Layer.Visitor(){

            public boolean visit(final Layer l, EntityManager em) {
                if (!l.getChildren().isEmpty()) {
                    final MutableObject layerNames = new MutableObject(new ArrayList());
                    l.accept(new Layer.Visitor(){

                        public boolean visit(Layer child, EntityManager em) {
                            if (child != l && child.getChildren().isEmpty() && !child.isVirtual()) {
                                ((List)layerNames.getValue()).add(child.getName());
                            }
                            return true;
                        }
                    }, em);
                    if (!((List)layerNames.getValue()).isEmpty()) {
                        l.getDetails().put("all_children", new ClobElement(StringUtils.join((Iterable)((Iterable)layerNames.getValue()), (String)",")));
                        l.setVirtual(false);
                    }
                }
                return true;
            }
        }, em);
    }
}

