/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.services;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.OperationNotSupportedException;
import javax.persistence.EntityManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import nl.tailormap.commons.HttpClientConfigured;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.services.BoundingBox;
import nl.tailormap.viewer.config.services.CoordinateReferenceSystem;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.TileMatrix;
import nl.tailormap.viewer.config.services.TileMatrixSet;
import nl.tailormap.viewer.config.services.TileService;
import nl.tailormap.viewer.config.services.TileSet;
import nl.tailormap.viewer.config.services.UpdateResult;
import nl.tailormap.viewer.helpers.services.GeoServiceHelper;
import nl.tailormap.web.WaitPageStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.xpath.jaxp.XPathFactoryImpl;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TilingServiceHelper
implements GeoServiceHelper {
    private static final Log log = LogFactory.getLog(TilingServiceHelper.class);
    private static final DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;

    @Override
    public GeoService loadServiceFromURL(String url, Map params, WaitPageStatus status, EntityManager em) throws Exception {
        return TilingServiceHelper.loadFromURL(url, params, status, em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoService loadFromURL(String url, Map params, WaitPageStatus status, EntityManager em) throws Exception {
        status.setCurrentAction("Bezig met aanmaken tile service");
        try {
            String tp = (String)params.get("tilingProtocol");
            TileService s = null;
            if (tp.equals("WMTS")) {
                s = TilingServiceHelper.parseWMTSCapabilities(url, params, status, em);
            } else {
                s = new TileService();
                s.setUrl(url);
                String serviceName = (String)params.get("ServiceName");
                s.setName(serviceName);
                s.setTilingProtocol(tp);
                Layer topLayer = new Layer();
                topLayer.setVirtual(true);
                topLayer.setService((GeoService)s);
                Layer tilingLayer = new Layer();
                tilingLayer.setName(serviceName);
                tilingLayer.setTitle(serviceName);
                tilingLayer.setParent(topLayer);
                tilingLayer.setService((GeoService)s);
                TileSet ts = new TileSet();
                Boolean unique = false;
                Object tsName = serviceName;
                for (int i = 0; i < 100; ++i) {
                    if (em.find(TileSet.class, tsName) == null) {
                        unique = true;
                        break;
                    }
                    tsName = serviceName + "(" + (i + 1) + ")";
                }
                ts.setName((String)tsName);
                if (params.containsKey("resolutions")) {
                    String resString = (String)params.get("resolutions");
                    ts.setResolutions(resString);
                }
                if (params.containsKey("tileSize")) {
                    Integer size = (Integer)params.get("tileSize");
                    ts.setHeight(size.intValue());
                    ts.setWidth(size.intValue());
                }
                if (params.containsKey("serviceBbox") && params.containsKey("crs")) {
                    String bounds = (String)params.get("serviceBbox");
                    BoundingBox bb = new BoundingBox();
                    bb.setBounds(bounds);
                    bb.setCrs(new CoordinateReferenceSystem((String)params.get("crs")));
                    tilingLayer.getBoundingBoxes().put(bb.getCrs(), bb);
                }
                if (params.containsKey("imageExtension") && params.get("imageExtension") != null && StringUtils.isNotBlank((CharSequence)((String)params.get("imageExtension")))) {
                    tilingLayer.getDetails().put("image_extension", new ClobElement((String)params.get("imageExtension")));
                }
                topLayer.getChildren().add(tilingLayer);
                s.setTopLayer(topLayer);
                em.persist((Object)ts);
                tilingLayer.setTileset(ts);
            }
            TileService tileService = s;
            return tileService;
        }
        finally {
            status.setProgress(90);
            status.setCurrentAction("Service ingeladen");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TileService parseWMTSCapabilities(String url, Map params, WaitPageStatus status, EntityManager em) {
        TileService s = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            String username = null;
            String password = null;
            if (params.containsKey("username") && params.containsKey("password")) {
                username = (String)params.get("username");
                password = (String)params.get("password");
            }
            HttpClientConfigured client = new HttpClientConfigured(username, password, url);
            HttpGet req = new HttpGet(url);
            Document doc = null;
            try {
                HttpResponse response = client.execute((HttpUriRequest)req);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode < 200) throw new IOException("HTTP status: " + statusCode + " reason: " + response.getStatusLine().getReasonPhrase());
                if (statusCode >= 300) throw new IOException("HTTP status: " + statusCode + " reason: " + response.getStatusLine().getReasonPhrase());
                HttpResponse finalResponse = response;
                HttpEntity entity = response.getEntity();
                try {
                    doc = builder.parse(entity.getContent());
                }
                catch (Exception e) {
                    log.error((Object)("Failed to retrieve getcapabilities: " + e.getLocalizedMessage()));
                    TileService tileService = null;
                    return tileService;
                }
                finally {
                    if (finalResponse != null) {
                        client.close(finalResponse);
                    }
                    client.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Check request; Failed to retrieve getcapabilities: " + e.getLocalizedMessage()));
                return null;
            }
            XPathFactoryImpl xPathfactory = new XPathFactoryImpl();
            XPath xpath = xPathfactory.newXPath();
            log.error((Object)"Parsing wmts getcap with following objects:");
            log.error((Object)("Xpath: " + xpath.getClass().toGenericString()));
            log.error((Object)("xPathfactory: " + xPathfactory.getClass().toGenericString()));
            s = new TileService();
            s.setTilingProtocol("WMTS");
            s.setCapabilitiesDoc(TilingServiceHelper.documentToString(doc));
            XPathExpression expr = xpath.compile("/Capabilities/ServiceIdentification/Title");
            log.error((Object)("XPathExpression: " + expr));
            log.error((Object)("XPathConstants: " + XPathConstants.class.toGenericString()));
            log.error((Object)("XPathConstants.STRING: " + XPathConstants.STRING));
            String serviceName = (String)expr.evaluate(doc, XPathConstants.STRING);
            s.setName(serviceName);
            expr = xpath.compile("/Capabilities/OperationsMetadata/Operation[@name='GetTile']//Constraint/AllowedValues/Value[.='KVP']/../../..//Get/@href");
            String getTile = (String)expr.evaluate(doc, XPathConstants.STRING);
            if (getTile.isEmpty()) {
                expr = xpath.compile("/Capabilities/OperationsMetadata/Operation[@name='GetTile']//Constraint/AllowedValues/Value[.='KVP']/../../../@href");
                getTile = (String)expr.evaluate(doc, XPathConstants.STRING);
            }
            if (getTile.isEmpty()) {
                getTile = url;
                status.addLog("viewer_admin.geoservice.52");
            }
            s.setUrl(getTile);
            List<TileMatrixSet> matrices = TilingServiceHelper.parseMatrixSets(xpath, doc);
            s.setMatrixSets(matrices);
            HashMap<String, TileMatrixSet> matricesByIdentifier = new HashMap<String, TileMatrixSet>();
            Iterator<TileMatrixSet> iterator = matrices.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Layer topLayer = new Layer();
                    topLayer.setVirtual(true);
                    topLayer.setService((GeoService)s);
                    List<Layer> layers = TilingServiceHelper.parseLayers(xpath, doc, topLayer, (GeoService)s, matricesByIdentifier);
                    topLayer.setChildren(layers);
                    s.setTopLayer(topLayer);
                    em.persist((Object)s);
                    return s;
                }
                TileMatrixSet matrix = iterator.next();
                matrix.setTileService(s);
                matricesByIdentifier.put(matrix.getIdentifier(), matrix);
            }
        }
        catch (ParserConfigurationException | TransformerException | XPathExpressionException ex) {
            log.error((Object)"Error reading capabilities: ", (Throwable)ex);
            return s;
        }
    }

    private static String documentToString(Document document) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        StringWriter sw = new StringWriter();
        trans.transform(new DOMSource(document), new StreamResult(sw));
        return sw.toString();
    }

    private static List<Layer> parseLayers(XPath xpath, Document doc, Layer topLayer, GeoService s, Map<String, TileMatrixSet> matricesByIdentifier) throws XPathExpressionException {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        XPathExpression expr = xpath.compile("/Capabilities/Contents/Layer");
        NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node l = nl.item(i);
            layers.add(TilingServiceHelper.parseLayer(xpath, l, topLayer, s, matricesByIdentifier));
        }
        return layers;
    }

    private static Layer parseLayer(XPath xpath, Node l, Layer topLayer, GeoService s, Map<String, TileMatrixSet> matricesByIdentifier) throws XPathExpressionException {
        Layer layer = new Layer();
        layer.setParent(topLayer);
        layer.setService(s);
        XPathExpression expr = xpath.compile("Identifier");
        String name = (String)expr.evaluate(l, XPathConstants.STRING);
        layer.setName(name);
        expr = xpath.compile("Title");
        String title = (String)expr.evaluate(l, XPathConstants.STRING);
        layer.setTitle(title);
        expr = xpath.compile("Format");
        String format = (String)expr.evaluate(l, XPathConstants.STRING);
        layer.getDetails().put("image_extension", new ClobElement(format));
        expr = xpath.compile("TileMatrixSetLink/TileMatrixSet");
        NodeList tileMatrixSets = (NodeList)expr.evaluate(l, XPathConstants.NODESET);
        ArrayList<TileMatrixSet> tmses = new ArrayList<TileMatrixSet>();
        for (int i = 0; i < tileMatrixSets.getLength(); ++i) {
            Node matrixSet = tileMatrixSets.item(i);
            String tileMatrixSetIdentifier = matrixSet.getFirstChild().getNodeValue();
            TileMatrixSet tms = matricesByIdentifier.get(tileMatrixSetIdentifier);
            tmses.add(tms);
        }
        layer.setMatrixSets(tmses);
        TilingServiceHelper.parseBoundingBox(layer, xpath, l, tmses);
        expr = xpath.compile("Style");
        NodeList styles = (NodeList)expr.evaluate(l, XPathConstants.NODESET);
        JSONArray stylesJSON = new JSONArray();
        for (int i = 0; i < styles.getLength(); ++i) {
            JSONObject styleJSON = new JSONObject();
            stylesJSON.put((Object)styleJSON);
            Node style = styles.item(i);
            expr = xpath.compile("Identifier");
            String identifier = (String)expr.evaluate(style, XPathConstants.STRING);
            styleJSON.put("identifier", (Object)identifier);
            if (style.getAttributes().getNamedItem("isDefault") == null) continue;
            String isDefault = style.getAttributes().getNamedItem("isDefault").getNodeValue();
            styleJSON.put("isDefault", (Object)isDefault);
        }
        layer.getDetails().put("wms.styles", new ClobElement(stylesJSON.toString()));
        return layer;
    }

    private static void parseBoundingBox(Layer layer, XPath xpath, Node l, List<TileMatrixSet> tmses) throws XPathExpressionException {
        XPathExpression expr = xpath.compile("WGS84BoundingBox/LowerCorner");
        String lowercorner = (String)expr.evaluate(l, XPathConstants.STRING);
        expr = xpath.compile("WGS84BoundingBox/UpperCorner");
        String uppercorner = (String)expr.evaluate(l, XPathConstants.STRING);
        if (lowercorner != null && uppercorner != null && !lowercorner.isEmpty() && !uppercorner.isEmpty()) {
            try {
                double lat1 = Double.parseDouble(uppercorner.substring(0, uppercorner.indexOf(" ")));
                double lon1 = Double.parseDouble(uppercorner.substring(uppercorner.indexOf(" ") + 1));
                double lat2 = Double.parseDouble(lowercorner.substring(0, lowercorner.indexOf(" ")));
                double lon2 = Double.parseDouble(lowercorner.substring(lowercorner.indexOf(" ") + 1));
                Envelope env = new Envelope(lat1, lat2, lon2, lon1);
                for (TileMatrixSet tms : tmses) {
                    if (!tms.getCrs().contains("28992")) continue;
                    org.opengis.referencing.crs.CoordinateReferenceSystem targetCRS = CRS.decode((String)tms.getCrs());
                    MathTransform transform = CRS.findMathTransform((org.opengis.referencing.crs.CoordinateReferenceSystem)wgs84, (org.opengis.referencing.crs.CoordinateReferenceSystem)targetCRS, (boolean)false);
                    Envelope newBBox = JTS.transform((Envelope)env, (MathTransform)transform);
                    BoundingBox bbox = new BoundingBox();
                    CoordinateReferenceSystem crs = new CoordinateReferenceSystem(tms.getCrs());
                    bbox.setCrs(crs);
                    bbox.setMaxx(Double.valueOf(newBBox.getMaxX()));
                    bbox.setMinx(Double.valueOf(newBBox.getMinX()));
                    bbox.setMaxy(Double.valueOf(newBBox.getMaxY()));
                    bbox.setMiny(Double.valueOf(newBBox.getMinY()));
                    layer.getBoundingBoxes().put(crs, bbox);
                }
            }
            catch (FactoryException | TransformException ex) {
                log.error((Object)"cannot parse bounding boxes", ex);
            }
        }
    }

    public static List<TileMatrixSet> parseMatrixSets(XPath xpath, Document doc) throws XPathExpressionException {
        ArrayList<TileMatrixSet> tmses = new ArrayList<TileMatrixSet>();
        XPathExpression expr = xpath.compile("/Capabilities/Contents/TileMatrixSet");
        NodeList tileMatrixSets = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < tileMatrixSets.getLength(); ++i) {
            Node matrixSet = tileMatrixSets.item(i);
            tmses.add(TilingServiceHelper.parseTileMatrixSet(xpath, matrixSet));
        }
        return tmses;
    }

    public static TileMatrixSet parseTileMatrixSet(XPath xpath, Node matrixSet) throws XPathExpressionException {
        TileMatrixSet tms = new TileMatrixSet();
        ArrayList<TileMatrix> tileMatrices = new ArrayList<TileMatrix>();
        tms.setMatrices(tileMatrices);
        XPathExpression expr = xpath.compile("TileMatrix");
        NodeList tileMatricesNodes = (NodeList)expr.evaluate(matrixSet, XPathConstants.NODESET);
        for (int i = 0; i < tileMatricesNodes.getLength(); ++i) {
            Node tileMatrix = tileMatricesNodes.item(i);
            tileMatrices.add(TilingServiceHelper.parseTileMatrix(xpath, tileMatrix, tms));
        }
        expr = xpath.compile("Identifier");
        String identifier = (String)expr.evaluate(matrixSet, XPathConstants.STRING);
        tms.setIdentifier(identifier);
        expr = xpath.compile("SupportedCRS");
        String crs = (String)expr.evaluate(matrixSet, XPathConstants.STRING);
        tms.setCrs(crs);
        TileMatrix tm = (TileMatrix)tileMatrices.get(tileMatrices.size() - 1);
        String topLeft = tm.getTopLeftCorner();
        double minX = new Double(topLeft.substring(0, topLeft.indexOf(" ")));
        double maxY = new Double(topLeft.substring(topLeft.indexOf(" ") + 1));
        double scaleDenominator = new Double(tm.getScaleDenominator());
        double pixelSpan = scaleDenominator * 2.8E-4 / TilingServiceHelper.metersPerUnit(crs);
        double tileSpanX = (double)tm.getTileWidth() * pixelSpan;
        double tileSpanY = (double)tm.getTileHeight() * pixelSpan;
        double maxX = minX + tileSpanX * (double)tm.getMatrixWidth();
        double minY = maxY - tileSpanY * (double)tm.getMatrixHeight();
        BoundingBox bb = new BoundingBox();
        bb.setCrs(new CoordinateReferenceSystem(crs));
        bb.setMinx(Double.valueOf(minX));
        bb.setMaxx(Double.valueOf(maxX));
        bb.setMaxy(Double.valueOf(maxY));
        bb.setMiny(Double.valueOf(minY));
        tms.setBbox(bb);
        return tms;
    }

    public static double metersPerUnit(String crs) {
        return 1.0;
    }

    private static TileMatrix parseTileMatrix(XPath xpath, Node tileMatrix, TileMatrixSet tms) throws XPathExpressionException {
        TileMatrix tm = new TileMatrix();
        tm.setMatrixSet(tms);
        XPathExpression expr = xpath.compile("Identifier");
        String identifier = (String)expr.evaluate(tileMatrix, XPathConstants.STRING);
        tm.setIdentifier(identifier);
        expr = xpath.compile("ScaleDenominator");
        String scaledenom = (String)expr.evaluate(tileMatrix, XPathConstants.STRING);
        tm.setScaleDenominator(scaledenom);
        expr = xpath.compile("TopLeftCorner");
        String topLeft = (String)expr.evaluate(tileMatrix, XPathConstants.STRING);
        tm.setTopLeftCorner(topLeft);
        expr = xpath.compile("TileWidth");
        int tileWidth = ((Double)expr.evaluate(tileMatrix, XPathConstants.NUMBER)).intValue();
        tm.setTileWidth(tileWidth);
        expr = xpath.compile("TileHeight");
        int tileHeight = ((Double)expr.evaluate(tileMatrix, XPathConstants.NUMBER)).intValue();
        tm.setTileHeight(tileHeight);
        expr = xpath.compile("MatrixWidth");
        int matrixidth = ((Double)expr.evaluate(tileMatrix, XPathConstants.NUMBER)).intValue();
        tm.setMatrixWidth(matrixidth);
        expr = xpath.compile("MatrixHeight");
        int matrixHeight = ((Double)expr.evaluate(tileMatrix, XPathConstants.NUMBER)).intValue();
        tm.setMatrixHeight(matrixHeight);
        expr = xpath.compile("Title");
        String title = (String)expr.evaluate(tileMatrix, XPathConstants.STRING);
        tm.setTitle(title);
        expr = xpath.compile("Abstract");
        String desc = (String)expr.evaluate(tileMatrix, XPathConstants.STRING);
        tm.setDescription(desc);
        return tm;
    }

    @Override
    public UpdateResult updateService(EntityManager em, GeoService service) throws Exception {
        throw new OperationNotSupportedException("Updating tiling services not implemented");
    }

    public static JSONObject toJSONObject(TileService geoService, boolean flatten, Set<String> layersToInclude, boolean validXmlTags, boolean includeAuthorizations, EntityManager em) throws JSONException {
        JSONObject o = GeoServiceHelper.toJSONObject((GeoService)geoService, flatten, layersToInclude, validXmlTags, includeAuthorizations, em);
        if (geoService.getTilingProtocol() != null) {
            o.put("tilingProtocol", (Object)geoService.getTilingProtocol());
        }
        JSONArray matrixSetsArray = new JSONArray();
        for (TileMatrixSet matrixSet : geoService.getMatrixSets()) {
            matrixSetsArray.put((Object)matrixSet.toJSONObject());
        }
        o.put("matrixSets", (Object)matrixSetsArray);
        return o;
    }
}

