/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.config.services.UpdateResult;
import nl.tailormap.viewer.config.services.WFSFeatureSource;
import nl.tailormap.viewer.config.services.WMSService;
import nl.tailormap.viewer.helpers.featuresources.SimpleFeatureTypeHelper;
import nl.tailormap.viewer.helpers.featuresources.WFSFeatureSourceHelper;
import nl.tailormap.viewer.helpers.services.GeoServiceHelper;
import nl.tailormap.viewer.helpers.services.LayerHelper;
import nl.tailormap.web.WaitPageStatus;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.ServiceInfo;
import org.geotools.data.ows.Specification;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.http.HTTPClient;
import org.geotools.http.SimpleHttpClient;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.LayerDescription;
import org.geotools.ows.wms.WMS1_0_0;
import org.geotools.ows.wms.WMS1_1_0;
import org.geotools.ows.wms.WMS1_1_1;
import org.geotools.ows.wms.WMS1_3_0;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.request.DescribeLayerRequest;
import org.geotools.ows.wms.response.DescribeLayerResponse;
import org.stripesstuff.stripersist.Stripersist;

public class WMSServiceHelper
implements GeoServiceHelper {
    private static final Log log = LogFactory.getLog(WMSServiceHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WMSService loadFromUrl(String url, Map params, WaitPageStatus status, EntityManager em) throws Exception {
        try {
            status.setCurrentAction("Ophalen informatie...");
            String username = (String)params.get("username");
            String password = (String)params.get("password");
            WMSService wmsService = new WMSService();
            wmsService.setUsername(username);
            wmsService.setPassword(password);
            wmsService.setUrl(url);
            wmsService.setOverrideUrl(Boolean.valueOf(Boolean.TRUE.equals(params.get("overrideUrl"))));
            wmsService.setSkipDiscoverWFS(Boolean.valueOf(Boolean.TRUE.equals(params.get("skipDiscoverWFS"))));
            WebMapServer wms = WMSServiceHelper.getWebMapServer(username, password, url);
            String version = wms.getCapabilities().getVersion();
            wmsService.setVersion(version);
            if (Boolean.TRUE.equals(params.get("onlineCheckOnly"))) {
                WMSService wMSService = null;
                return wMSService;
            }
            WMSServiceHelper.load(wms, params, status, em, wmsService);
            WMSService wMSService = wmsService;
            return wMSService;
        }
        finally {
            status.setProgress(90);
            status.setCurrentAction("Service ingeladen");
        }
    }

    private static WebMapServer getWebMapServer(String username, String password, String url) throws IOException, MalformedURLException, ServiceException {
        SimpleHttpClient client = new SimpleHttpClient();
        client.setUser(username);
        client.setPassword(password);
        return new WebMapServer(new URL(url), (HTTPClient)client){

            protected void setupSpecifications() {
                this.specs = new Specification[]{new WMS1_0_0(), new WMS1_1_0(), new WMS1_3_0(), new WMS1_1_1()};
            }
        };
    }

    private static void load(WebMapServer wms, Map params, WaitPageStatus status, EntityManager em, WMSService service) throws IOException, MalformedURLException, ServiceException {
        ServiceInfo si = wms.getInfo();
        service.setName(si.getTitle());
        String serviceUrl = si.getSource().toString();
        if (service.getOverrideUrl().booleanValue() && !service.getUrl().equals(serviceUrl)) {
            service.getDetails().put("overridenUrl", new ClobElement(serviceUrl));
        } else {
            service.setUrl(serviceUrl);
        }
        service.getKeywords().addAll(si.getKeywords());
        status.setCurrentAction("Inladen layers...");
        boolean supportsDescribeLayer = wms.getCapabilities().getRequest().getDescribeLayer() != null;
        status.setProgress(40);
        Layer rl = wms.getCapabilities().getLayer();
        service.setTopLayer(LayerHelper.loadLayer(rl, (GeoService)service));
        if (service.getSkipDiscoverWFS().booleanValue()) {
            status.setProgress(80);
            log.debug((Object)("Skip trying to discover WFS associated with " + service.toString()));
        } else {
            log.debug((Object)("Try to discover WFS associated with " + service.toString()));
            Map<String, List<LayerDescription>> layerDescByWfs = null;
            if (!"1.0.0".equals(wms.getCapabilities().getVersion())) {
                try {
                    status.setProgress(60);
                    status.setCurrentAction("Gerelateerde WFS bronnen opzoeken...");
                    layerDescByWfs = WMSServiceHelper.getDescribeLayerPerWFS(wms);
                }
                catch (Exception e) {
                    if (supportsDescribeLayer) {
                        log.error((Object)"DescribeLayer request failed", (Throwable)e);
                    }
                    log.debug((Object)"DescribeLayer not supported in Capabilities, did request anyway but failed");
                }
            }
            if (layerDescByWfs != null) {
                status.setProgress(80);
                String action = "Gerelateerde WFS bron inladen...";
                String[] wfses = layerDescByWfs.keySet().toArray(new String[0]);
                for (int i = 0; i < wfses.length; ++i) {
                    String wfsUrl = wfses[i];
                    String wfsAction = action + (String)(wfses.length > 1 ? " (" + (i + 1) + " van " + wfses.length + ")" : "");
                    status.setCurrentAction(wfsAction);
                    try {
                        List<LayerDescription> layerDescriptions = layerDescByWfs.get(wfsUrl);
                        WMSServiceHelper.loadLayerFeatureTypes(wfsUrl, layerDescriptions, em, service);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed loading feature types from WFS " + wfsUrl), (Throwable)e);
                    }
                }
            }
        }
    }

    private static Map<String, List<LayerDescription>> getDescribeLayerPerWFS(WebMapServer wms) {
        ArrayList<String> layers = new ArrayList<String>();
        HashMap<String, List<LayerDescription>> layerDescByWfs = new HashMap<String, List<LayerDescription>>();
        WMSServiceHelper.getAllNonVirtualLayers(layers, wms.getCapabilities().getLayer());
        int batchsize = 10;
        for (int i = 0; i < layers.size(); i += batchsize) {
            int to = i + batchsize > layers.size() ? layers.size() : i + batchsize;
            List<String> tempLayers = layers.subList(i, to);
            WMSServiceHelper.getDescribeFeature(tempLayers, layerDescByWfs, wms);
        }
        return layerDescByWfs;
    }

    private static void getDescribeFeature(List<String> ls, Map<String, List<LayerDescription>> layerDescByWfs, WebMapServer wms) {
        DescribeLayerResponse dlr = null;
        String layers = String.join((CharSequence)",", ls);
        try {
            DescribeLayerRequest dlreq = null;
            dlreq = wms.getCapabilities().getRequest().getDescribeLayer() != null ? wms.createDescribeLayerRequest() : new WMS1_1_0().createDescribeLayerRequest(wms.getInfo().getSource().toURL());
            dlreq.setProperty("VERSION", wms.getCapabilities().getVersion());
            dlreq.setLayers(layers);
            log.debug((Object)("Issuing DescribeLayer request for WMS " + wms.getInfo().getSource().toString() + " with layers=" + layers));
            dlr = wms.issueRequest(dlreq);
        }
        catch (IOException | UnsupportedOperationException | ServiceException e) {
            log.warn((Object)("DescribeLayer request failed for layers " + layers + " on service " + wms.getInfo().getSource().toString()), e);
        }
        if (dlr != null) {
            for (LayerDescription ld : dlr.getLayerDescs()) {
                String wfsUrl;
                log.debug((Object)String.format("DescribeLayer response, name=%s, wfs=%s, owsType=%s, owsURL=%s, typeNames=%s", ld.getName(), ld.getWfs(), ld.getOwsType(), ld.getOwsURL(), Arrays.toString(ld.getQueries())));
                String string = wfsUrl = ld.getWfs() != null ? ld.getWfs().toString() : null;
                if (wfsUrl == null && "WFS".equalsIgnoreCase(ld.getOwsType())) {
                    wfsUrl = ld.getOwsURL().toString();
                }
                if (wfsUrl == null) {
                    wfsUrl = wms.getInfo().getSource().toString();
                }
                if (wfsUrl == null || ld.getQueries() == null || ld.getQueries().length == 0) continue;
                List<LayerDescription> lds = layerDescByWfs.get(wfsUrl);
                if (lds == null) {
                    lds = new ArrayList<LayerDescription>();
                    layerDescByWfs.put(wfsUrl, lds);
                }
                lds.add(ld);
            }
        }
    }

    private static void getAllNonVirtualLayers(List<String> layers, Layer l) {
        if (l.getName() != null) {
            layers.add(l.getName());
        }
        for (Layer child : l.getChildren()) {
            WMSServiceHelper.getAllNonVirtualLayers(layers, child);
        }
    }

    private static void loadLayerFeatureTypes(String wfsUrl, List<LayerDescription> layerDescriptions, EntityManager em, WMSService service) {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(WFSDataStoreFactory.URL.key, wfsUrl);
        p.put(WFSDataStoreFactory.USERNAME.key, service.getUsername());
        p.put(WFSDataStoreFactory.PASSWORD.key, service.getPassword());
        try {
            WFSFeatureSource wfsFs = new WFSFeatureSource(p);
            WFSFeatureSourceHelper.loadFeatureTypes(wfsFs);
            boolean used = false;
            for (LayerDescription ld : layerDescriptions) {
                SimpleFeatureType sft;
                nl.tailormap.viewer.config.services.Layer l = service.getLayer(ld.getName(), em);
                if (l == null) continue;
                TreeSet<String> uniqueQueries = new TreeSet<String>(Arrays.asList(ld.getQueries()));
                if (uniqueQueries.size() != 1) {
                    log.warn((Object)("Cannot handle multiple typeNames for layer " + l.getName() + ", only using the first. Type names: " + Arrays.toString(ld.getQueries())));
                }
                if ((sft = wfsFs.getFeatureType((String)uniqueQueries.first())) != null) {
                    l.setFeatureType(sft);
                    log.debug((Object)("Feature type for layer " + l.getName() + " set to feature type " + sft.getTypeName()));
                    used = true;
                    continue;
                }
                log.warn((Object)("Type name " + (String)uniqueQueries.first() + " in WFS for described layer " + l.getName() + " does not exist!"));
            }
            if (used) {
                log.debug((Object)("Type from WFSFeatureSource with url " + wfsUrl + " used by layer of WMS"));
                wfsFs.setLinkedService((GeoService)service);
            } else {
                log.debug((Object)("No type from WFSFeatureSource with url " + wfsUrl + " used!"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Error loading WFS from url " + wfsUrl), (Throwable)e);
        }
    }

    public static UpdateResult update(EntityManager em, WMSService service) {
        LayerHelper.initLayerCollectionsForUpdate((GeoService)service);
        UpdateResult result = new UpdateResult((GeoService)service, em);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("overrideUrl", service.getOverrideUrl());
            params.put("username", service.getUsername());
            params.put("password", service.getPassword());
            params.put("skipDiscoverWFS", service.getSkipDiscoverWFS());
            WMSService update = WMSServiceHelper.loadFromUrl(service.getUrl(), params, result.getWaitPageStatus().subtask("", 80.0f), em);
            if (!service.getUrl().equals(update.getUrl())) {
                service.setUrl(update.getUrl());
                result.changed();
            }
            if (Boolean.TRUE.equals(service.getOverrideUrl())) {
                service.getDetails().put("overridenUrl", (ClobElement)update.getDetails().get("overridenUrl"));
            } else {
                service.getDetails().remove("overridenUrl");
            }
            if (!service.getDetails().containsKey("originalName")) {
                service.getDetails().put("originalName", new ClobElement(update.getName()));
            } else {
                service.setName(update.getName());
            }
            if (!service.getKeywords().equals(update.getKeywords())) {
                service.getKeywords().clear();
                service.getKeywords().addAll(update.getKeywords());
            }
            Set<FeatureSource> linkedFS = WMSServiceHelper.getAutomaticallyLinkedFeatureSources(service.getTopLayer(), em);
            Map<String, WFSFeatureSource> linkedFSByURL = WMSServiceHelper.createFeatureSourceMapByURL(linkedFS);
            ArrayList<SimpleFeatureType> typesToRemove = new ArrayList<SimpleFeatureType>();
            HashSet<SimpleFeatureType> updatedFeatureTypes = new HashSet<SimpleFeatureType>();
            WMSServiceHelper.updateWFS(update, linkedFSByURL, updatedFeatureTypes, typesToRemove, result, em, service);
            WMSServiceHelper.updateLayers(update, linkedFSByURL, updatedFeatureTypes, result, em, service);
            WMSServiceHelper.updateLayerTree(update, result, service);
            WMSServiceHelper.removeOrphanLayersAfterUpdate(result);
            WMSServiceHelper.removeFeatureTypes(typesToRemove, result);
            result.setStatus(UpdateResult.Status.UPDATED);
        }
        catch (Exception e) {
            result.failedWithException(e);
        }
        return result;
    }

    private static Map<String, WFSFeatureSource> createFeatureSourceMapByURL(Collection<FeatureSource> fsCollection) {
        HashMap<String, WFSFeatureSource> map = new HashMap<String, WFSFeatureSource>();
        for (FeatureSource fs : fsCollection) {
            map.put(fs.getUrl(), (WFSFeatureSource)fs);
        }
        return map;
    }

    private static void removeFeatureTypes(Collection<SimpleFeatureType> typesToRemove, UpdateResult result) {
        if (typesToRemove.isEmpty()) {
            return;
        }
        SimpleFeatureTypeHelper.clearReferences(typesToRemove);
        for (SimpleFeatureType typeToRemove : typesToRemove) {
            typeToRemove.getFeatureSource().getFeatureTypes().remove(typeToRemove);
            Stripersist.getEntityManager().remove((Object)typeToRemove);
        }
    }

    private static Set<FeatureSource> getAutomaticallyLinkedFeatureSources(nl.tailormap.viewer.config.services.Layer top, EntityManager em) {
        final GeoService service = top.getService();
        final HashSet<FeatureSource> featureSources = new HashSet<FeatureSource>();
        top.accept(new Layer.Visitor(){

            public boolean visit(nl.tailormap.viewer.config.services.Layer l, EntityManager em) {
                FeatureSource fs;
                if (l.getFeatureType() != null && (fs = l.getFeatureType().getFeatureSource()).getLinkedService() == service) {
                    featureSources.add((WFSFeatureSource)fs);
                }
                return true;
            }
        }, em);
        return featureSources;
    }

    private static void updateWFS(WMSService updateWMS, Map<String, WFSFeatureSource> linkedFSesByURL, Set<SimpleFeatureType> updatedFeatureTypes, Collection<SimpleFeatureType> outTypesToRemove, UpdateResult result, EntityManager em, WMSService service) {
        Set<FeatureSource> updateFSes = WMSServiceHelper.getAutomaticallyLinkedFeatureSources(updateWMS.getTopLayer(), em);
        for (FeatureSource fs : updateFSes) {
            WFSFeatureSource oldFS = linkedFSesByURL.get(fs.getUrl());
            if (oldFS == null) {
                log.info((Object)("Found new WFS with URL " + fs.getUrl() + " linked to WMS"));
                linkedFSesByURL.put(fs.getUrl(), (WFSFeatureSource)fs);
                fs.setLinkedService((GeoService)service);
                continue;
            }
            log.info((Object)("Updating WFS with URL " + fs.getUrl() + " linked to WMS"));
            for (SimpleFeatureType updateFT : fs.getFeatureTypes()) {
                boolean isNew;
                MutableBoolean updated = new MutableBoolean();
                SimpleFeatureType updatedFT = oldFS.addOrUpdateFeatureType(updateFT.getTypeName(), updateFT, updated);
                boolean bl = isNew = updateFT == updatedFT;
                if (updated.isTrue()) {
                    updatedFeatureTypes.add(updatedFT);
                }
                if (!isNew) continue;
                log.info((Object)("New feature type in WFS: " + updateFT.getTypeName()));
            }
            HashSet<SimpleFeatureType> typesToRemove = new HashSet<SimpleFeatureType>();
            for (SimpleFeatureType oldFT : oldFS.getFeatureTypes()) {
                if (fs.getFeatureType(oldFT.getTypeName()) != null) continue;
                typesToRemove.add(oldFT);
                log.info((Object)("Feature type " + oldFT.getTypeName() + " does no longer exist"));
            }
            outTypesToRemove.addAll(typesToRemove);
        }
    }

    private static void updateLayers(WMSService update, final Map<String, WFSFeatureSource> linkedFSesByURL, final Set<SimpleFeatureType> updatedFeatureTypes, final UpdateResult result, EntityManager em, WMSService service) {
        final WMSService updatingWMSService = service;
        update.getTopLayer().accept(new Layer.Visitor(){

            public boolean visit(nl.tailormap.viewer.config.services.Layer l, EntityManager em) {
                if (l.getName() == null) {
                    return true;
                }
                MutablePair layerStatus = (MutablePair)result.getLayerStatus().get(l.getName());
                if (layerStatus == null) {
                    l = LayerHelper.pluckCopy(l);
                    result.getLayerStatus().put(l.getName(), (MutablePair<nl.tailormap.viewer.config.services.Layer, UpdateResult.Status>)new MutablePair((Object)l, (Object)UpdateResult.Status.NEW));
                    if (l.getFeatureType() != null) {
                        WFSFeatureSource fs = (WFSFeatureSource)linkedFSesByURL.get(l.getFeatureType().getFeatureSource().getUrl());
                        l.setFeatureType(fs.getFeatureType(l.getFeatureType().getTypeName()));
                    }
                } else {
                    if (layerStatus.getRight() != UpdateResult.Status.MISSING) {
                        return true;
                    }
                    nl.tailormap.viewer.config.services.Layer old = (nl.tailormap.viewer.config.services.Layer)layerStatus.getLeft();
                    old.setParent(null);
                    old.getChildren().clear();
                    old.update(l);
                    layerStatus.setRight((Object)UpdateResult.Status.UNMODIFIED);
                    if (old.getFeatureType() == null || old.getFeatureType().getFeatureSource().getLinkedService() == updatingWMSService) {
                        if (l.getFeatureType() != null) {
                            WFSFeatureSource fs = (WFSFeatureSource)linkedFSesByURL.get(l.getFeatureType().getFeatureSource().getUrl());
                            boolean wasNull = old.getFeatureType() == null;
                            old.setFeatureType(fs.getFeatureType(l.getFeatureType().getTypeName()));
                            if (wasNull || updatedFeatureTypes.contains(old.getFeatureType())) {
                                layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                            }
                        } else {
                            if (old.getFeatureType() != null) {
                                layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                            }
                            old.setFeatureType(null);
                        }
                    }
                }
                return true;
            }
        }, em);
    }

    private static void updateLayerTree(WMSService update, UpdateResult result, WMSService service) {
        nl.tailormap.viewer.config.services.Layer newTopLayer;
        String topLayerName = update.getTopLayer().getName();
        if (topLayerName == null) {
            newTopLayer = LayerHelper.pluckCopy(update.getTopLayer());
        } else {
            MutablePair res = (MutablePair)result.getLayerStatus().get(topLayerName);
            if (res == null) {
                throw new IllegalStateException("Not toplayer found... exiting updating layers");
            }
            newTopLayer = (nl.tailormap.viewer.config.services.Layer)res.getLeft();
        }
        newTopLayer.copyUserModifiedProperties(service.getTopLayer());
        newTopLayer.setParent(null);
        newTopLayer.setService((GeoService)service);
        newTopLayer.getChildren().clear();
        service.setTopLayer(newTopLayer);
        LinkedList<ImmutablePair> q = new LinkedList<ImmutablePair>();
        for (nl.tailormap.viewer.config.services.Layer child : update.getTopLayer().getChildren()) {
            q.add(new ImmutablePair((Object)child, (Object)newTopLayer));
        }
        HashSet<String> visitedLayerNames = new HashSet<String>();
        while (!q.isEmpty()) {
            nl.tailormap.viewer.config.services.Layer thisLayer;
            Pair p = (Pair)q.remove();
            nl.tailormap.viewer.config.services.Layer updateLayer = (nl.tailormap.viewer.config.services.Layer)p.getLeft();
            nl.tailormap.viewer.config.services.Layer parent = (nl.tailormap.viewer.config.services.Layer)p.getRight();
            String layerName = updateLayer.getName();
            if (layerName == null) {
                thisLayer = LayerHelper.pluckCopy(updateLayer);
            } else if (visitedLayerNames.contains(layerName)) {
                thisLayer = null;
            } else {
                MutablePair res = (MutablePair)result.getLayerStatus().get(layerName);
                thisLayer = (nl.tailormap.viewer.config.services.Layer)res.getLeft();
                visitedLayerNames.add(layerName);
            }
            if (thisLayer != null) {
                thisLayer.setService((GeoService)service);
                thisLayer.setParent(parent);
                parent.getChildren().add(thisLayer);
            }
            for (nl.tailormap.viewer.config.services.Layer child : updateLayer.getChildren()) {
                q.add(new ImmutablePair((Object)child, (Object)thisLayer));
            }
        }
    }

    private static void removeOrphanLayersAfterUpdate(UpdateResult result) {
        for (nl.tailormap.viewer.config.services.Layer layer : result.getDuplicateOrNoNameLayers()) {
            Stripersist.getEntityManager().remove((Object)layer);
        }
        for (Pair pair : result.getLayerStatus().values()) {
            if (pair.getRight() != UpdateResult.Status.MISSING) continue;
            Stripersist.getEntityManager().remove(pair.getLeft());
        }
    }

    @Override
    public GeoService loadServiceFromURL(String url, Map params, WaitPageStatus status, EntityManager em) throws Exception {
        return WMSServiceHelper.loadFromUrl(url, params, status, em);
    }

    @Override
    public UpdateResult updateService(EntityManager em, GeoService service) {
        return WMSServiceHelper.update(em, (WMSService)service);
    }
}

