/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.services;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.services.BoundingBox;
import nl.tailormap.viewer.config.services.CoordinateReferenceSystem;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.TileMatrix;
import nl.tailormap.viewer.config.services.TileMatrixSet;
import nl.tailormap.viewer.config.services.TileService;
import nl.tailormap.viewer.config.services.TileSet;
import nl.tailormap.viewer.helpers.services.TilingServiceHelper;
import nl.tailormap.viewer.util.TestUtil;
import nl.tailormap.web.WaitPageStatus;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TileServiceTest
extends TestUtil {
    private static final String PDOK_WMTS = "http://geodata.nationaalgeoregister.nl/tiles/service/wmts?request=getcapabilities";
    private static final int PDOK_WMTS_LAYERCOUNT = 37;
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder;
    XPathFactory xPathfactory = XPathFactory.newInstance();
    XPath xpath = this.xPathfactory.newXPath();

    public TileServiceTest() throws ParserConfigurationException {
        this.builder = this.factory.newDocumentBuilder();
    }

    @Test
    public void testLoadFromUrl() throws Exception {
        String url = "http://www.openbasiskaart.nl/mapcache/tms/1.0.0/osm-nb@rd";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ServiceName", "osm");
        params.put("resolutions", "1,2,4");
        params.put("serviceBbox", "16,32,18,34");
        params.put("crs", "28992");
        params.put("imageExtension", "png");
        params.put("tileSize", 256);
        params.put("tilingProtocol", "TMS");
        WaitPageStatus status = new WaitPageStatus();
        GeoService result = TilingServiceHelper.loadFromURL((String)url, params, (WaitPageStatus)status, (EntityManager)this.entityManager);
        Assertions.assertEquals((Object)"tiled", (Object)result.getProtocol());
        Assertions.assertEquals((Object)url, (Object)result.getUrl());
        TileService ts = (TileService)result;
        Assertions.assertEquals((Object)"osm", (Object)ts.getTilingLayer().getName());
        Assertions.assertEquals((Object)"TMS", (Object)ts.getTilingProtocol());
        Assertions.assertEquals((Object)ts.getUrl(), (Object)url);
        Layer l = ts.getTilingLayer();
        TileSet tileSet = l.getTileset();
        Assertions.assertEquals((int)3, (int)tileSet.getResolutions().size());
        Assertions.assertEquals((int)256, (int)tileSet.getHeight());
        Assertions.assertEquals((Object)"osm", (Object)tileSet.getName());
        Assertions.assertEquals((Object)"png", (Object)((ClobElement)l.getDetails().get("image_extension")).getValue());
        Assertions.assertEquals((int)0, (int)ts.getMatrixSets().size());
        JSONObject serviceObj = TilingServiceHelper.toJSONObject((TileService)ts, (boolean)false, null, (boolean)false, (boolean)false, (EntityManager)this.entityManager);
        Assertions.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assertions.assertEquals((int)0, (int)matrixSets.length());
    }

    @Test
    public void testLoadTopLayerChildWMTSFromURL() throws Exception {
        URL u = new URL(PDOK_WMTS);
        String url = u.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tilingProtocol", "WMTS");
        params.put("ServiceName", "Web Map Tile Service - GeoWebCache");
        WaitPageStatus status = new WaitPageStatus();
        GeoService result = TilingServiceHelper.loadFromURL((String)url, params, (WaitPageStatus)status, (EntityManager)this.entityManager);
        Assertions.assertEquals((Object)"https://geodata.nationaalgeoregister.nl/tiles/service/wmts?", (Object)result.getUrl());
        Layer topLayer = result.getTopLayer();
        Assertions.assertEquals((int)37, (int)topLayer.getChildren().size());
        Layer brt = (Layer)topLayer.getChildren().get(1);
        Assertions.assertEquals((Object)"natura2000", (Object)brt.getName());
        JSONArray styles = new JSONArray(((ClobElement)brt.getDetails().get("wms.styles")).getValue());
        JSONObject style = (JSONObject)styles.get(0);
        Assertions.assertEquals((Object)"", (Object)style.getString("identifier"));
        Assertions.assertEquals((int)1, (int)brt.getBoundingBoxes().size());
        BoundingBox bbox = (BoundingBox)brt.getBoundingBoxes().get(new CoordinateReferenceSystem("urn:ogc:def:crs:EPSG::28992"));
        Assertions.assertEquals((double)595401.9, (double)bbox.getMaxx(), (double)0.1);
        Assertions.assertEquals((double)903401.9, (double)bbox.getMaxy(), (double)0.1);
        Assertions.assertEquals((double)-370406.0, (double)bbox.getMinx(), (double)0.1);
        Assertions.assertEquals((double)5328.8, (double)bbox.getMiny(), (double)0.1);
        JSONObject serviceObj = TilingServiceHelper.toJSONObject((TileService)((TileService)result), (boolean)false, null, (boolean)false, (boolean)false, (EntityManager)this.entityManager);
        Assertions.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assertions.assertEquals((int)4, (int)matrixSets.length());
        JSONObject matrix = matrixSets.getJSONObject(1);
        JSONArray matrices = matrix.getJSONArray("matrices");
        Assertions.assertEquals((int)15, (int)matrices.length());
        Assertions.assertTrue((boolean)serviceObj.has("layers"));
        JSONObject layers = serviceObj.getJSONObject("layers");
        JSONObject jsonLayer = layers.getJSONObject("natura2000");
        Assertions.assertNotNull((Object)jsonLayer);
        Assertions.assertTrue((boolean)jsonLayer.has("bbox"));
    }

    @Test
    public void testLoadArcGisWMTSFromURL() throws Exception {
        URL u = new URL("https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/arcgis/rest/services/Historische_tijdreis_1950/MapServer/WMTS?request=getcapabilities");
        String url = u.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tilingProtocol", "WMTS");
        WaitPageStatus status = new WaitPageStatus();
        GeoService result = TilingServiceHelper.loadFromURL((String)url, params, (WaitPageStatus)status, (EntityManager)this.entityManager);
        Assertions.assertEquals((Object)"https://tiles.arcgis.com/tiles/nSZVuSZjHpEZZbRo/arcgis/rest/services/Historische_tijdreis_1950/MapServer/WMTS?", (Object)result.getUrl());
        Layer topLayer = result.getTopLayer();
        Assertions.assertEquals((int)1, (int)topLayer.getChildren().size());
        Layer tijdreis = (Layer)topLayer.getChildren().get(0);
        Assertions.assertEquals((Object)"Historische_tijdreis_1950", (Object)tijdreis.getName());
        JSONArray styles = new JSONArray(((ClobElement)tijdreis.getDetails().get("wms.styles")).getValue());
        JSONObject style = (JSONObject)styles.get(0);
        Assertions.assertEquals((Object)"default", (Object)style.getString("identifier"));
        Assertions.assertEquals((int)1, (int)tijdreis.getBoundingBoxes().size());
        BoundingBox bbox = (BoundingBox)tijdreis.getBoundingBoxes().get(new CoordinateReferenceSystem("urn:ogc:def:crs:EPSG::28992"));
        Assertions.assertEquals((double)-7170.5, (double)bbox.getMiny(), (double)0.1);
        Assertions.assertEquals((double)-22869.1, (double)bbox.getMinx(), (double)0.1);
        Assertions.assertEquals((double)312667.7, (double)bbox.getMaxx(), (double)0.1);
        Assertions.assertEquals((double)662419.8, (double)bbox.getMaxy(), (double)0.1);
        JSONObject serviceObj = TilingServiceHelper.toJSONObject((TileService)((TileService)result), (boolean)false, null, (boolean)false, (boolean)false, (EntityManager)this.entityManager);
        Assertions.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assertions.assertEquals((int)1, (int)matrixSets.length());
        JSONObject matrix = matrixSets.getJSONObject(0);
        JSONArray matrices = matrix.getJSONArray("matrices");
        Assertions.assertEquals((int)12, (int)matrices.length());
        Assertions.assertTrue((boolean)serviceObj.has("layers"));
        JSONObject layers = serviceObj.getJSONObject("layers");
        JSONObject jsonLayer = layers.getJSONObject("Historische_tijdreis_1950");
        Assertions.assertNotNull((Object)jsonLayer);
        Assertions.assertTrue((boolean)jsonLayer.has("bbox"));
    }

    @Test
    public void testLoadTopLayerWMTSFromURL() throws Exception {
        URL u = new URL(PDOK_WMTS);
        String url = u.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tilingProtocol", "WMTS");
        params.put("ServiceName", "Web Map Tile Service - GeoWebCache");
        WaitPageStatus status = new WaitPageStatus();
        GeoService result = TilingServiceHelper.loadFromURL((String)url, params, (WaitPageStatus)status, (EntityManager)this.entityManager);
        Layer topLayer = result.getTopLayer();
        Assertions.assertEquals((int)37, (int)topLayer.getChildren().size());
        Assertions.assertEquals((Object)"https://geodata.nationaalgeoregister.nl/tiles/service/wmts?", (Object)result.getUrl());
        Layer brt = (Layer)topLayer.getChildren().get(0);
        Assertions.assertEquals((Object)"top10nlv2", (Object)brt.getName());
        Assertions.assertEquals((int)1, (int)brt.getBoundingBoxes().size());
        BoundingBox bbox = ((TileMatrixSet)brt.getMatrixSets().get(0)).getBbox();
        Assertions.assertEquals((double)595401.91, (double)bbox.getMaxx(), (double)0.01);
        Assertions.assertEquals((double)903402.0, (double)bbox.getMaxy(), (double)0.01);
        Assertions.assertEquals((double)-285401.92, (double)bbox.getMinx(), (double)0.01);
        Assertions.assertEquals((double)22598.16, (double)bbox.getMiny(), (double)0.01);
        JSONObject serviceObj = TilingServiceHelper.toJSONObject((TileService)((TileService)result), (boolean)false, null, (boolean)false, (boolean)false, (EntityManager)this.entityManager);
        Assertions.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assertions.assertEquals((int)4, (int)matrixSets.length());
        JSONObject matrix = matrixSets.getJSONObject(1);
        JSONArray matrices = matrix.getJSONArray("matrices");
        Assertions.assertEquals((int)15, (int)matrices.length());
        Assertions.assertTrue((boolean)serviceObj.has("layers"));
        JSONObject layers = serviceObj.getJSONObject("layers");
        JSONObject jsonLayer = layers.getJSONObject("top10nlv2");
        Assertions.assertNotNull((Object)jsonLayer);
        Assertions.assertTrue((boolean)jsonLayer.has("bbox"));
    }

    @Test
    @Disabled(value="Meine knows why..")
    public void testLoadLufoWMTSFromURL() throws Exception {
        URL u = new URL("http://webservices.gbo-provincies.nl/lufo/services/wmts?request=GetCapabilities");
        String url = u.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tilingProtocol", "WMTS");
        params.put("ServiceName", "luchtfoto");
        WaitPageStatus status = new WaitPageStatus();
        GeoService result = TilingServiceHelper.loadFromURL((String)url, params, (WaitPageStatus)status, (EntityManager)this.entityManager);
        Layer topLayer = result.getTopLayer();
        Assertions.assertEquals((int)12, (int)topLayer.getChildren().size());
        Assertions.assertEquals((Object)"http://webservices.gbo-provincies.nl/lufo/services/wmts?", (Object)result.getUrl());
        Layer actueelWinter = (Layer)topLayer.getChildren().get(0);
        Assertions.assertEquals((Object)"actueel_winter", (Object)actueelWinter.getName());
        Assertions.assertEquals((int)1, (int)actueelWinter.getBoundingBoxes().size());
        BoundingBox bbox = ((TileMatrixSet)actueelWinter.getMatrixSets().get(0)).getBbox();
        Assertions.assertEquals((double)595401.92, (double)bbox.getMaxx(), (double)0.01);
        Assertions.assertEquals((double)903401.92, (double)bbox.getMaxy(), (double)0.01);
        Assertions.assertEquals((double)-285401.92, (double)bbox.getMinx(), (double)0.01);
        Assertions.assertEquals((double)22598.08, (double)bbox.getMiny(), (double)0.01);
        JSONObject serviceObj = TilingServiceHelper.toJSONObject((TileService)((TileService)result), (boolean)false, null, (boolean)false, (boolean)false, (EntityManager)this.entityManager);
        Assertions.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assertions.assertEquals((int)1, (int)matrixSets.length());
        JSONObject matrix = matrixSets.getJSONObject(0);
        JSONArray matrices = matrix.getJSONArray("matrices");
        Assertions.assertEquals((int)16, (int)matrices.length());
        Assertions.assertTrue((boolean)serviceObj.has("layers"));
        JSONObject layers = serviceObj.getJSONObject("layers");
        JSONObject jsonLayer = layers.getJSONObject("actueel_winter");
        Assertions.assertNotNull((Object)jsonLayer);
        Assertions.assertTrue((boolean)jsonLayer.has("bbox"));
    }

    private void compareWMTS(GeoService result) {
        Assertions.assertEquals((Object)"tiled", (Object)result.getProtocol());
        Assertions.assertEquals((Object)"http://localhost:8084/geoserver/gwc/service/wmts?", (Object)result.getUrl());
        TileService ts = (TileService)result;
        Assertions.assertEquals((Object)"Web Map Tile Service - GeoWebCache", (Object)ts.getName());
        Assertions.assertEquals((Object)"WMTS", (Object)ts.getTilingProtocol());
        Layer l = ts.getTilingLayer();
        Assertions.assertEquals((Object)"image/png", (Object)((ClobElement)l.getDetails().get("image_extension")).getValue());
        Layer topLayer = ts.getTopLayer();
        Assertions.assertEquals((int)1, (int)topLayer.getChildren().size());
        Layer layer = (Layer)topLayer.getChildren().get(0);
        Assertions.assertEquals((Object)"test:gemeente", (Object)layer.getName());
        Assertions.assertEquals((Object)"gem_2014_new", (Object)layer.getTitle());
        JSONArray styles = new JSONArray(((ClobElement)layer.getDetails().get("wms.styles")).getValue());
        JSONObject style = (JSONObject)styles.get(0);
        Assertions.assertEquals((Object)"", (Object)style.getString("identifier"));
        Assertions.assertNotNull((Object)ts.getMatrixSets());
        Assertions.assertEquals((int)6, (int)ts.getMatrixSets().size());
        Assertions.assertEquals((int)16, (int)((TileMatrixSet)ts.getMatrixSets().get(1)).getMatrices().size());
        Assertions.assertEquals((Object)"epsg:28992", (Object)((TileMatrixSet)layer.getMatrixSets().get(0)).getIdentifier());
        Assertions.assertEquals((int)16, (int)((TileMatrixSet)layer.getMatrixSets().get(0)).getMatrices().size());
        JSONObject serviceObj = TilingServiceHelper.toJSONObject((TileService)ts, (boolean)false, null, (boolean)false, (boolean)false, (EntityManager)this.entityManager);
        Assertions.assertTrue((boolean)serviceObj.has("matrixSets"));
        JSONArray matrixSets = serviceObj.getJSONArray("matrixSets");
        Assertions.assertEquals((int)6, (int)matrixSets.length());
        JSONObject matrix = matrixSets.getJSONObject(1);
        JSONArray matrices = matrix.getJSONArray("matrices");
        Assertions.assertEquals((int)16, (int)matrices.length());
        Assertions.assertTrue((boolean)serviceObj.has("layers"));
        JSONObject layers = serviceObj.getJSONObject("layers");
        JSONObject jsonLayer = layers.getJSONObject("test:gemeente");
        Assertions.assertNotNull((Object)jsonLayer);
        Assertions.assertFalse((boolean)jsonLayer.has("bbox"));
    }

    @Test
    public void testParseMultipleTileMatrixSets() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        URL u = TileServiceTest.class.getResource("singleLayer.xml");
        assert (u != null);
        String url = u.toString();
        Document doc = this.builder.parse(url);
        List sets = TilingServiceHelper.parseMatrixSets((XPath)this.xpath, (Document)doc);
        Assertions.assertNotNull((Object)sets);
        Assertions.assertEquals((int)6, (int)sets.size());
    }

    @Test
    public void testParseTileMatrixSet() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        URL u = TileServiceTest.class.getResource("tilematrixset.xml");
        assert (u != null);
        String url = u.toString();
        Document doc = this.builder.parse(url);
        TileMatrixSet tms = TilingServiceHelper.parseTileMatrixSet((XPath)this.xpath, (Node)doc.getChildNodes().item(0));
        Assertions.assertNotNull((Object)tms);
        Assertions.assertEquals((Object)"GlobalCRS84Pixel", (Object)tms.getIdentifier());
        Assertions.assertEquals((Object)"urn:ogc:def:crs:EPSG::4326", (Object)tms.getCrs());
        Assertions.assertNotNull((Object)tms.getBbox());
        Assertions.assertEquals((Object)"urn:ogc:def:crs:EPSG::4326", (Object)tms.getBbox().getCrs().getName());
        Assertions.assertEquals((double)-180.0, (double)tms.getBbox().getMaxy(), (double)0.01);
        Assertions.assertEquals((double)90.0, (double)tms.getBbox().getMinx(), (double)0.01);
        Assertions.assertEquals((double)-2.003768834E7, (double)tms.getBbox().getMiny(), (double)0.01);
        Assertions.assertEquals((double)4.007510668E7, (double)tms.getBbox().getMaxx(), (double)0.01);
        List matrices = tms.getMatrices();
        Assertions.assertNotNull((Object)matrices);
        Assertions.assertEquals((int)18, (int)matrices.size());
        TileMatrix first = (TileMatrix)matrices.get(0);
        Assertions.assertNotNull((Object)first);
        Assertions.assertEquals((Object)"GlobalCRS84Pixel:0", (Object)first.getIdentifier());
        Assertions.assertEquals((Object)"7.951392199519542E8", (Object)first.getScaleDenominator());
        Assertions.assertEquals((Object)"90.0 -180.0", (Object)first.getTopLeftCorner());
        Assertions.assertEquals((int)256, (int)first.getTileHeight());
        Assertions.assertEquals((int)256, (int)first.getTileWidth());
        Assertions.assertEquals((int)1, (int)first.getMatrixHeight());
        Assertions.assertEquals((int)1, (int)first.getMatrixWidth());
        Assertions.assertEquals((Object)"", (Object)first.getTitle());
        Assertions.assertEquals((Object)"", (Object)first.getDescription());
    }
}

