/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.util.databaseupdate;

import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.NoResultException;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.ConfiguredAttribute;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.app.StartLayer;
import nl.tailormap.viewer.config.app.StartLevel;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.helpers.app.ApplicationHelper;
import nl.tailormap.viewer.util.SelectedContentCache;
import nl.tailormap.viewer.util.databaseupdate.DatabaseSynchronizer;
import nl.tailormap.viewer.util.databaseupdate.DatabaseSynchronizerEM;
import nl.tailormap.viewer.util.databaseupdate.DatabaseSynchronizerTestInterface;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class DatabaseSynchronizerEMTest
extends DatabaseSynchronizerTestInterface {
    private static final boolean setupIsDone = false;
    static DatabaseSynchronizer ds;
    private final Long levelId = 5L;

    @Test
    public void convertTestStartLevels() throws URISyntaxException, IOException, SQLException {
        List sls = this.entityManager.createQuery("FROM StartLevel", StartLevel.class).getResultList();
        Assertions.assertEquals((int)6, (int)sls.size());
    }

    @Test
    public void convertTestStartLayers() {
        List startLayers = this.entityManager.createQuery("FROM StartLayer", StartLayer.class).getResultList();
        Assertions.assertEquals((int)5, (int)startLayers.size());
    }

    @Test
    public void convertTestStartLevel() {
        Level level = (Level)this.entityManager.find(Level.class, (Object)this.levelId);
        Application app = (Application)this.entityManager.find(Application.class, (Object)this.applicationId);
        Assertions.assertNotNull((Object)level);
        StartLevel sl = null;
        try {
            sl = (StartLevel)this.entityManager.createQuery("FROM StartLevel where level = :level", StartLevel.class).setParameter("level", (Object)level).getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        Assertions.assertNotNull(sl, (String)"StartLevel not found: conversion not correct");
        Assertions.assertEquals((Integer)1, (Integer)sl.getSelectedIndex());
        Assertions.assertEquals((Object)level, (Object)sl.getLevel());
        Assertions.assertEquals((Object)app, (Object)sl.getApplication());
    }

    @Test
    public void applicationDeepCopyLevelTest() throws Exception {
        Application app = (Application)this.entityManager.find(Application.class, (Object)this.applicationId);
        Application.TreeCache tcOld = app.loadTreeCache(this.entityManager);
        List oldLevels = tcOld.getLevels();
        Long origRootId = app.getRoot().getId();
        Application copy = ApplicationHelper.deepCopy((Application)app);
        copy.setVersion("14");
        this.entityManager.detach((Object)app);
        this.entityManager.persist((Object)copy);
        Long copyRootId = copy.getRoot().getId();
        Application.TreeCache tcCopy = copy.loadTreeCache(this.entityManager);
        List levelsCopy = tcCopy.getLevels();
        Assertions.assertEquals((int)oldLevels.size(), (int)levelsCopy.size());
        for (Level level : levelsCopy) {
            Assertions.assertEquals((int)1, (int)level.getStartLevels().size());
            for (StartLevel startLevel : level.getStartLevels().values()) {
                Assertions.assertEquals((Object)copy, (Object)startLevel.getApplication());
            }
        }
    }

    @Test
    public void applicationDeepCopyAppLayerTest() throws Exception {
        Application app = (Application)this.entityManager.find(Application.class, (Object)this.applicationId);
        Application.TreeCache tcOld = app.loadTreeCache(this.entityManager);
        List oldAppLayers = tcOld.getApplicationLayers();
        Application copy = ApplicationHelper.deepCopy((Application)app);
        copy.setVersion("14");
        this.entityManager.detach((Object)app);
        this.entityManager.persist((Object)copy);
        Application.TreeCache tcCopy = copy.loadTreeCache(this.entityManager);
        List appLayers = tcCopy.getApplicationLayers();
        Assertions.assertEquals((int)oldAppLayers.size(), (int)appLayers.size());
        for (ApplicationLayer appLayer : appLayers) {
            Assertions.assertEquals((int)1, (int)appLayer.getStartLayers().size());
        }
    }

    @Test
    public void testSelectedContentGeneration() throws SQLException, IOException, URISyntaxException, JSONException {
        String expectedString = "{\"rootLevel\":\"2\",\"selectedContent\":[{\"id\":\"3\",\"type\":\"level\"},{\"id\":\"5\",\"type\":\"level\"},{\"id\":\"6\",\"type\":\"level\"}],\"appLayers\":{\"1\":{\"background\":true,\"editAuthorizations\":{},\"authorizations\":{},\"checked\":true,\"alias\":\"Openbasiskaart\",\"id\":1,\"layerName\":\"Openbasiskaart\",\"serviceId\":1},\"2\":{\"background\":false,\"editAuthorizations\":{},\"featureType\":2,\"authorizations\":{},\"checked\":false,\"alias\":\"begroeid_terreinvakonderdeel_bestaand\",\"id\":2,\"layerName\":\"begroeid_terreinvakonderdeel_bestaand\",\"serviceId\":2},\"3\":{\"background\":false,\"editAuthorizations\":{},\"featureType\":5,\"authorizations\":{},\"checked\":false,\"alias\":\"begroeid_terreindeel\",\"id\":3,\"layerName\":\"begroeid_terreindeel\",\"serviceId\":2},\"4\":{\"background\":false,\"editAuthorizations\":{},\"featureType\":1,\"authorizations\":{},\"checked\":false,\"alias\":\"begroeid_terreinvakonderdeel\",\"id\":4,\"layerName\":\"begroeid_terreinvakonderdeel\",\"serviceId\":2},\"5\":{\"background\":false,\"editAuthorizations\":{},\"featureType\":6,\"authorizations\":{},\"checked\":false,\"alias\":\"woonplaats\",\"id\":5,\"layerName\":\"woonplaats\",\"serviceId\":3}},\"services\":{\"1\":{\"protocol\":\"tiled\",\"name\":\"Openbasiskaart\",\"styleLibraries\":{},\"layers\":{\"Openbasiskaart\":{\"filterable\":false,\"virtual\":false,\"bbox\":{\"miny\":22598,\"crs\":\"28992\",\"minx\":-285401,\"maxy\":903401,\"maxx\":595401},\"hasFeatureType\":false,\"authorizations\":{},\"resolutions\":\"3440.64,1720.32,860.16,430.08,215.04,107.52,53.76,26.88,13.44,6.72,3.36,1.68,0.84,0.42,0.21,0.105\",\"tileWidth\":256,\"title\":\"Openbasiskaart\",\"queryable\":false,\"name\":\"Openbasiskaart\",\"details\":{\"image_extension\":\"png\"},\"id\":2,\"serviceId\":1,\"tileHeight\":256}},\"id\":1,\"useProxy\":false,\"tilingProtocol\":\"TMS\",\"url\":\"http://www.openbasiskaart.nl/mapcache/tms/1.0.0/osm-nb@rd\"},\"2\":{\"protocol\":\"wms\",\"name\":\"Groen\",\"exception_type\":\"application/vnd.ogc.se_inimage\",\"styleLibraries\":{},\"layers\":{\"begroeid_terreinvakonderdeel\":{\"filterable\":false,\"virtual\":false,\"hasFeatureType\":true,\"authorizations\":{},\"featureTypeName\":\"begroeid_terreinvakonderdeel\",\"title\":\"begroeid_terreinvakonderdeel\",\"queryable\":true,\"name\":\"begroeid_terreinvakonderdeel\",\"details\":{\"wms.styles\":\"[{\\\"name\\\":\\\"default\\\",\\\"legendURLs\\\":[\\\"http://x12.b3p.nl/cgi-bin/mapserv?map=/srv/maps/solparc/groen_productie.map&version=1.1.1&service=WMS&request=GetLegendGraphic&layer=begroeid_terreinvakonderdeel&format=image/png&STYLE=default\\\"],\\\"title\\\":\\\"default\\\"}]\"},\"id\":5,\"featureTypeId\":1,\"serviceId\":2,\"legendImageUrl\":\"http://x12.b3p.nl/cgi-bin/mapserv?map=/srv/maps/solparc/groen_productie.map&version=1.1.1&service=WMS&request=GetLegendGraphic&layer=begroeid_terreinvakonderdeel&format=image/png&STYLE=default\"},\"begroeid_terreinvakonderdeel_bestaand\":{\"filterable\":false,\"virtual\":false,\"hasFeatureType\":true,\"authorizations\":{},\"featureTypeName\":\"begroeid_terreinvakonderdeel_bestaand\",\"title\":\"begroeid_terreinvakonderdeel_bestaand\",\"queryable\":true,\"name\":\"begroeid_terreinvakonderdeel_bestaand\",\"details\":{\"wms.styles\":\"[{\\\"name\\\":\\\"default\\\",\\\"legendURLs\\\":[\\\"http://x12.b3p.nl/cgi-bin/mapserv?map=/srv/maps/solparc/groen_productie.map&version=1.1.1&service=WMS&request=GetLegendGraphic&layer=begroeid_terreinvakonderdeel_bestaand&format=image/png&STYLE=default\\\"],\\\"title\\\":\\\"default\\\"}]\"},\"id\":6,\"featureTypeId\":2,\"serviceId\":2,\"legendImageUrl\":\"http://x12.b3p.nl/cgi-bin/mapserv?map=/srv/maps/solparc/groen_productie.map&version=1.1.1&service=WMS&request=GetLegendGraphic&layer=begroeid_terreinvakonderdeel_bestaand&format=image/png&STYLE=default\"},\"begroeid_terreindeel\":{\"filterable\":false,\"virtual\":false,\"hasFeatureType\":true,\"authorizations\":{},\"featureTypeName\":\"begroeid_terreindeel\",\"title\":\"begroeid_terreindeel\",\"queryable\":true,\"name\":\"begroeid_terreindeel\",\"details\":{\"wms.styles\":\"[{\\\"name\\\":\\\"default\\\",\\\"legendURLs\\\":[\\\"http://x12.b3p.nl/cgi-bin/mapserv?map=/srv/maps/solparc/groen_productie.map&version=1.1.1&service=WMS&request=GetLegendGraphic&layer=begroeid_terreindeel&format=image/png&STYLE=default\\\"],\\\"title\\\":\\\"default\\\"}]\"},\"id\":4,\"featureTypeId\":5,\"serviceId\":2,\"legendImageUrl\":\"http://x12.b3p.nl/cgi-bin/mapserv?map=/srv/maps/solparc/groen_productie.map&version=1.1.1&service=WMS&request=GetLegendGraphic&layer=begroeid_terreindeel&format=image/png&STYLE=default\"}},\"id\":2,\"useProxy\":false,\"url\":\"http://x12.b3p.nl/cgi-bin/mapserv?map=/srv/maps/solparc/groen_productie.map&\",\"mustLogin\":true},\"3\":{\"protocol\":\"wms\",\"name\":\"woonplaatsen\",\"exception_type\":\"application/vnd.ogc.se_inimage\",\"styleLibraries\":{},\"layers\":{\"woonplaats\":{\"filterable\":false,\"virtual\":false,\"hasFeatureType\":true,\"authorizations\":{},\"featureTypeName\":\"woonplaats\",\"title\":\"woonplaats\",\"queryable\":true,\"name\":\"woonplaats\",\"details\":{\"wms.styles\":\"[{\\\"name\\\":\\\"default\\\",\\\"legendURLs\\\":[\\\"http://x12.b3p.nl/cgi-bin/mapserv?map=/srv/maps/solparc/woonplaats_productie.map&version=1.1.1&service=WMS&request=GetLegendGraphic&layer=woonplaats&format=image/png&STYLE=default\\\"],\\\"title\\\":\\\"default\\\"}]\"},\"id\":10,\"featureTypeId\":6,\"serviceId\":3,\"legendImageUrl\":\"http://x12.b3p.nl/cgi-bin/mapserv?map=/srv/maps/solparc/woonplaats_productie.map&version=1.1.1&service=WMS&request=GetLegendGraphic&layer=woonplaats&format=image/png&STYLE=default\"}},\"id\":3,\"useProxy\":false,\"url\":\"http://x12.b3p.nl/cgi-bin/mapserv?map=/srv/maps/solparc/woonplaats_productie.map&\",\"mustLogin\":true}},\"levels\":{\"1\":{\"children\":[{\"authorizations\":{},\"child\":\"3\"}],\"background\":true,\"name\":\"Achtergrond\",\"authorizations\":{},\"id\":1},\"2\":{\"children\":[{\"authorizations\":{},\"child\":\"1\"},{\"authorizations\":{},\"child\":\"4\"}],\"background\":false,\"name\":\"Applicatie\",\"authorizations\":{},\"id\":2},\"3\":{\"background\":true,\"name\":\"OSM\",\"layers\":[\"1\"],\"authorizations\":{},\"id\":3},\"4\":{\"children\":[{\"authorizations\":{},\"child\":\"5\"},{\"authorizations\":{},\"child\":\"6\"}],\"background\":false,\"name\":\"Thema\",\"authorizations\":{},\"id\":4},\"5\":{\"background\":false,\"name\":\"Groen\",\"layers\":[\"2\",\"3\",\"4\"],\"authorizations\":{},\"id\":5},\"6\":{\"background\":false,\"name\":\"Woonplaatsen\",\"layers\":[\"5\"],\"authorizations\":{},\"id\":6}}}";
        Application app = (Application)this.entityManager.find(Application.class, (Object)this.applicationId);
        app.loadTreeCache(this.entityManager);
        Assertions.assertEquals((int)6, (int)app.getTreeCache().getLevels().size());
        Assertions.assertEquals((int)5, (int)app.getTreeCache().getApplicationLayers().size());
        SelectedContentCache scc = new SelectedContentCache();
        JSONObject actual = scc.createSelectedContent(app, false, false, false, this.entityManager);
        JSONObject expected = new JSONObject(expectedString);
        JSONAssert.assertEquals((JSONArray)expected.getJSONArray("selectedContent"), (JSONArray)actual.getJSONArray("selectedContent"), (JSONCompareMode)JSONCompareMode.STRICT_ORDER);
        Assertions.assertEquals((Object)expected.getString("rootLevel"), (Object)actual.getString("rootLevel"));
        JSONAssert.assertEquals((JSONObject)expected.getJSONObject("appLayers"), (JSONObject)actual.getJSONObject("appLayers"), (JSONCompareMode)JSONCompareMode.LENIENT);
        JSONAssert.assertEquals((JSONObject)expected.getJSONObject("services"), (JSONObject)actual.getJSONObject("services"), (JSONCompareMode)JSONCompareMode.LENIENT);
        JSONAssert.assertEquals((JSONObject)expected.getJSONObject("levels"), (JSONObject)actual.getJSONObject("levels"), (JSONCompareMode)JSONCompareMode.LENIENT);
        Assertions.assertEquals((int)6, (int)this.entityManager.createQuery("FROM Level").getResultList().size());
    }

    @Test
    public void testUpdateApplicationLayerAttributesOrder() {
        DatabaseSynchronizerEM instance = new DatabaseSynchronizerEM();
        instance.updateApplicationLayersAttributesOrder(this.entityManager);
        List appLayers = this.entityManager.createQuery("From ApplicationLayer").getResultList();
        for (ApplicationLayer appLayer : appLayers) {
            List attrs = appLayer.getAttributes();
            if (this.areInCorrectOrder(attrs)) continue;
            Assertions.fail((String)("Attributes of " + appLayer.getLayerName() + " not in correct order (should be alphabetically"));
        }
    }

    @Test
    public void testUpdateAttributeOrder() {
        DatabaseSynchronizerEM instance = new DatabaseSynchronizerEM();
        instance.updateApplicationLayersAttributesOrder(this.entityManager);
        ApplicationLayer applicationLayer = (ApplicationLayer)this.entityManager.find(ApplicationLayer.class, (Object)2L);
        Layer layer = applicationLayer.getService().getSingleLayer(applicationLayer.getLayerName(), this.entityManager);
        instance.updateAttributeOrder(applicationLayer, layer.getFeatureType(), this.entityManager);
        List attrs = applicationLayer.getAttributes();
        if (!this.areInCorrectOrder(attrs)) {
            Assertions.fail((String)"Attributes not in correct order (should be alphabetically");
        }
    }

    private boolean areInCorrectOrder(List<ConfiguredAttribute> attrs) {
        String prevNaam = null;
        for (ConfiguredAttribute attr : attrs) {
            if (prevNaam != null && attr.getAttributeName().compareTo(prevNaam) < 1) {
                return false;
            }
            prevNaam = attr.getAttributeName();
        }
        return true;
    }
}

