/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.ConfiguredComponent;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.security.Authorizations;
import nl.tailormap.viewer.config.services.Layer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class AuthorizationsHelper {
    public static final Set<String> NOBODY = new HashSet<String>(Arrays.asList(new String[]{null}));
    public static final Set<String> EVERYBODY = Collections.emptySet();
    public static final Map<Long, GeoServiceCache> serviceCache = new HashMap<Long, GeoServiceCache>();
    private static final Log log = LogFactory.getLog(AuthorizationsHelper.class);
    private static final Object LOCK = new Object();
    private static final String ROLES_ATTRIBUTE = Authorizations.class.getName() + ".roles";
    private static final Map<Long, ApplicationCache> applicationCache = new HashMap<Long, ApplicationCache>();
    private static final Map<Long, AppConfiguredComponentsReadersCache> appConfiguredComponentsReadersCache = new HashMap<Long, AppConfiguredComponentsReadersCache>();
    private static final String REQUEST_APP_CACHE = Authorizations.class.getName() + ".REQUEST_APP_CACHE";

    public static void checkConfiguredComponentAuthorized(ConfiguredComponent component, HttpServletRequest request, EntityManager em) throws Exception {
        if (!AuthorizationsHelper.isReadAuthorized(AuthorizationsHelper.getRoles(request, em), new Read(component.getReaders()))) {
            throw new Exception((String)("User " + request.getRemoteUser() == null ? "(none)" : request.getRemoteUser() + " not authorized to edit ") + " configured component #" + component.getName() + " of app #" + component.getApplication().getId());
        }
    }

    public static boolean isLevelReadAuthorized(Application app, Level l, HttpServletRequest request, EntityManager em) {
        return AuthorizationsHelper.isLevelReadAuthorized(app, l, request, AuthorizationsHelper.getApplicationCacheFromRequest(app, request, em), em);
    }

    public static boolean isLevelReadAuthorized(Application app, Level l, HttpServletRequest request, ApplicationCache appCache, EntityManager em) {
        if (app.isAuthenticatedRequired() && request.getRemoteUser() == null) {
            return false;
        }
        if (appCache == null) {
            appCache = AuthorizationsHelper.getApplicationCache(app, em);
        }
        Read auths = appCache.protectedLevels.get(l.getId());
        return AuthorizationsHelper.isReadAuthorized(AuthorizationsHelper.getRoles(request, em), auths);
    }

    public static Set<String> getRoles(HttpServletRequest request, EntityManager em) {
        if (request.getRemoteUser() == null) {
            return Collections.emptySet();
        }
        HashSet<String> roles = (HashSet<String>)request.getAttribute(ROLES_ATTRIBUTE);
        if (roles == null) {
            roles = new HashSet<String>();
            List groups = em.createQuery("select name FROM Group").getResultList();
            for (String group : groups) {
                if (!request.isUserInRole(group)) continue;
                roles.add(group);
            }
            request.setAttribute(ROLES_ATTRIBUTE, roles);
        }
        return roles;
    }

    public static boolean isReadAuthorized(Set<String> roles, Read auths) {
        if (auths == null || auths.readers.equals(EVERYBODY)) {
            return true;
        }
        if (auths.readers.equals(NOBODY)) {
            return false;
        }
        if (roles.isEmpty()) {
            return false;
        }
        return !Collections.disjoint(auths.readers, roles);
    }

    public static boolean isWriteAuthorized(Set<String> roles, ReadWrite auths, EntityManager em) {
        if (!AuthorizationsHelper.isReadAuthorized(roles, auths)) {
            return false;
        }
        if (auths == null || auths.writers.equals(EVERYBODY)) {
            return true;
        }
        if (auths.writers.equals(NOBODY)) {
            return false;
        }
        if (roles.isEmpty()) {
            return false;
        }
        return !Collections.disjoint(auths.writers, roles);
    }

    public static ApplicationCache getApplicationCacheFromRequest(Application app, HttpServletRequest request, EntityManager em) {
        ApplicationCache appCache;
        HashMap<Long, ApplicationCache> requestCache = (HashMap<Long, ApplicationCache>)request.getAttribute(REQUEST_APP_CACHE);
        if (requestCache == null) {
            requestCache = new HashMap<Long, ApplicationCache>();
            request.setAttribute(REQUEST_APP_CACHE, requestCache);
        }
        if ((appCache = (ApplicationCache)requestCache.get(app.getId())) == null) {
            appCache = AuthorizationsHelper.getApplicationCache(app, em);
            requestCache.put(app.getId(), appCache);
        }
        return appCache;
    }

    public static boolean isAppLayerReadAuthorized(Application app, ApplicationLayer al, HttpServletRequest request, EntityManager em) {
        return AuthorizationsHelper.isAppLayerReadAuthorized(app, al, request, AuthorizationsHelper.getApplicationCacheFromRequest(app, request, em), em);
    }

    @Deprecated(since="5.9.9")
    public static boolean isAppLayerReadAuthorized(Application app, ApplicationLayer al, HttpServletRequest request, ApplicationCache appCache, EntityManager em) {
        return AuthorizationsHelper.isAppLayerReadAuthorized(app, al, AuthorizationsHelper.getRoles(request, em), appCache, em);
    }

    public static boolean isAppLayerReadAuthorized(Application app, ApplicationLayer al, Set<String> roles, ApplicationCache appCache, EntityManager em) {
        if (app == null || app.isAuthenticatedRequired() && (roles == null || roles.isEmpty())) {
            return false;
        }
        if (appCache == null) {
            appCache = AuthorizationsHelper.getApplicationCache(app, em);
        }
        ReadWrite auths = appCache.protectedAppLayers.get(al.getId());
        return AuthorizationsHelper.isReadAuthorized(roles, auths);
    }

    public static boolean isAppLayerWriteAuthorized(Application app, ApplicationLayer al, HttpServletRequest request, EntityManager em) {
        return AuthorizationsHelper.isAppLayerWriteAuthorized(app, al, request, AuthorizationsHelper.getApplicationCacheFromRequest(app, request, em), em);
    }

    public static boolean isAppLayerWriteAuthorized(Application app, ApplicationLayer al, HttpServletRequest request, ApplicationCache appCache, EntityManager em) {
        if (app == null || app.isAuthenticatedRequired() && request.getRemoteUser() == null) {
            return false;
        }
        if (appCache == null) {
            appCache = AuthorizationsHelper.getApplicationCache(app, em);
        }
        ReadWrite auths = appCache.protectedAppLayers.get(al.getId());
        return AuthorizationsHelper.isWriteAuthorized(AuthorizationsHelper.getRoles(request, em), auths, em);
    }

    @Deprecated(forRemoval=true, since="5.9.9")
    public static boolean isConfiguredComponentAuthorized(ConfiguredComponent component, HttpServletRequest request, EntityManager em) {
        return AuthorizationsHelper.isConfiguredComponentAuthorized(component, AuthorizationsHelper.getRoles(request, em), em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConfiguredComponentAuthorized(ConfiguredComponent component, Set<String> userRoles, EntityManager em) {
        Set<String> componentReaders;
        Application app = component.getApplication();
        Long appId = app.getId();
        Map<Long, AppConfiguredComponentsReadersCache> map = appConfiguredComponentsReadersCache;
        synchronized (map) {
            AppConfiguredComponentsReadersCache appCache = appConfiguredComponentsReadersCache.get(appId);
            if (appCache == null || appCache.modified.before(app.getAuthorizationsModified())) {
                appCache = new AppConfiguredComponentsReadersCache();
                appConfiguredComponentsReadersCache.put(appId, appCache);
                appCache.modified = component.getApplication().getAuthorizationsModified();
                appCache.readersByConfiguredComponentId = new HashMap<Long, Set<String>>();
                List readers = em.createQuery("select cc.id, r from ConfiguredComponent cc join cc.readers r where cc.application = :app").setParameter("app", (Object)component.getApplication()).getResultList();
                for (Object[] row : readers) {
                    Long ccId = (Long)row[0];
                    String role = (String)row[1];
                    Set roles = appCache.readersByConfiguredComponentId.computeIfAbsent(ccId, k -> new HashSet());
                    roles.add(role);
                }
            }
            componentReaders = appCache.readersByConfiguredComponentId.get(component.getId());
        }
        if (componentReaders == null) {
            componentReaders = EVERYBODY;
        }
        return AuthorizationsHelper.isReadAuthorized(userRoles, new Read(componentReaders));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadWrite getLayerAuthorizations(Layer l, EntityManager em) {
        Object object = LOCK;
        synchronized (object) {
            GeoServiceCache cache = serviceCache.get(l.getService().getId());
            if (cache != null && cache.modified.equals(l.getService().getAuthorizationsModified())) {
                return cache.protectedLayers.get(l.getId());
            }
            cache = new GeoServiceCache();
            serviceCache.put(l.getService().getId(), cache);
            cache.modified = l.getService().getAuthorizationsModified();
            cache.protectedLayers = new HashMap<Long, ReadWrite>();
            List layers = l.getService().loadLayerTree(em);
            if (!layers.isEmpty()) {
                List subList;
                int i = 0;
                do {
                    subList = layers.subList(i, Math.min(layers.size(), i + 500));
                    em.createQuery("from Layer l left join fetch l.readers left join fetch l.writers where l in (:layers)").setParameter("layers", subList).getResultList();
                } while ((i += subList.size()) < layers.size());
            }
            AuthorizationsHelper.walkLayer(l.getService().getTopLayer(), EVERYBODY, EVERYBODY, cache.protectedLayers, em);
            return cache.protectedLayers.get(l.getId());
        }
    }

    private static Set<String> inheritAuthorizations(Set<String> current, Set<String> _new) {
        if (_new.equals(EVERYBODY)) {
            return current;
        }
        if (current.equals(EVERYBODY)) {
            return new HashSet<String>(_new);
        }
        HashSet<String> copy = new HashSet<String>(current);
        copy.retainAll(_new);
        if (copy.isEmpty()) {
            return NOBODY;
        }
        return copy;
    }

    private static void walkLayer(Layer l, Set<String> currentReaders, Set<String> currentWriters, Map<Long, ReadWrite> serviceProtectedLayers, EntityManager em) {
        currentReaders = AuthorizationsHelper.inheritAuthorizations(currentReaders, l.getReaders());
        currentWriters = AuthorizationsHelper.inheritAuthorizations(currentWriters, l.getWriters());
        if (!currentReaders.equals(EVERYBODY) || !currentWriters.equals(EVERYBODY)) {
            serviceProtectedLayers.put(l.getId(), new ReadWrite(currentReaders, currentWriters));
        }
        for (Layer child : l.getCachedChildren(em)) {
            AuthorizationsHelper.walkLayer(child, currentReaders, currentWriters, serviceProtectedLayers, em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationCache getApplicationCache(Application app, EntityManager em) {
        Object object = LOCK;
        synchronized (object) {
            ApplicationCache cache = applicationCache.get(app.getId());
            Date allServicesAuthLastChanged = null;
            if (cache != null && !cache.modified.before(app.getAuthorizationsModified())) {
                try {
                    allServicesAuthLastChanged = (Date)em.createQuery("select max(authorizationsModified) from GeoService").getSingleResult();
                    if (allServicesAuthLastChanged != null && !cache.modified.before(allServicesAuthLastChanged)) {
                        return cache;
                    }
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
            }
            cache = new ApplicationCache();
            applicationCache.put(app.getId(), cache);
            cache.modified = allServicesAuthLastChanged != null ? (allServicesAuthLastChanged.after(app.getAuthorizationsModified()) ? allServicesAuthLastChanged : app.getAuthorizationsModified()) : app.getAuthorizationsModified();
            cache.protectedLevels = new HashMap<Long, Read>();
            cache.protectedAppLayers = new HashMap<Long, ReadWrite>();
            Application.TreeCache treeCache = app.loadTreeCache(em);
            treeCache.initializeLevels("left join fetch l.readers", em);
            treeCache.initializeApplicationLayers("left join fetch al.readers left join fetch al.writers", em);
            AuthorizationsHelper.walkLevel(app.getRoot(), EVERYBODY, cache, treeCache, em);
            return cache;
        }
    }

    private static void walkLevel(Level l, Set<String> currentReaders, ApplicationCache cache, Application.TreeCache treeCache, EntityManager em) {
        if (!(currentReaders = AuthorizationsHelper.inheritAuthorizations(currentReaders, l.getReaders())).equals(EVERYBODY)) {
            cache.protectedLevels.put(l.getId(), new Read(currentReaders));
        }
        for (ApplicationLayer al : l.getLayers()) {
            if (al == null) continue;
            AuthorizationsHelper.walkAppLayer(al, currentReaders, cache, em);
        }
        for (Level child : treeCache.getChildren(l)) {
            AuthorizationsHelper.walkLevel(child, currentReaders, cache, treeCache, em);
        }
    }

    private static void walkAppLayer(ApplicationLayer al, Set<String> currentReaders, ApplicationCache cache, EntityManager em) {
        ReadWrite layerAuth;
        currentReaders = AuthorizationsHelper.inheritAuthorizations(currentReaders, al.getReaders());
        Layer l = al.getService().getLayer(al.getLayerName(), em);
        Set<String> currentWriters = al.getWriters();
        if (l != null && (layerAuth = AuthorizationsHelper.getLayerAuthorizations(l, em)) != null) {
            currentReaders = AuthorizationsHelper.inheritAuthorizations(currentReaders, layerAuth.readers);
            currentWriters = AuthorizationsHelper.inheritAuthorizations(currentWriters, layerAuth.writers);
        }
        if (!currentReaders.equals(EVERYBODY) || !currentWriters.equals(EVERYBODY)) {
            cache.protectedAppLayers.put(al.getId(), new ReadWrite(currentReaders, currentWriters));
        }
    }

    public static boolean isLayerReadAuthorized(Layer l, HttpServletRequest request, EntityManager em) {
        return AuthorizationsHelper.isReadAuthorized(AuthorizationsHelper.getRoles(request, em), AuthorizationsHelper.getLayerAuthorizations(l, em));
    }

    public static boolean isLayerWriteAuthorized(Layer l, HttpServletRequest request, EntityManager em) {
        return AuthorizationsHelper.isWriteAuthorized(AuthorizationsHelper.getRoles(request, em), AuthorizationsHelper.getLayerAuthorizations(l, em), em);
    }

    public static boolean isLayerGeomWriteAuthorized(Layer l, HttpServletRequest request, EntityManager em) {
        if (AuthorizationsHelper.isLayerWriteAuthorized(l, request, em)) {
            Set preventEditGeomGroup = l.getPreventGeomEditors();
            for (String group : preventEditGeomGroup) {
                if (!request.isUserInRole(group)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isApplicationReadAuthorized(Application app, Set<String> roles, EntityManager em) {
        Read auths = new Read(app.getReaders());
        return AuthorizationsHelper.isReadAuthorized(roles, auths);
    }

    public static class ReadWrite
    extends Read {
        Set<String> writers;

        public ReadWrite(Set<String> readers, Set<String> writers) {
            super(readers);
            this.writers = writers;
        }

        public Set<String> getWriters() {
            return this.writers;
        }

        @Override
        public JSONObject toJSON() throws JSONException {
            JSONObject obj = new JSONObject();
            JSONArray jWriters = new JSONArray(this.writers);
            JSONArray jReaders = new JSONArray((Collection)this.readers);
            obj.put("readers", (Object)jReaders);
            obj.put("writers", (Object)jWriters);
            return obj;
        }
    }

    public static class Read {
        Set<String> readers;

        public Read(Set<String> readers) {
            this.readers = readers;
        }

        public Set<String> getReaders() {
            return this.readers;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject obj = new JSONObject();
            JSONArray jReaders = new JSONArray(this.readers);
            obj.put("readers", (Object)jReaders);
            return obj;
        }
    }

    public static class AppConfiguredComponentsReadersCache {
        Date modified;
        Map<Long, Set<String>> readersByConfiguredComponentId;
    }

    public static class ApplicationCache {
        Date modified;
        Map<Long, Read> protectedLevels;
        Map<Long, ReadWrite> protectedAppLayers;

        public Date getModified() {
            return this.modified;
        }

        public Map<Long, ReadWrite> getProtectedAppLayers() {
            return this.protectedAppLayers;
        }

        public Map<Long, Read> getProtectedLevels() {
            return this.protectedLevels;
        }
    }

    public static class GeoServiceCache {
        Date modified;
        Map<Long, ReadWrite> protectedLayers;

        public Map<Long, ReadWrite> getProtectedLayers() {
            return this.protectedLayers;
        }

        public Date getModified() {
            return this.modified;
        }
    }
}

