/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.app;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.Bookmark;
import nl.tailormap.viewer.config.app.ConfiguredComponent;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.app.StartLayer;
import nl.tailormap.viewer.config.app.StartLevel;
import nl.tailormap.viewer.helpers.AuthorizationsHelper;
import nl.tailormap.viewer.helpers.app.LevelHelper;
import nl.tailormap.viewer.util.SelectedContentCache;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ApplicationHelper {
    private static final Log log = LogFactory.getLog(ApplicationHelper.class);

    public static Application createWorkVersion(Application app, EntityManager em, String version, ActionBeanContext context) throws Exception {
        Application copy = ApplicationHelper.deepCopyAllButLevels(false, app);
        copy.setVersion(version);
        copy.setRoot(null);
        em.persist((Object)copy);
        em.getTransaction().commit();
        em.getTransaction().begin();
        copy.originalToCopy = new HashMap();
        if (app.getRoot() != null) {
            copy.setRoot(app.getRoot().deepCopy(null, copy.originalToCopy, copy, false));
            copy.originalToCopy = ApplicationHelper.reverse(copy.originalToCopy);
            copy.getRoot().processForWorkversion(copy, app);
        }
        Set<Application> apps = LevelHelper.findApplications(app.getRoot(), em);
        for (Application application : apps) {
            em.detach((Object)application);
        }
        em.persist((Object)copy);
        em.flush();
        Application prev = (Application)em.createQuery("FROM Application where id = :id", Application.class).setParameter("id", (Object)app.getId()).getSingleResult();
        ApplicationHelper.processBookmarks(copy, prev, context, em);
        SelectedContentCache.setApplicationCacheDirty(copy, Boolean.TRUE, false, em);
        em.getTransaction().commit();
        return copy;
    }

    public static Application deepCopy(Application app) throws Exception {
        Application copy = ApplicationHelper.deepCopyAllButLevels(false, app);
        copy.originalToCopy = new HashMap();
        if (app.getRoot() != null) {
            copy.setRoot(app.getRoot().deepCopy(null, copy.originalToCopy, copy, true));
        }
        return copy;
    }

    private static Map reverse(Map orig) {
        HashMap reverse = new HashMap();
        Set entries = orig.entrySet();
        for (Map.Entry entry : entries) {
            reverse.put(entry.getValue(), entry.getKey());
        }
        return reverse;
    }

    private static Application deepCopyAllButLevels(boolean linkComponents, Application app) throws Exception {
        Application copy = (Application)BeanUtils.cloneBean((Object)app);
        copy.setId(null);
        copy.setBookmarks(null);
        copy.setTreeCache(null);
        copy.setStartLayers(new ArrayList());
        copy.setStartLevels(new ArrayList());
        copy.setReaders(new HashSet());
        copy.setDetails(new HashMap(app.getDetails()));
        if (app.getStartExtent() != null) {
            copy.setStartExtent(app.getStartExtent().clone());
        }
        if (app.getMaxExtent() != null) {
            copy.setMaxExtent(app.getMaxExtent().clone());
        }
        copy.setComponents(new HashSet());
        for (ConfiguredComponent cc : app.getComponents()) {
            ConfiguredComponent componentCopy = cc.deepCopy(copy);
            copy.getComponents().add(componentCopy);
            if (!linkComponents) continue;
            componentCopy.setMotherComponent(cc);
            cc.getLinkedComponents().add(componentCopy);
        }
        for (String reader : app.getReaders()) {
            copy.getReaders().add(reader);
        }
        return copy;
    }

    public static Application createMashup(Application app, String mashupName, EntityManager em, boolean linkComponents) throws Exception {
        Application source = app;
        if (!em.contains((Object)source)) {
            source = (Application)em.merge((Object)source);
        }
        Application mashup = ApplicationHelper.deepCopyAllButLevels(linkComponents, source);
        mashup.setName(mashup.getName() + "_" + mashupName);
        em.persist((Object)mashup);
        if (mashup.getRoot() != null) {
            mashup.getRoot().processForMashup(mashup, source);
        }
        app.isMashup_cached = Boolean.TRUE;
        mashup.getDetails().put("isMashup", new ClobElement("" + app.isMashup_cached));
        return mashup;
    }

    public static List<Application> getMashups(Application app, EntityManager em) {
        return em.createQuery("from Application where root = :level and id <> :oldId").setParameter("level", (Object)app.getRoot()).setParameter("oldId", (Object)app.getId()).getResultList();
    }

    public static void processBookmarks(Application app, Application previousApplication, ActionBeanContext context, EntityManager em) {
        List bookmarkComponents = em.createQuery("FROM ConfiguredComponent where application.id = :app and className = :className", ConfiguredComponent.class).setParameter("app", (Object)previousApplication.getId()).setParameter("className", (Object)"viewer.components.Bookmark").getResultList();
        for (ConfiguredComponent comp : bookmarkComponents) {
            String config = comp.getConfig();
            if (config == null || config.isEmpty()) continue;
            try {
                JSONObject conf = new JSONObject(config);
                if (!conf.optBoolean("copyBookmarkForWorkversion", false)) continue;
                List bookmarks = em.createQuery("FROM Bookmark where application = :app", Bookmark.class).setParameter("app", (Object)previousApplication).getResultList();
                for (Bookmark bookmark : bookmarks) {
                    Bookmark clone = bookmark.clone();
                    clone.setCreatedBy(ApplicationHelper.createCreatedBy(context));
                    clone.setApplication(app);
                    ApplicationHelper.processBookmark(clone, app.idMap);
                    em.persist((Object)clone);
                    clone.setCode(bookmark.getCode());
                    em.persist((Object)clone);
                }
            }
            catch (JSONException ex) {
                log.error((Object)"Cannot convert bookmarks.", (Throwable)ex);
            }
        }
        previousApplication = null;
    }

    private static void processBookmark(Bookmark bookmark, Map<String, Long> idMap) throws JSONException {
        JSONObject bm = new JSONObject(bookmark.getParams());
        JSONArray params = bm.getJSONArray("params");
        JSONArray newParams = new JSONArray();
        for (int i = 0; i < params.length(); ++i) {
            Long newId;
            int j;
            JSONObject param = params.getJSONObject(i);
            JSONArray value = param.optJSONArray("value");
            if (param.getString("name").equals("layers")) {
                JSONArray newLayers = new JSONArray();
                for (j = 0; j < value.length(); ++j) {
                    int layerId = value.getInt(j);
                    newId = idMap.get(ApplicationLayer.class + "_" + layerId);
                    newLayers.put((Object)newId);
                }
                param.put("value", (Object)newLayers);
            } else if (param.getString("name").equals("levelOrder")) {
                JSONArray newLevels = new JSONArray();
                for (j = 0; j < value.length(); ++j) {
                    int levelId = value.getInt(j);
                    newId = idMap.get(Level.class + "_" + levelId);
                    newLevels.put((Object)newId);
                }
                param.put("value", (Object)newLevels);
            } else if (param.getString("name").equals("selectedContent")) {
                for (int j2 = 0; j2 < value.length(); ++j2) {
                    JSONObject content = value.getJSONObject(j2);
                    if (!content.optString("type", "level").equals("level")) continue;
                    Long newId2 = idMap.get(Level.class + "_" + content.getString("id"));
                    content.put("id", (Object)newId2);
                }
            }
            newParams.put((Object)param);
        }
        JSONObject newBm = new JSONObject();
        newBm.put("params", (Object)newParams);
        bookmark.setParams(newBm.toString());
    }

    public static String createCreatedBy(ActionBeanContext context) {
        String createdBy = "IP: " + context.getRequest().getRemoteAddr();
        if (context.getRequest().getHeader("x-forwarded-for") != null) {
            createdBy = "IP: " + context.getRequest().getHeader("x-forwarded-for") + "(proxy " + createdBy + ")";
        }
        if (context.getRequest().getRemoteUser() != null) {
            createdBy = createdBy + ", user: " + context.getRequest().getRemoteUser();
        }
        return createdBy;
    }

    public static void transferMashupLevels(Application app, Application old, EntityManager em) {
        app.originalToCopy = new HashMap();
        app.loadTreeCache(em);
        ApplicationHelper.visitLevelForMashuptransfer(app, old.getRoot(), app.originalToCopy);
        Map reverse = ApplicationHelper.reverse(app.originalToCopy);
        ArrayList<StartLayer> startlayersAdded = new ArrayList<StartLayer>();
        ArrayList<StartLevel> startlevelsAdded = new ArrayList<StartLevel>();
        ApplicationHelper.replaceLevel(app, app.getRoot(), reverse, startlayersAdded, startlevelsAdded);
        app.getStartLevels().retainAll(startlevelsAdded);
        app.getStartLayers().retainAll(app.getStartLayers());
        app.processCopyMap();
    }

    public static void transferMashupComponents(Application app, Application newApp) {
        for (ConfiguredComponent component : app.getComponents()) {
            if (component.getMotherComponent() == null) continue;
            for (ConfiguredComponent newAppComp : newApp.getComponents()) {
                if (!component.getName().equals(newAppComp.getName())) continue;
                component.setMotherComponent(newAppComp);
            }
        }
    }

    private static void replaceLevel(Application app, Level l, Map reverse, List<StartLayer> startlayersAdded, List<StartLevel> startlevelsAdded) {
        StartLevel sl;
        for (Level level : l.getChildren()) {
            ApplicationHelper.replaceLevel(app, level, reverse, startlayersAdded, startlevelsAdded);
        }
        for (ApplicationLayer layer : l.getLayers()) {
            ApplicationHelper.replaceLayer(app, layer, reverse, startlayersAdded);
        }
        Object o = reverse.get(l);
        if (o != null && (sl = (StartLevel)((Level)o).getStartLevels().get(app)) != null) {
            sl.setLevel(l);
            startlevelsAdded.add(sl);
        }
    }

    private static void replaceLayer(Application app, ApplicationLayer al, Map reverse, List<StartLayer> startlayersAdded) {
        StartLayer sl;
        Object o = reverse.get(al);
        if (o != null && (sl = (StartLayer)((ApplicationLayer)o).getStartLayers().get(app)) != null) {
            sl.setApplicationLayer(al);
            startlayersAdded.add(sl);
        }
    }

    private static void visitLevelForMashuptransfer(Application app, Level oldLevel, Map originalToCopy) {
        Level newLevel = app.findLevel(oldLevel);
        if (newLevel != null) {
            originalToCopy.put(oldLevel, newLevel);
        }
        for (ApplicationLayer oldLayer : oldLevel.getLayers()) {
            ApplicationLayer newLayer = app.findLayer(oldLayer);
            if (newLayer == null) continue;
            originalToCopy.put(oldLayer, newLayer);
        }
        for (Level oldChild : oldLevel.getChildren()) {
            ApplicationHelper.visitLevelForMashuptransfer(app, oldChild, originalToCopy);
        }
    }

    @Deprecated(since="5.9.x", forRemoval=true)
    public static JSONObject toJSON(Application app, HttpServletRequest request, boolean validXmlTags, boolean onlyServicesAndLayers, EntityManager em) throws JSONException {
        return ApplicationHelper.toJSON(app, request, validXmlTags, onlyServicesAndLayers, false, false, em, true);
    }

    @Deprecated(since="5.9.9", forRemoval=true)
    public static JSONObject toJSON(Application app, HttpServletRequest request, boolean validXmlTags, boolean onlyServicesAndLayers, EntityManager em, boolean hideAdminOnly) throws JSONException {
        return ApplicationHelper.toJSON(app, request, validXmlTags, onlyServicesAndLayers, false, false, em, true, hideAdminOnly);
    }

    @Deprecated(since="5.9.9", forRemoval=true)
    public static JSONObject toJSON(Application app, HttpServletRequest request, boolean validXmlTags, boolean onlyServicesAndLayers, boolean includeAppLayerAttributes, boolean includeRelations, EntityManager em, boolean shouldProcessCache) throws JSONException {
        return ApplicationHelper.toJSON(app, request, validXmlTags, onlyServicesAndLayers, includeAppLayerAttributes, includeRelations, em, shouldProcessCache, false);
    }

    @Deprecated(since="5.9.9", forRemoval=true)
    public static JSONObject toJSON(Application app, HttpServletRequest request, boolean validXmlTags, boolean onlyServicesAndLayers, boolean includeAppLayerAttributes, boolean includeRelations, EntityManager em, boolean shouldProcessCache, boolean hideAdminOnly) throws JSONException {
        return ApplicationHelper.toJSON(app, AuthorizationsHelper.getRoles(request, em), URI.create(request.getRequestURI()), request.getServletContext().getInitParameter("proxy"), validXmlTags, onlyServicesAndLayers, includeAppLayerAttributes, includeRelations, em, shouldProcessCache, hideAdminOnly);
    }

    public static JSONObject toJSON(Application app, Set<String> roles, URI requestURI, String proxyPath, boolean validXmlTags, boolean onlyServicesAndLayers, boolean includeAppLayerAttributes, boolean includeRelations, EntityManager em, boolean shouldProcessCache, boolean hideAdminOnly) throws JSONException {
        SelectedContentCache cache = new SelectedContentCache();
        JSONObject o = cache.getSelectedContent(roles, requestURI, proxyPath, app, validXmlTags, includeAppLayerAttributes, includeRelations, em, shouldProcessCache);
        o.put("id", (Object)app.getId());
        o.put("name", (Object)app.getName());
        if (!onlyServicesAndLayers && app.getLayout() != null) {
            o.put("layout", (Object)new JSONObject(app.getLayout()));
        }
        o.put("version", (Object)app.getVersion());
        o.put("title", (Object)app.getTitle());
        o.put("language", (Object)app.getLang());
        o.put("projectionCode", (Object)(app.getProjectionCode() != null ? app.getProjectionCode() : "EPSG:28992[+proj=sterea +lat_0=52.15616055555555 +lon_0=5.38763888888889 +k=0.9999079 +x_0=155000 +y_0=463000 +ellps=bessel +towgs84=565.237,50.0087,465.658,-0.406857,0.350733,-1.87035,4.0812 +units=m +no_defs]"));
        if (!onlyServicesAndLayers) {
            JSONObject d = new JSONObject();
            o.put("details", (Object)d);
            for (Map.Entry e : app.getDetails().entrySet()) {
                if (Application.adminOnlyDetails.contains(e.getKey())) continue;
                d.put((String)e.getKey(), e.getValue());
            }
        }
        if (!onlyServicesAndLayers) {
            if (app.getStartExtent() != null) {
                o.put("startExtent", (Object)app.getStartExtent().toJSONObject());
            }
            if (app.getMaxExtent() != null) {
                o.put("maxExtent", (Object)app.getMaxExtent().toJSONObject());
            }
        }
        if (!onlyServicesAndLayers) {
            em.createQuery("from ConfiguredComponent cc left join fetch cc.details where application = :this").setParameter("this", (Object)app).getResultList();
            JSONObject c = new JSONObject();
            o.put("components", (Object)c);
            for (ConfiguredComponent comp : app.getComponents()) {
                if (!AuthorizationsHelper.isConfiguredComponentAuthorized(comp, roles, em)) continue;
                c.put(comp.getName(), (Object)comp.toJSON(hideAdminOnly));
            }
        }
        return o;
    }
}

